// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "event-date-region.h"

EventDateRegion::EventDateRegion(double hours)
  : EventDate(), duration(hours)
{
}

EventDateRegion::EventDateRegion(const EventDateRegion& orig)
  :EventDate(orig), duration(orig.duration)
{
}

EventDateRegion::~EventDateRegion()
{
}

EventDate EventDateRegion::get_ending_date()
{
  EventDate ending_date(*this);
  ending_date.add_hours(get_duration());
  return ending_date;
}

bool EventDateRegion::straddles(EventDate point)
{
  double starting_at = get_time().as_double();
  double ending_at = starting_at + (get_duration() * 60.0 * 60);

  double now = point.get_time().as_double();
  if (starting_at <= now && (ending_at -1.0) >= now)
    return true;
  return false;
}

double EventDateRegion::overlap_end(EventDate point)
{
  double starting_at = get_time().as_double();
  double ending_at = starting_at + (get_duration() * 60.0 * 60.0);

  double now = point.get_time().as_double();
  return (ending_at - now) / 60 / 60;
}

double EventDateRegion::overlap_start(EventDate point)
{
  double starting_at = get_time().as_double();

  double now = point.get_time().as_double();
  return (now - starting_at) / 60 / 60;
}
