// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef EVENT_DATE_REGION_H
#define EVENT_DATE_REGION_H

#include <gtkmm.h>
#include "event-date.h"

class EventDateRegion: public EventDate
{
    public:

        EventDateRegion(double hours = 0.0);

	//! Copy constructor.
        EventDateRegion(const EventDateRegion& orig);

        //! Destructor.
        virtual ~EventDateRegion();

        EventDate get_ending_date();

        double get_duration() const {return duration;};
        void set_duration(double hours) {duration = hours;};

        bool straddles(EventDate point);
        double overlap_start(EventDate point);
        double overlap_end(EventDate point);

    private:

        //duration, in hours.
        double duration;

};
//bool operator<(const EventDateRegion& lhs, const EventDate& rhs);

#endif //EVENT_DATE_REGION_H
