//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <assert.h>
#include "frame-box.h"

const int contents_pos = 0;

FrameBox::FrameBox(Gtk::HBox *contents, Gdk::Color bg, double row_height, double column_width)
  :Gtk::EventBox(), background_colour(bg), height(row_height), 
    width(column_width)
{
  Gtk::Frame *frame = new Gtk::Frame();
  frame->set_shadow_type(Gtk::SHADOW_OUT);
  frame->set_border_width(2);
  add(*manage(frame));
  set_size_request(column_width, row_height);
  frame->add(*manage(contents));
}

FrameBox::~FrameBox()
{
}

Gtk::HBox *FrameBox::get_contents()
{
  Gtk::Frame *f = dynamic_cast<Gtk::Frame*>(get_child());
  Gtk::HBox *c = dynamic_cast<Gtk::HBox*>(f->get_child());
  return c;
}

void FrameBox::set_box_contents(Gtk::HBox *contents)
{
  update_contents(contents);
}

/*
void FrameBox::update_contents(Gtk::HBox *contents)
{
  Gtk::HBox *frame_contents = get_contents();
  Gtk::Widget *widget = frame_contents->children()[contents_pos].get_widget();
  Gtk::HBox *box = dynamic_cast<Gtk::HBox*>(widget);
  if (box)
    {
  box->children().erase(box->children().begin(), box->children().end());
  box->pack_start(*contents, Gtk::PACK_SHRINK, 0);
  box->show_all();
    }
}
*/
void FrameBox::update_contents(Gtk::HBox *contents)
{
  Gtk::HBox *frame_contents = get_contents();
  Gtk::HBox *box = frame_contents;
  if (box)
    {
  box->children().erase(box->children().begin(), box->children().end());
  box->pack_start(*contents, Gtk::PACK_SHRINK, 0);
  box->show_all();
    }
}
     
void FrameBox::set_background_colour(Gdk::Color background)
{
  if (background != background_colour)
    {
      background_colour = background;
      update_background_colour();
    }
}

Gdk::Color FrameBox::brighten(Gdk::Color col, double factor)
{
  double red = col.get_red_p();
  double green = col.get_green_p();
  double blue = col.get_blue_p();

  double f = 1.00 + factor;
  if (red * f > 1.00)
    red = 1.00;
  else if (red * f <  0.00)
    red = 0.00;
  else
    red *= f;
  if (green * f > 1.00)
    green = 1.00;
  else if (green * f <  0.00)
    green = 0.00;
  else
    green *= f;
  if (blue * f > 1.00)
    blue = 1.00;
  else if (blue * f <  0.00)
    blue = 0.00;
  else
    blue *= f;
  Gdk::Color brighter;
  brighter.set_rgb_p(red, green, blue);
  return brighter;
}

void FrameBox::update_background_colour()
{
  Gtk::Widget *widget = this;
  widget->modify_bg(Gtk::STATE_NORMAL, background_colour);
  Gtk::Frame *f = dynamic_cast<Gtk::Frame*>(get_child());
  f->modify_bg(Gtk::STATE_NORMAL, brighten(background_colour, -0.05));

}
