//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef EVENTBOX_H
#define EVENTBOX_H
#include <gtkmm.h>
#include <string>

#include "frame-box.h"
class Event;
//! A horizontal box containing a channel listing for a single show
/**
 * it's a horizontal box of a certain size, containing another box with some 
 * optional arrows on either side of the box.
 */
class EventBox: public FrameBox
{
 public:
     EventBox(Event *Event, double row_height, double hour_width);
     void set_event(Event *Event);
     void set_show_left_arrow(bool show_arrow);
     void set_show_right_arrow(bool show_arrow);
    ~EventBox();

 private:
    bool show_left_arrow;
    bool show_right_arrow;

    void update_left_arrow();
    void update_right_arrow();

    //helpers
    void update_arrow(int pos, std::string file, bool show);
};

#endif
