// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "load-random-listing.h"

LoadRandomListing::LoadRandomListing(HostList &hosts, std::string file, EventDate starting_time)
  : HostListLoader(hosts, file, starting_time)
{
  reload();
}

LoadRandomListing::~LoadRandomListing()
{
}

void LoadRandomListing::reload()
{
  HostList &channels = hostlist;
  channels.lClear();
  Host *channel;
  Event *show;
  char buf[32];
  std::string genre;
  for (int i = 0; i < atoi(filename.c_str()); i++)
    {
      snprintf (buf, sizeof (buf), "channel %d", i + 1);
      channel = new Host (buf, i + 1);
      channels.add (channel);
      EventDateRegion now = EventDateRegion(starting_at, 0);
  
      now.set_duration(double (((rand () % 4) + 1) * 0.5));
      for (int j = 0; j < 100; j++)
	{
	  snprintf (buf, sizeof (buf), "ch%d show%d", i + 1, j + 1);
	  switch (rand () % 6)
	    {
	    case 0: genre = "pink"; break;
	    case 1: genre = "green"; break;
	    case 2: genre = "red"; break;
	    case 3: genre = "brown"; break;
	    case 4: genre = "grey"; break;
	    case 5: genre = "yellow"; break;
	    }
	  show = new Event (buf, genre, now);
	  channel->add (show);
	  now.add_hours (now.get_duration ());
	  now.set_duration (double (((rand () % 4) + 1) * 0.5));
	}
    }
}

