// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "load-xmltv-listing.h"
#include "xmltv.h"

LoadXmlTvListing::LoadXmlTvListing(HostList &hosts, std::string file, EventDate starting_time)
  : HostListLoader(hosts, file, starting_time)
{
  reload();
}

LoadXmlTvListing::~LoadXmlTvListing()
{
}

Gdk::Color LoadXmlTvListing::genre_to_colour(std::string genre)
{
  if (genre == "Sport")
    return Gdk::Color("green");
  else if (genre == "Film")
    return Gdk::Color("red");
  else if (genre == "Children")
    return Gdk::Color("yellow");
  else if (genre == "Soap")
    return Gdk::Color("brown");
  else if (genre == "News and Current Affairs")
    return Gdk::Color("grey");
  else
    return Gdk::Color("pink");

  return Gdk::Color("black");
}

void LoadXmlTvListing::reload()
{
  hostlist.lClear();
  XmlTv::xmltv *tv = new XmlTv::xmltv;
  if (!tv->init(filename.c_str()))
    return;
  std::vector<XmlTv::channel*> channels;
  tv->get_channels(channels);
  guint32 count = 0;
  for (std::vector<XmlTv::channel*>::iterator it = channels.begin(); 
       it !=  channels.end(); it++)
    {
      count++;
      XmlTv::channel *channel = *it;
      Host *host = new Host(channel->name, count);
      std::vector<XmlTv::program*> programs;
      tv->get_programs_by_channel(channel->id, programs);
      for (std::vector<XmlTv::program*>::iterator i = programs.begin(); 
           i !=  programs.end(); i++)
        {
          XmlTv::program *program = *i;
          Event *event = new Event(program->title, program->category, 
                                   EventDateRegion(program->start_time,
                                                   program->end_time));
          host->add(event);
        }

      hostlist.add(host);
    }
}
