//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <assert.h>
#include "host-box.h"
#include "file.h"
#include "host.h"
#include "boxcompose.h"

const int contents_pos = 0;

HostBox::HostBox(Host* host, bool show_name, bool show_numeric_id, double row_height, double column_width, Pango::AttrList attrs)
  :FrameBox(new Gtk::HBox(), Gdk::Color("black"), row_height, column_width),
    text_attributes(attrs)
{
  Gtk::HBox *contents = get_contents();
  Gtk::HBox *box_contents;
  int numeric_id = host->get_numeric_identifier();
  std::string name = host->get_name();
  if (host->get_friendly_name() != "")
    name = host->get_friendly_name();
  if (show_name && !show_numeric_id)
    box_contents = Box::ucompose(text_attributes, "%1", name);
  else if (!show_name && show_numeric_id && numeric_id >= 0)
    box_contents = Box::ucompose(text_attributes, "%1", numeric_id);
  else if (show_name && show_numeric_id && numeric_id >= 0)
    box_contents = Box::ucompose(text_attributes, "%1 - %2", numeric_id, 
                                 name);
  else if (!show_name && show_numeric_id && numeric_id < 0)
    box_contents = Box::ucompose(text_attributes, "%1", " ");
  else
    box_contents = Box::ucompose(text_attributes, "%1", name);

  contents->pack_start(*manage(box_contents), true, true, 0);
  set_host(host);
}

HostBox::~HostBox()
{
}

void HostBox::set_host(Host *host)
{
  if (is_realized())
    {
      Gtk::HBox *box_contents = Box::ucompose(text_attributes, "%1", host->get_name());
      set_box_contents(box_contents);
    }
  set_background_colour(Gdk::Color("black"));
}
