// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "host-list-loader.h"


HostListLoader::HostListLoader(HostList &hosts, std::string file, EventDate starting_time, ListerolaOptions::Source src_kind, bool &broken)
  :hostlist(hosts), filename(file), starting_at(starting_time), kind(src_kind)
{
}

HostListLoader::~HostListLoader()
{
}


bool HostListLoader::reload()
{
  return true;
}

void HostListLoader::set_listing_file(std::string file)
{
  filename = file;
  reload();
}
