// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "config.h"
#include "listerola-config-saver.h"
#include "listerola-options.h"
#include "listerola-view-options.h"
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>

void
ListerolaConfigSaver::save_to_file(std::string file, ListerolaOptions *listerola_opts, ListerolaViewOptions *listerola_view_opts)
{
  char buf[32];
  xmlTextWriterPtr writer = xmlNewTextWriterFilename(file.c_str(), 0);
  xmlTextWriterSetIndent (writer, 1);
  xmlTextWriterSetIndentString (writer, (const xmlChar*) "  ");
  xmlTextWriterStartDocument (writer, "1.0", NULL, NULL);
  xmlTextWriterStartElement (writer, (const xmlChar*) PACKAGE_NAME);
  xmlTextWriterWriteAttribute (writer, (const xmlChar *)"version", 
                               (const xmlChar *) PACKAGE_VERSION);

  snprintf(buf, sizeof (buf), "%lf", listerola_opts->get_num_rows());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "num_rows",
                             (const xmlChar*) buf);
  snprintf(buf, sizeof (buf), "%lf", listerola_opts->get_duration());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "duration",
                             (const xmlChar*) buf);
  snprintf(buf, sizeof (buf), "%lf", listerola_opts->get_interval());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "interval",
                             (const xmlChar*) buf);
  snprintf(buf, sizeof (buf), "%lf", listerola_opts->get_flipahead_interval());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "flipahead_interval",
                             (const xmlChar*) buf);

  switch (listerola_opts->get_listing_kind())
    {
    case ListerolaOptions::SOURCE_RANDOM:
      xmlTextWriterWriteElement (writer, (const xmlChar*) "source_random",
                                 (const xmlChar*) 
                                 listerola_opts->get_listing_file().c_str());
      break;
    case ListerolaOptions::SOURCE_XMLTV:
      xmlTextWriterWriteElement (writer, (const xmlChar*) "source_xmltv",
                                 (const xmlChar*) 
                                 listerola_opts->get_listing_file().c_str());
      break;
    case ListerolaOptions::SOURCE_MRBS:
      xmlTextWriterWriteElement (writer, (const xmlChar*) "source_mrbs",
                                 (const xmlChar*) 
                                 listerola_opts->get_listing_file().c_str());
      break;
    default:
      break;
    }
  snprintf(buf, sizeof (buf), "%lf", 
           listerola_view_opts->get_refresh_interval());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "refresh_interval",
                             (const xmlChar*) buf);
  snprintf(buf, sizeof (buf), "%lf", 
           listerola_view_opts->get_scroll_speed());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "scroll_speed",
                             (const xmlChar*) buf);
  snprintf(buf, sizeof (buf), "%lf", 
           listerola_view_opts->get_scroll_row_pause());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "row_pause",
                             (const xmlChar*) buf);
  snprintf(buf, sizeof (buf), "%lf", 
           listerola_view_opts->get_vertical_scroll_step());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "vertical_step",
                             (const xmlChar*) buf);

  xmlTextWriterWriteElement (writer, (const xmlChar*) "background_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_background_colour().to_string().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "host_background_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_host_background_colour().to_string().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "header_background_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_header_background_colour().to_string().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "start_in_fullscreen",
                             listerola_view_opts->get_start_in_fullscreen() == 0 ? (const xmlChar*) "false" : (const xmlChar*) "true");
  xmlTextWriterWriteElement (writer, (const xmlChar*) "show_title",
                             listerola_view_opts->get_show_title() == 0 ? (const xmlChar*) "false" : (const xmlChar*) "true");

  xmlTextWriterWriteElement (writer, (const xmlChar*) "title",
                             (const xmlChar*) listerola_view_opts->get_title().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "title_background_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_title_background_colour().to_string().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "event_foreground_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_event_foreground_colour().to_string().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "header_foreground_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_header_foreground_colour().to_string().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "host_foreground_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_host_foreground_colour().to_string().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "title_foreground_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_title_foreground_colour().to_string().c_str());

  std::list<std::string> genres = listerola_view_opts->get_genres();
  for (std::list<std::string>::iterator it = genres.begin(); it != genres.end();
       it++)
    {
      xmlTextWriterStartElement (writer, BAD_CAST "genre");
      Gdk::Color colour = listerola_view_opts->get_genre_colour(*it);
      xmlTextWriterWriteAttribute 
        (writer, (const xmlChar *)"colour", 
         (const xmlChar *) colour.to_string().c_str());
      xmlTextWriterWriteRaw(writer, BAD_CAST (*it).c_str());
      xmlTextWriterEndElement (writer);
    }
  xmlTextWriterWriteElement (writer, (const xmlChar*) "unmatched_genre_background_colour",
                             (const xmlChar*) 
                             listerola_view_opts->get_unmatched_genre_background_colour().to_string().c_str());
  xmlTextWriterWriteElement (writer, (const xmlChar*) "show_host_numbers",
                             listerola_view_opts->get_show_host_numbers() == 0 ? (const xmlChar*) "false" : (const xmlChar*) "true");
  std::list<std::string> hosts = listerola_opts->get_numbered_hosts();
  for (std::list<std::string>::iterator it = hosts.begin(); it != hosts.end();
       it++)
    {
      xmlTextWriterStartElement (writer, BAD_CAST "host_number");
      int number = listerola_opts->get_host_number(*it);
      char buf [32];
      snprintf(buf, sizeof(buf), "%d", number);
      xmlTextWriterWriteAttribute 
        (writer, (const xmlChar *)"number", BAD_CAST buf);
      xmlTextWriterWriteRaw(writer, BAD_CAST (*it).c_str());
      xmlTextWriterEndElement (writer);
    }
  std::list<std::string> names = listerola_opts->get_named_hosts();
  for (std::list<std::string>::iterator it = names.begin(); it != names.end();
       it++)
    {
      xmlTextWriterStartElement (writer, BAD_CAST "host_name");
      std::string name = listerola_opts->get_host_name(*it);
      xmlTextWriterWriteAttribute 
        (writer, (const xmlChar *)"name", BAD_CAST name.c_str());
      xmlTextWriterWriteRaw(writer, BAD_CAST (*it).c_str());
      xmlTextWriterEndElement (writer);
    }
  xmlTextWriterEndElement (writer);
  xmlTextWriterEndDocument (writer);
  xmlFreeTextWriter(writer);
  return;
}
