// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cstdio>
#include <string>
#include <stdlib.h>
#include "main.h"

using namespace std;
int 
main(int argc, char** argv)
{
  Main kit(argc, argv);
  if (argc > 1)
    {
      for (int i = 2; i <= argc; i++)
	{
	  string parameter(argv[i-1]); 
	  if (parameter == "-c")
	    {
	      i++;
              kit.alternate_config_file = argv[i-1];
              FILE *fileptr = fopen (argv[i-1], "r");
              if (!fileptr)
                {
                  cerr << "Error: could not open `" << argv[i-1] << 
                    "' for reading."<< endl;;
                  exit(1);
                }
              fclose(fileptr);
	    }
	  else if (parameter == "--version" || parameter == "-V")
            {
	      cout << PACKAGE_NAME << " " << PACKAGE_VERSION << endl << endl;
	      exit(0);
            }
	  else if (parameter == "--help" || parameter == "-h")
	    {
	      cout << argv[0] << " [OPTION]..." << endl << endl;
	      cout << PACKAGE_NAME << " " << PACKAGE_VERSION << endl << endl;
	      cout << "Options:" << endl << endl; 
	      cout << "  -h, --help                 " << "shows this help screen" <<endl;
	      cout << "  -c <configuration-file>    " << "use an alternative configuration file" <<endl;
	      cout << endl;
	      cout << "Report bugs to" << " <" << PACKAGE_BUGREPORT ">." << endl;
	      exit(0);
	    }
	}
    }
  kit.start_main_loop();
  return 0;
}
