// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "listerola-view-options.h"

const double default_refresh_interval = 24.0; //every day
const double default_scroll_speed = 30.0;
const double default_scroll_row_pause = 500.0;
const double default_vertical_scroll_step = 1.0;
const std::string default_background_colour = "black";
const std::string default_host_background_colour = "light blue";
const std::string default_header_background_colour = "light blue";
const bool default_start_in_fullscreen = false;
const bool default_show_title = true;
const std::string default_title = "";
const std::string default_title_background_colour = "#ffff92b00000";
const std::string default_event_foreground_colour = "black";
const std::string default_header_foreground_colour = "black";
const std::string default_host_foreground_colour = "black";
const std::string default_title_foreground_colour = "white";
const std::string default_unmatched_genre_background_colour = "pink";
const bool default_show_host_numbers = false;

ListerolaViewOptions::ListerolaViewOptions()
  : refresh_interval(default_refresh_interval), 
    scroll_speed(default_scroll_speed),
    scroll_row_pause(default_scroll_row_pause),
    vertical_scroll_step(default_vertical_scroll_step),
    background_colour(Gdk::Color(default_background_colour)),
    host_background_colour(Gdk::Color(default_host_background_colour)),
    header_background_colour(Gdk::Color(default_header_background_colour)),
    start_in_fullscreen(default_start_in_fullscreen),
    show_title(default_show_title), 
    title(default_title),
    title_background_colour(Gdk::Color(default_title_background_colour)),
    event_foreground_colour(default_event_foreground_colour),
    header_foreground_colour(default_header_foreground_colour),
    host_foreground_colour(default_host_foreground_colour),
    title_foreground_colour(default_title_foreground_colour),
    unmatched_genre_background_colour
    (Gdk::Color(default_unmatched_genre_background_colour)),
    show_host_numbers(default_show_host_numbers)

{
  //defaults for genres.
  set_genre_colour("Sport", Gdk::Color("green"));
  set_genre_colour("Film", Gdk::Color("red"));
  set_genre_colour("Children", Gdk::Color("yellow"));
  set_genre_colour("Soap", Gdk::Color("brown"));
  set_genre_colour("News and Current Affairs", Gdk::Color("grey"));
  set_genre_colour("Drama", Gdk::Color("pink"));
}

ListerolaViewOptions::ListerolaViewOptions(ListerolaViewOptions &orig)
  : refresh_interval(orig.refresh_interval), scroll_speed(orig.scroll_speed),
    scroll_row_pause(orig.scroll_row_pause), 
    vertical_scroll_step(orig.vertical_scroll_step),
    background_colour(orig.background_colour),
    host_background_colour(orig.host_background_colour),
    header_background_colour(orig.header_background_colour),
    start_in_fullscreen(orig.start_in_fullscreen), show_title(orig.show_title),
    title(orig.title), title_background_colour(orig.title_background_colour),
    event_foreground_colour(orig.event_foreground_colour),
    header_foreground_colour(orig.header_foreground_colour),
    host_foreground_colour(orig.host_foreground_colour),
    title_foreground_colour(orig.title_foreground_colour),
    genres(orig.genres), 
    unmatched_genre_background_colour(orig.unmatched_genre_background_colour),
    show_host_numbers(orig.show_host_numbers)

{
}

ListerolaViewOptions::~ListerolaViewOptions()
{
}

void ListerolaViewOptions::set_refresh_interval(double hours)
{
  refresh_interval = hours; 
  refresh_interval_changed.emit();
}

void ListerolaViewOptions::set_scroll_speed (double milliseconds)
{
  scroll_speed = milliseconds; 
  scroll_speed_changed.emit();
}

void ListerolaViewOptions::set_scroll_row_pause(double microseconds)
{
  scroll_row_pause = microseconds; 
  scroll_row_pause_changed.emit();
}

void ListerolaViewOptions::set_vertical_scroll_step(double pixels)
{
  vertical_scroll_step = pixels; 
  vertical_scroll_step_changed.emit();
}

void ListerolaViewOptions::set_background_colour(Gdk::Color colour)
{
  background_colour = colour;
  background_colour_changed.emit();
}

void ListerolaViewOptions::set_host_background_colour(Gdk::Color colour)
{
  host_background_colour = colour;
  host_background_colour_changed.emit();
}

void ListerolaViewOptions::set_header_background_colour(Gdk::Color colour)
{
  header_background_colour = colour;
  header_background_colour_changed.emit();
}

void ListerolaViewOptions::set_start_in_fullscreen(bool start)
{
  start_in_fullscreen = start;
  start_in_fullscreen_changed.emit();
}

void ListerolaViewOptions::set_show_title(bool show)
{
  show_title = show;
  show_title_changed.emit();
}

void ListerolaViewOptions::set_title(std::string name)
{
  title = name;
  title_changed.emit();
}

void ListerolaViewOptions::set_title_background_colour(Gdk::Color colour)
{
  title_background_colour = colour;
  title_background_colour_changed.emit();
}

void ListerolaViewOptions::set_event_foreground_colour(Gdk::Color colour)
{
  event_foreground_colour = colour;
  event_foreground_colour_changed.emit();
}

void ListerolaViewOptions::set_host_foreground_colour(Gdk::Color colour)
{
  host_foreground_colour = colour;
  host_foreground_colour_changed.emit();
}

void ListerolaViewOptions::set_header_foreground_colour(Gdk::Color colour)
{
  header_foreground_colour = colour;
  header_foreground_colour_changed.emit();
}

void ListerolaViewOptions::set_title_foreground_colour(Gdk::Color colour)
{
  title_foreground_colour = colour;
  title_foreground_colour_changed.emit();
}

std::list<std::string> ListerolaViewOptions::get_genres()
{
  std::list<std::string> g;
  std::map<std::string, Gdk::Color>::iterator it = genres.begin();
  for (; it != genres.end(); it++)
    g.push_back((*it).first);
  return g;
}

Gdk::Color ListerolaViewOptions::get_genre_colour(std::string genre)
{
  std::map<std::string, Gdk::Color>::iterator it;
  it = genres.find(genre);
  if (it == genres.end())
    return unmatched_genre_background_colour;
  return (*it).second;
}
        
void ListerolaViewOptions::set_genre_colour(std::string genre, Gdk::Color colour)
{
  std::map<std::string, Gdk::Color>::iterator it;
  it = genres.find(genre);
  if (it != genres.end())
    (*it).second = colour;
  else
    genres[genre] = colour;
  genre_colours_changed.emit();
}
        
void ListerolaViewOptions::clear_genre_colour(std::string genre)
{
  std::map<std::string, Gdk::Color>::iterator it;
  it = genres.find(genre);
  if (it != genres.end())
    {
      genres.erase(it);
      genre_colours_changed.emit();
    }
}

void ListerolaViewOptions::set_unmatched_genre_background_colour(Gdk::Color colour)
{
  unmatched_genre_background_colour = colour;
  unmatched_genre_background_colour_changed.emit();
}

void ListerolaViewOptions::set_show_host_numbers(bool show)
{
  show_host_numbers = show;
  show_host_numbers_changed.emit();
}
