// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef LISTEROLA_H
#define LISTEROLA_H

#include <gtkmm.h>
#include "event-date-region.h"
#include "host-list.h"
#include "host-list-loader.h"
#include "listerola-options.h"
#include <sigc++/connection.h>
#include "sigc++/signal.h"
#include <sigc++/trackable.h>
class HostedEventList;

class Host;
class Event;
class HostList;

class Listerola: public sigc::trackable
{
    public:

	//! Default constructor.
	Listerola(ListerolaOptions &opts);

	//! Destructor.
        ~Listerola();

        EventDateRegion get_current_date() const {return current_event_time;};
        void set_current_date(EventDateRegion now) {current_event_time = now;};

        HostedEventList get_events(Host *host = NULL);

        double get_duration() {return opts.get_duration();};

        double get_num_rows() {return opts.get_num_rows();};

        std::string get_listing_file() const {return opts.get_listing_file();};
        void set_listing_file(std::string f, ListerolaOptions::Source kind);
        void reload_listing_file();
        double get_interval() const {return opts.get_interval();};
        double get_flipahead_interval() {return opts.get_flipahead_interval();};
        EventDate get_last_refresh_date() const {return refresh_date;};

        HostList& get_host_list() {return channels;};

        void next();
        double overlap_end(Event *event);
        double overlap_start(Event *event);

        bool flip_ahead_to_next_interval();

        std::list<std::string> get_genres();
        int get_host_number(std::string n) {return opts.get_host_number(n);};
        std::list<std::string> get_host_names();

        sigc::signal<void> options_changed;
        sigc::signal<void> listing_file_changed;
        sigc::signal<void> bad_listing_file;
    private:
        HostList channels;

        HostListLoader *host_list_loader;

        ListerolaOptions &opts;

        //! The window of time that we're interested in.
        EventDateRegion current_event_time;

        //! When the listing file was last read.
        EventDate refresh_date;

        //! helper functions
        void update_host_list_loader();
        void sort_host_list();
        static bool sort_by_numeric_id(const Host *lhs, const Host *rhs);

        //! Callbacks
        void on_duration_changed();
        void on_listing_file_changed();
        void on_host_numbers_changed();
        void on_host_names_changed();

        void on_bad_file_format(); //remove me
};

#endif //LISTEROLA_H
