//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef ADD_GENRE_COLOUR_DIALOG_H
#define ADD_GENRE_COLOUR_DIALOG_H

#include <gtkmm.h>
#include <list>
#include <string>

class AddGenreColourDialog
{
 public:
    AddGenreColourDialog(std::list<std::string> uncoloured_genres);
    ~AddGenreColourDialog();

    void set_parent_window(Gtk::Window &parent);

    void hide();

    int run();

    std::pair<std::string, Gdk::Color> get_genre_colour() const {return genre_colour;};

 private:
    Gtk::Dialog* dialog;
    std::list<std::string> uncoloured_genres;
    std::pair<std::string, Gdk::Color> genre_colour;

    Gtk::Entry *genre_entry;
    Gtk::ColorButton *genre_colorbutton;
    Gtk::TreeView *genres_treeview;

    class GenresColumns: public Gtk::TreeModelColumnRecord {
    public:
	GenresColumns() 
        { add(genre); }
	
	Gtk::TreeModelColumn<Glib::ustring> genre;
    };
    const GenresColumns genres_columns;
    Glib::RefPtr<Gtk::ListStore> genres_list;
 private:
    void add_genre(std::string genre);
    void on_genre_selected();
};

#endif
