//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef DRIVER_H
#define DRIVER_H

#include <memory>
#include <string>
#include <sigc++/trackable.h>

#include "listerola-window.h"
#include "preferences-window.h"
#include "listerola-options.h"
#include "listerola-view-options.h"

class Driver: public sigc::trackable
{
 public:
    Driver(std::string config_filename);
    ~Driver();

    void run();

 private:
    Listerola *listerola;
    ListerolaOptions *listerola_opts;
    ListerolaViewOptions *listerola_view_opts;
    ListerolaWindow *listerola_window;
    std::string config_filename;

    PreferencesWindow *preferences_window;

    void on_quit_requested();
    void on_preferences_requested(std::list<std::string> uncoloured_genres,
                                  std::list<std::string> host_names);
    void on_save_configuration_requested();
};

#endif
