//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <assert.h>
#include "event-box.h"
#include "file.h"
#include "hosted-event.h"
#include "boxcompose.h"
#include "host-box.h"

const int left_arrow_pos = 0;
const int contents_pos = 1;
const int right_arrow_pos = 2;

EventBox::EventBox(HostedEvent* event, double row_height, double column_width, Pango::AttrList attrs)
  :FrameBox(new Gtk::HBox(), Gdk::Color("black"), row_height, column_width), 
    show_left_arrow(false), show_right_arrow(false), text_attributes(attrs)
{
  hosted_event = event;
  Gtk::HBox *contents = get_contents();
  Gtk::Image *left_arrow_image = new Gtk::Image();
  contents->pack_start(*manage(left_arrow_image), Gtk::PACK_SHRINK, 0);
  Gtk::HBox *box_contents = Box::ucompose(text_attributes, "%1", event->get_name());
  contents->pack_start(*manage(box_contents), true, true, 0);
  Gtk::Image *right_arrow_image = new Gtk::Image();
  contents->pack_start(*manage(right_arrow_image), Gtk::PACK_SHRINK, 0);
  set_event(event);
}

EventBox::~EventBox()
{
  if (hosted_event)
    delete hosted_event;
}

void EventBox::set_show_left_arrow(bool show_arrow)
{
  if (show_left_arrow != show_arrow)
    {
      show_left_arrow = show_arrow;
      update_left_arrow();
    }
}

void EventBox::set_show_right_arrow(bool show_arrow)
{
  if (show_arrow != show_right_arrow)
    {
      show_right_arrow = show_arrow;
      update_right_arrow();
    }
}

void EventBox::update_arrow(int pos, std::string file, bool show_arrow)
{
  Gtk::HBox *contents = get_contents();
  Gtk::Widget *widget = contents->children()[pos].get_widget();
  Gtk::Image *image = dynamic_cast<Gtk::Image*>(widget);
  Glib::RefPtr<Gdk::Pixbuf> buf = Gdk::Pixbuf::create_from_file(file);
  image->property_pixbuf() = buf;
  if (show_arrow == false)
    {
      image->clear();
      image->set_size_request(buf->get_width(), buf->get_height());
    }
  image->show_all();
}

void EventBox::update_left_arrow()
{
  update_arrow(left_arrow_pos, File::get_data_path() + "/left.png", show_left_arrow);
}
    
void EventBox::update_right_arrow()
{
  update_arrow(right_arrow_pos, File::get_data_path() + "/right.png", show_right_arrow);
}
    
void EventBox::set_event(HostedEvent *event)
{
  if (hosted_event)
    delete hosted_event;
  hosted_event = event;
  if (is_realized())
    {
      Gtk::HBox *box_contents = Box::ucompose(text_attributes, "%1", event->get_name());
      set_box_contents(box_contents);
    }
  update_background_colour();
  update_left_arrow ();
  update_right_arrow ();
}

