//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <assert.h>
#include "hole-box.h"

HoleBox::HoleBox(Gdk::Color bg, double row_height, double column_width)
  :Gtk::EventBox(), background_colour(bg), height(row_height), 
    width(column_width)
{
  Gtk::HBox *box = new Gtk::HBox();
  add(*manage(box));
  set_size_request(column_width, row_height);
}

HoleBox::~HoleBox()
{
}

void HoleBox::set_background_colour(Gdk::Color background)
{
  if (background != background_colour)
    {
      background_colour = background;
      update_background_colour();
    }
}

void HoleBox::update_background_colour()
{
  Gtk::Widget *widget = this;
  widget->modify_bg(Gtk::STATE_NORMAL, background_colour);
}
