// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef LISTEROLA_OPTIONS_H
#define LISTEROLA_OPTIONS_H

#include <sigc++/connection.h>
#include <sigc++/signal.h>
#include <gtkmm.h>

class ListerolaOptions
{
    public:

        enum Source {
          SOURCE_NONE = 0,
          SOURCE_RANDOM,
          SOURCE_XMLTV,
          SOURCE_MRBS,
        };
	//! Default constructor.
	ListerolaOptions();

        //! Copy constructor.
	ListerolaOptions(ListerolaOptions &options);

	//! Destructor.
        ~ListerolaOptions();

        double get_num_rows() const {return num_rows;};
        void set_num_rows(double rows);
        sigc::signal<void> num_rows_changed;

        double get_duration() const {return duration;};
        void set_duration(double hours);
        sigc::signal<void> duration_changed;

        double get_interval() const {return interval;};
        void set_interval(double interval);
        sigc::signal<void> interval_changed;

        double get_flipahead_interval() const {return flip_interval;};
        void set_flipahead_interval(double flip_interval);
        sigc::signal<void> flipahead_interval_changed;

        std::string get_listing_file() const {return listing_file;};
        Source get_listing_kind() const {return listing_kind;};
        void clear_listing_file();
        void set_xmltv_listing_file(std::string file);
        void set_mrbs_listing_file(std::string file);
        void set_random_listing_file(std::string file);
        sigc::signal<void> listing_file_changed;

        int get_host_number (std::string host);
        std::list<std::string> get_numbered_hosts();
        void set_host_number(std::string host, int number);
        void clear_host_number(std::string host);
        sigc::signal<void> host_numbers_changed;

        std::string get_host_name(std::string host);
        std::list<std::string> get_named_hosts();
        void set_host_name(std::string host, std::string name);
        void clear_host_name(std::string host);
        sigc::signal<void> host_names_changed;
    private:
        //! how many channels we want to list at once.
        double num_rows;

        //! how many hours the time window shows from now.
        double duration;

        //! how often an event generally is
        double interval;

        //! how far in advance we flip ahead to the next interval
        double flip_interval;

        //! the data source
        std::string listing_file;
        enum Source listing_kind;

        //! Map of host name to numeric ids.
        std::map<std::string, int> host_numbers;

        //! Map of host name to numeric ids.
        std::map<std::string, std::string> host_names;
};

#endif //LISTEROLA_OPTIONS_H
