//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef PREFERENCES_WINDOW_H
#define PREFERENCES_WINDOW_H

#include <gtkmm.h>
#include <list>
#include <string>
#include <sigc++/signal.h>
#include "listerola-options.h"
#include "listerola-view-options.h"

class PreferencesWindow
{
 public:
    PreferencesWindow(ListerolaOptions &listerola_options,
                      ListerolaViewOptions &listerola_view_options,
                      std::list<std::string> uncoloured_genres,
                      std::list<std::string> host_names);
    ~PreferencesWindow();

    std::list<std::string> get_genres() const {return uncoloured_genres;};
    void set_genres(std::list<std::string> g) {uncoloured_genres = g;};
    std::list<std::string> get_host_names() const {return host_names;};
    void set_host_names(std::list<std::string> h) {host_names = h;};
    void show();
    void hide();
    
    sigc::signal<void> save_configuration_requested;
    void on_bad_listing_file_loaded();
 private:
    ListerolaOptions &listerola_options;
    ListerolaViewOptions &listerola_view_options;
    std::list<std::string> uncoloured_genres;
    std::list<std::string> host_names;
    Gtk::Window *window;
    Gtk::Button *close_button;
    Gtk::SpinButton *num_rows_spinbutton;
    Gtk::SpinButton *duration_spinbutton;
    Gtk::SpinButton *interval_spinbutton;
    Gtk::SpinButton *flipahead_interval_spinbutton;
    Gtk::RadioButton *none_radiobutton;
    Gtk::RadioButton *xmltv_radiobutton;
    Gtk::RadioButton *mrbs_radiobutton;
    Gtk::FileChooserButton *xmltv_filechooserbutton;
    Gtk::FileChooserButton *mrbs_filechooserbutton;
    Gtk::CheckButton *refresh_checkbutton;
    Gtk::SpinButton *refresh_spinbutton;
    Gtk::SpinButton *speed_spinbutton;
    Gtk::SpinButton *pause_spinbutton;
    Gtk::SpinButton *step_spinbutton;
    Gtk::ColorButton *window_bg_colorbutton;
    Gtk::ColorButton *host_bg_colorbutton;
    Gtk::ColorButton *header_bg_colorbutton;
    Gtk::CheckButton *fullscreen_checkbutton;
    Gtk::Button *refresh_button;
    Gtk::CheckButton *title_checkbutton;
    Gtk::Entry *title_entry;
    Gtk::ColorButton *title_bg_colorbutton;
    Gtk::ColorButton *event_fg_colorbutton;
    Gtk::ColorButton *host_fg_colorbutton;
    Gtk::ColorButton *header_fg_colorbutton;
    Gtk::ColorButton *title_fg_colorbutton;
    Gtk::Button *add_genre_button;
    Gtk::Button *remove_genre_button;
    Gtk::Button *edit_genre_button;
    Gtk::ColorButton *unmatched_genre_bg_colorbutton;
    Gtk::CheckButton *show_host_numbers_checkbutton;
    Gtk::TreeView *genre_treeview;

    class GenreColumns: public Gtk::TreeModelColumnRecord {
    public:
        GenreColumns()
          { add(name); add(colour); }
        Gtk::TreeModelColumn<Glib::ustring> name;
        Gtk::TreeModelColumn<Gdk::Color> colour;
    };
    const GenreColumns genre_columns;
    Glib::RefPtr<Gtk::ListStore> genre_list;
    Gtk::CellRendererText name_renderer;
    Gtk::TreeViewColumn name_column;
    void cell_data_name(Gtk::CellRenderer *renderer, const Gtk::TreeIter &i);
    void on_name_edited(const Glib::ustring &path, const Glib::ustring &new_text);
    void add_genre (Glib::ustring name, Gdk::Color colour);
    Gtk::TreeView *host_treeview;

    class HostColumns: public Gtk::TreeModelColumnRecord {
    public:
        HostColumns()
          { add(true_name); add(name); add(number); }
        Gtk::TreeModelColumn<Glib::ustring> true_name;
        Gtk::TreeModelColumn<Glib::ustring> name;
        Gtk::TreeModelColumn<int> number;
    };
    const HostColumns host_columns;
    Glib::RefPtr<Gtk::ListStore> host_list;
    Gtk::CellRendererText host_name_renderer;
    Gtk::TreeViewColumn host_name_column;
    void cell_data_host_name(Gtk::CellRenderer *renderer, const Gtk::TreeIter &i);
    void on_host_name_edited(const Glib::ustring &path, const Glib::ustring &new_text);
    Gtk::CellRendererSpin host_number_renderer;
    Gtk::TreeViewColumn host_number_column;
    void add_host (Glib::ustring name, int number);
    void cell_data_host_number(Gtk::CellRenderer *renderer, const Gtk::TreeIter& i);
    void on_host_number_edited(const Glib::ustring &path, const Glib::ustring &new_text);

    //! helpers
    void update_radiobuttons();
    void update_genre_buttons();

    //! Callbacks

    void on_close_clicked();
    void on_num_rows_changed();
    void on_num_rows_text_changed(const Glib::ustring &s, int *p);
    void on_duration_changed();
    void on_duration_text_changed(const Glib::ustring &s, int *p);
    void on_interval_changed();
    void on_interval_text_changed(const Glib::ustring &s, int *p);
    void on_flipahead_interval_changed();
    void on_flipahead_interval_text_changed(const Glib::ustring &s, int *p);
    void on_none_toggled();
    void on_xmltv_toggled();
    void on_mrbs_toggled();
    void on_xmltv_changed();
    void on_mrbs_changed();
    void on_refresh_toggled();
    void on_refresh_changed();
    void on_refresh_text_changed(const Glib::ustring &s, int *p);
    void on_speed_changed();
    void on_speed_text_changed(const Glib::ustring &s, int *p);
    void on_pause_changed();
    void on_pause_text_changed(const Glib::ustring &s, int *p);
    void on_step_changed();
    void on_step_text_changed(const Glib::ustring &s, int *p);
    void on_background_colour_changed();
    void on_host_background_colour_changed();
    void on_header_background_colour_changed();
    void on_title_background_colour_changed();
    void on_fullscreen_toggled();
    void on_refresh_clicked();
    void on_title_toggled();
    void on_title_changed();
    void on_event_foreground_colour_changed();
    void on_host_foreground_colour_changed();
    void on_header_foreground_colour_changed();
    void on_title_foreground_colour_changed();
    void on_add_genre_colour_clicked();
    void on_remove_genre_colour_clicked();
    void on_edit_genre_colour_clicked();
    void on_unmatched_genre_background_colour_changed();
    void on_genre_selected();
    void on_show_host_numbers_toggled();
};

#endif
