/*
 * @file xmltv.lib/xmltv.h XMLTV Parser Class
 *
 * atvguide -- a collection of helper libraries and a GTK+ frontend for XMLTV
 * Copyright (C) 2004  Andrew Ayer
 * Copyright (C) 2010  Ben Asselstine
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 * 02110-1301, USA.
*/


#ifndef XMLTV_H
#define XMLTV_H

#include <istream>
#include <vector>
#include <libxml/tree.h>

#include "xmltv-program.h"
#include "xmltv-channel.h"

namespace XmlTv {
class xmltv {
	xmlDocPtr		xml_doc;
	xmlNodePtr		xml_root;

public:
	xmltv ();		// Constructor.
	~xmltv ();		// Destructor.

	bool			init (const char*); // Initializer.  Takes path to XMLTV file.

	xmltv&			operator= (const xmltv&);

	// Get list of available channels.
	void			get_channels(std::vector<channel*>&);
	// Get list of all shows airing on channel.
	void			get_programs_by_channel(const char*, std::vector<program*>&);
	// Get list of all shows airing at exact time.
	void			get_programs_by_time(time_t, std::vector<program*>&);
	// Get list of all shows starting between time1 and time2.
	void			get_programs_by_start_time(time_t time1, time_t time2, std::vector<program*>&);
};
};

#endif // XMLTV_H
