# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 67 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QListView, QCheckListItem

#-- Python imports
import logging
import sys
import os
import re

from urllib import urlopen
from os.path import exists as fexists, splitext, dirname

#-- own imports
from RecordPreviewBase import RecordPreviewBase
from misc import openResource
from Settings import getPreferences



#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)


#-- mappings -------------------------------------------------------------------
# defines all fields in-order in which they
# will be added to the ListView
labelList = [
    'Original Title',
    'Translated Title',
    'Actors',
    'Category',
    'Length',
    'Language',
    'Director',
    'Producer',
    'Country',
    'Year',
    'Image',
    'URL',
    'Rating',
    'Description',
    'Comment',
    ]


# defines a map: input token -> field label
tag2label = {
    'originalTitle': 'Original Title',
    'year': 'Year',
    'picture': 'Image',
    'director': 'Director',
    'category': 'Category',
    'actors': 'Actors',
    'rating': 'Rating',
    'url': 'URL',
    'length': 'Length',
    'country': 'Country',
    'languages': 'Language',
    'description': 'Description',
    'comments': 'Comment',
    'translatedTitle': 'Translated Title',
    'producer': 'Producer',
    }



class RecordPreview(RecordPreviewBase):
    """displays all fields of a record in a selectable list"""
    def __init__(self, parent=None, name=None, modal=False, fl=0):
        RecordPreviewBase.__init__(self, parent, name, modal, fl)

        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel(pref['logLevel'])

        # adjust display
        self.listViewRecord.setSorting(0, False)

        # runtime variables
        self.fieldMap = {}              # maps '<label>' -> object              
        self.record = {}

        # add empty fields
        for f in labelList:
            obj = QCheckListItem(self.listViewRecord, f, QCheckListItem.CheckBox)
            obj.setMultiLinesEnabled(True)
            self.fieldMap[f] = obj


    def getSelected(self):
        """returns a dictionary with all fields that are tagged"""       
        rec = {}
        # retrieve record
        # note: 'picture' is set to url
        for f in self.record:
            obj = self.fieldMap[tag2label[f]]
            if (obj.state() == QCheckListItem.On):
                rec[f] = self.record[f]            
        return rec


    def parseScriptInput(self, text):
        """parses a script output and extracts field information

        Return: status value
        """
        lines = text.split("\n")
        record = None
        status = None
        for line in lines:
            if (line == ""): continue
            (field, value) = line.split(": ", 1)

            if (field == "status"):
                status = value
                if (value != "details"):
                    self.log.warning("Wrong status: %s; skipping", value)
                    return value

            # if input field is supported
            elif (tag2label.has_key(field)):
                self.formatField(field, value)

            # invalid field: ignore
            else:
                self.log.warning("Unknown field specifier %s; ignoring", field, value)
                continue

        # display values in form
        for k in self.record.keys():
            obj = self.fieldMap[tag2label[k]]
            obj.setText(1, self.record[k].replace("\n", " "))
            obj.setState(QCheckListItem.On)

        # on success return true
        if (len(self.record.keys()) == 0):
            return "empty"
        return status
        

    def formatField(self, field, value):
        """formats a field in the record

        This handles concatenations of multiple occurances of a field
        in the script's output stream.

        It also translates <br> to newline characters \\n and collapses
        multiple newlines.
        """
        # convert <br> to newlines
        value = value.replace("<br>", "\n");
        # collapse multiple white-characters
        tmp = ""
        while (value != tmp):
            tmp = value
            value = re.sub('(?s)\s{2,}', ' ', tmp)
        # first assignment to the field
        if (not self.record.has_key(field)):
            self.record[field] = value
            return
        # simple concatenation with ", "
        if (field in ['country', 'language', 'director', 'category', 'producer']):
            self.record[field] += ", "+value
        # join with paragraph
        elif (field in ['description', 'comments']):
            self.record[field] += "\n\n"+value
        # join with empty line
        elif (field in ['actors']):
            self.record[field] += "\n"+value
        # overwrite previous setting
        else:
            self.record[field] = value


#-- testroutine ----------------------------------------------------------------
if (__name__ == '__main__'):
    import os
    from qt import QApplication, QObject, SIGNAL, SLOT
    
    a = QApplication(sys.argv)
    QObject.connect(a,SIGNAL("lastWindowClosed()"),a,SLOT("quit()"))
    w = RecordPreview()

    (chin, chout, cherr) = os.popen3("scripts/IMDB-en.pl http://www.imdb.com/title/tt0120685/", "r")
    text = unicode(chout.read(), 'latin1')
    error = unicode(cherr.read(), 'latin1')
    chin.close()
    chout.close()
    cherr.close()

    w.parseScriptInput(text)

    a.setMainWidget(w)
    w.show()

    a.exec_loop()

    print w.getSelected()
    

#-- EOF --
