# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 163 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import SIGNAL


#-- Python imports
import logging


#-- own imports
from ChangeNumberDialogBase import ChangeNumberDialogBase
from Settings import getPreferences

#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)


class ChangeNumberDialog(ChangeNumberDialogBase):
    """allows changing the number of a record"""
    def __init__(self, parent=None, name=None, modal=False, fl=0):
        ChangeNumberDialogBase.__init__(self, parent, name, modal, fl)

        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # connect signals
        self.connect(self.radioButtonSwap, SIGNAL("stateChanged(int)"), self.onSwapStateChanged)
        self.connect(self.radioButtonInsert, SIGNAL("stateChanged(int)"), self.onInsertStateChanged)
        self.connect(self.radioButtonSet, SIGNAL("stateChanged(int)"), self.onSetStateChanged)


    def onSwapStateChanged(self, state):
        """called when swap radio button changes state"""
        self.spinBoxSwap.setEnabled(state)

        
    def onInsertStateChanged(self, state):
        """called when insert radio button changes state"""
        self.spinBoxInsert.setEnabled(state)
        
        
    def onSetStateChanged(self, state):
        """called when set radio button changes state"""
        self.spinBoxSet.setEnabled(state)
    
    
    def keyPressEvent(self, e):
        """called when return button pressed"""
        # return causes accept
        if (e.key() in [self.Key_Enter, self.Key_Return]):
            self.accept()
        # escape closes dialog
        elif (e.key() == self.Key_Escape):
            self.reject()
        # other events are ignored
        else:
            e.ignore()


    def getNumber(self):
        """returns the number set in a spin box"""
        return (self.spinBoxSwap.isEnabled() and self.spinBoxSwap.value()) or \
               (self.spinBoxInsert.isEnabled() and self.spinBoxInsert.value()) or \
               (self.spinBoxSet.isEnabled() and self.spinBoxSet.value()) or None


    def getState(self):
        """returns which radio button is selected"""
        return (self.radioButtonFirstFree.isChecked() and "first") or \
               (self.radioButtonSwap.isChecked() and "swap") or \
               (self.radioButtonInsert.isChecked() and "insert") or \
               (self.radioButtonSet.isChecked() and "set")
        
        

#-- testroutine ----------------------------------------------------------------
if (__name__ == "__main__"):
    from qt import QApplication, QObject, SIGNAL, SLOT
    import sys

    a = QApplication(sys.argv)
    QObject.connect(a,SIGNAL("lastWindowClosed()"),a,SLOT("quit()"))

    # need logging handlers for testing
    log = logging.getLogger("")
    hdlr = logging.StreamHandler()
    formatter = logging.Formatter('[%(name)s] %(levelname)s: %(message)s')
    hdlr.setFormatter(formatter)
    log.addHandler(hdlr) 
    log.setLevel(pref['logLevel'])


    w = ChangeNumberDialog()

    a.setMainWidget(w)
    w.show()

    a.exec_loop()

    print "result: ",w.getState(), w.getNumber()
