# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 692 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QImage, QPixmap, QLabel, QGridLayout, PYSIGNAL
from qt import QImageDrag, QDragObject, QUriDrag, QStringList


#-- Python imports
import logging
import sys
import os


#-- own imports
from Settings import getPreferences
from misc import openResource


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)



class XMozUrlDrag(QDragObject):
    """handles decoding of mozillas x-modz-url mime-type"""
    log = logging.getLogger('XMozUrlDrag')

    
    def __init__(self, dragSource=None, name=None):
        QDragObject.__init__(self, dragSource, name)
        log.setLevel(pref['logLevel'])


    def canDecode(cls, e):
        """queried wether the Mime-Type is supported"""
        # this is not entirely correct:
        # 1. its not sure the contained url points to an image
        # 2. its not certain the image can be decoded
        return e.provides("text/x-moz-url")
    canDecode=classmethod(canDecode)


    def decode(cls, e, img):
        """decodes an image from URL and returns a QImage instance"""
        # check wether can decode this type
        if (not cls.canDecode(e)): return False
        
        # check type is http url
        url = str(e.data("text/x-moz-url")) # QByteArray -> byte string
        url = unicode(url, 'utf16').split("\n", 1)[0] # byte string -> unicode

        # load to data
        try:
            f = openResource(url)
            data = f.read()
            f.close()
        except IOError, e:
            cls.log.error("Could not retrieve data from %s: %s", url, unicode(e))
            return False

        # load image
        if (img.loadFromData(data)): return True       
        return False
    decode = classmethod(decode)



class URIListDrag(QUriDrag):
    """handles decoding of drags from image by the filebrowser"""
    log = logging.getLogger('URIListDrag')


    def __init__(self, uris, dragSource=None, name=None):
        QUriDrag.__init__(self, uris, dragSource, name)
        log.setLevel(pref['logLevel'])
        

    def decode(cls, e, img):
        """decodes an image from the URI and returns a QImage instance"""
        # check wether can decode this type
        if (not cls.canDecode(e)): return False

        # get contents (of the form: file:/home/...)
        lines = QStringList()
        if (not QUriDrag.decodeLocalFiles(e, lines)): return False
        if len(lines) == 0:
            cls.log.warning("Loading remote files not yet supported")
            return False
        filename = unicode(lines[0])    # convert QString -> unicode

        # load data
        try:
            f = openResource(filename)
            data = f.read()
            f.close()
        except IOError, e:
            cls.log.error("Could not retrieve data from %s: %s", filename, unicode(e))
            return False

        # load image
        if (img.loadFromData(data)): return True
        return False
    decode = classmethod(decode)

        

#-- testroutine ----------------------------------------------------------------
if (__name__ == '__main__'):
    pass
