# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 766 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------

#-- Python imports
import logging


#-- own imports
from ExportDialogBase import ExportDialogBase
from Settings import getPreferences
from misc import Date2YMD
from AMCFile33 import AMCRecord33

#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)


# mapps AMC field names to text strings
AMCField2name = {
    'number': 'Id',
    'date': 'Date',
    'rating': 'Rating',
    'year': 'Year',
    'length': 'Length',
    'discs': 'Discs',
#    'checked': 'Checked',
#    'videoBitrate': 'Video Bitrate',
#    'audioBitrate': 'Audio Bitrate',
    'mediaLabel': 'Media Label',
    'mediaType': 'Media Type',
    'source': 'Location',
    'borrower': 'Borrower',
    'originalTitle': 'Original Title',
    'translatedTitle': 'Translated Title',
    'director': 'Director',
    'producer': 'Producer',
    'country': 'Country',
    'category': 'Category',
    'actors': 'Actors',
#    'url': 'URL',
    'description': 'Description',
    'comments': 'Comments',
#    'videoFormat': 'Video Format',
#    'audioFormat': 'Audio Format',
    'resolution': 'Resolution',
    'framerate': 'Framerate',
    'languages': 'Languages',
    'subtitles': 'Subtitles',
    'fileSize': 'File Size',
#    'picture': 'Picture',
#    'embeddedImage': 'Embedded Image',
    }



class ExportDialog(ExportDialogBase):
    """displays export dialog"""
    def __init__(self, parent=None, name=None, modal=False,fl=0):
        ExportDialogBase.__init__(self, parent, name, modal, fl)

        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # runtime variables
        self.exportList = []
        self.sortFields = []

        # load available export scripts
        for key in pref['export'].keys():
            self.exportFilterComboBox.insertItem(key)
            self.exportList.append(key)

        # load available sort criterea
        record = AMCRecord33()
        defaultIndex = 0
        for key in record.keys():
            if (AMCField2name.has_key(key)):
                self.sortComboBox.insertItem(AMCField2name[key])
                self.sortFields.append(key)

                if (key == pref['exportDefaultSortKey']):
                    defaultIndex = len(self.sortFields)-1

        # set default sort key
        self.sortComboBox.setCurrentItem(defaultIndex)


    def getOptions(self):
        """return tuple of selected options"""
        # export filter
        exportFilterIdx = self.exportFilterComboBox.currentItem()
        exportFilter = self.exportList[exportFilterIdx]

        # sort criterea
        sortFieldIdx = self.sortComboBox.currentItem()
        sortField = self.sortFields[sortFieldIdx]

        # selection or all entries
        allEntries = True
        if (self.selectedEntriesRadioButton.isChecked()):
            allEntries = False

        # ascending or descending
        ascending = True
        if (self.descendingRadioButton.isChecked()):
            ascending = False

        return (exportFilter, sortField, allEntries, not ascending)

                                


if (__name__ == '__main__'):
    pass
    
