#!/usr/bin/python
# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 762 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-------------------------------------------------------------------------------

import sys
import stringtemplate
import logging
import Settings

from AMCFile33 import AMCFile33, AMCRecord33
from misc import Date2YMD

from exceptions import Exception, IndexError
from os.path import join as fjoin


#-- help screen ----------------------------------------------------------------
if ((len(sys.argv) < 3) or ('-h' in sys.argv[1:]) or ('--help' in sys.argv[1:])):
    print """\
templateParser.py   $Rev: 762 $  (c) 2007 by Uwe Mayer

Syntax: templateParser.py <template-name> <amc-file>
"""
    sys.exit()
#-------------------------------------------------------------------------------

def indent(text, indent=0):
    return "\n".join( (" "*indent+x for x in text.split('\n')) )


#-- command line arguments
template_name = sys.argv[1]
amc_filename  = sys.argv[2]

#-- logging
prefs = Settings.getPreferences()


log = logging.getLogger("")
hdlr = logging.StreamHandler()
formatter = logging.Formatter('[%(name)s] %(levelname)s: %(message)s')
hdlr.setFormatter(formatter)
log.addHandler(hdlr)
log.setLevel(logging.DEBUG)

#-- open amc file
try:
    f = AMCFile33(amc_filename, 'rb')
except Exception, e:
    log.error("Could not open file '%s':\n%s", amc_filename, indent(str(e), 2))
    sys.exit()


#-- open template
group = stringtemplate.StringTemplateGroup(open(template_name, 'r'))

try:
    query = group.getInstanceOf('main')
except ValueError, e:
    log.error("Could not open template file '%s':\n%s", template_name, indent(str(e), 2))
    sys.exit()


#-- read entries
id_list = [int(x) for x in sys.stdin.read().split("\n") if (x != '')]


def prepareAMCRecord(record):
    """formats the values of an AMC record suitable for output"""
    # set default argument for empty /non-existing keys
    record['_default_'] = ''
    # date
    record['date'] = Date2YMD(record['date'])
    # picture: TODO
    # extract picture, convert to jpeg and store in /tmp
    # if user wants jpeg reference to the file

    # escape \ and &
    for k in ['mediaLabel', 'mediaType',    'source',\
              'borrower',   'originalTitle','translatedTitle',\
              'director',   'producer',     'country',\
              'category',   'actors',       'url',\
              'description','comments',     'videoFormat',\
              'audioFormat','resolution',   'framerate',\
              'languages',  'subtitles',    'fileSize']:
        record[k] = record[k].replace('\\', '\\backslash')
        record[k] = record[k].replace('&', '\\&')

    return record


#-- load all records
records = []
for index in id_list:
    try:
        f.seek(index)
    except IndexError,e:
        log.error("Invalid index to AMC file: %d", index)
        sys.exit()

    rec = f.read(1)[0]
    records.append(prepareAMCRecord(dict(rec)))

#-- close file
f.close()


#-- process template

query['records'] = records

print unicode(query).encode(prefs['systemEncoding'])

