# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 773 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------
#-- qt imports
from qt import SIGNAL, QPixmap, QImage

#-- Python imports
import logging

from os.path import exists as fexists, join as fjoin, splitext

#-- own imports
from ExportDialogBase import ExportDialogBase
from Settings import getPreferences, Settings, updatePreferences
from misc import Date2YMD
from AMCFile33 import AMCRecord33


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)


# mapps AMC field names to text strings
AMCField2name = {
    'number': 'Id',
    'date': 'Date',
    'rating': 'Rating',
    'year': 'Year',
    'length': 'Length',
    'discs': 'Discs',
#    'checked': 'Checked',
#    'videoBitrate': 'Video Bitrate',
#    'audioBitrate': 'Audio Bitrate',
    'mediaLabel': 'Media Label',
    'mediaType': 'Media Type',
    'source': 'Location',
    'borrower': 'Borrower',
    'originalTitle': 'Original Title',
    'translatedTitle': 'Translated Title',
    'director': 'Director',
    'producer': 'Producer',
    'country': 'Country',
    'category': 'Category',
    'actors': 'Actors',
#    'url': 'URL',
    'description': 'Description',
    'comments': 'Comments',
#    'videoFormat': 'Video Format',
#    'audioFormat': 'Audio Format',
    'resolution': 'Resolution',
    'framerate': 'Framerate',
    'languages': 'Languages',
    'subtitles': 'Subtitles',
    'fileSize': 'File Size',
#    'picture': 'Picture',
#    'embeddedImage': 'Embedded Image',
    }



class ExportDialog(ExportDialogBase):
    """displays export dialog"""
    def __init__(self, parent=None, name=None, modal=False,fl=0):
        ExportDialogBase.__init__(self, parent, name, modal, fl)

        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # runtime variables
        self.templateList = []
        self.sortFields = []
        self.templatedir = fjoin(Settings().userdir, 'templates')

        # load available export scripts 
        for key in pref['export'].keys():
            # ignore non .st files
            if (splitext(key)[1] != '.st'): continue
            template = fjoin(self.templatedir, key)
            if (not fexists(template)):
                log.error("Template '%s' specified in config file, but does not exist in '%s'", key, self.templatedir)
                continue
            self.exportTemplateComboBox.insertItem(key)
            self.templateList.append(key)


        # load available sort criterea
        record = AMCRecord33()
        defaultIndex = 0
        for key in record.keys():
            if (AMCField2name.has_key(key)):
                self.sortComboBox.insertItem(AMCField2name[key])
                self.sortFields.append(key)

                if (key == pref['exportDefaultSortKey']):
                    defaultIndex = len(self.sortFields)-1

        # set default sort key
        self.sortComboBox.setCurrentItem(defaultIndex)
        # load default filter chain text to lineedit
        self.exportTemplateChanged(self.exportTemplateComboBox.currentItem())
        # set focus to export template combobox
        self.exportTemplateComboBox.setFocus()

        # connect signals
        self.connect(self.exportTemplateComboBox, SIGNAL('activated(int)'), self.exportTemplateChanged)
        self.connect(self.savePushButton, SIGNAL('pressed()'), self.saveFilterChain)


    def saveFilterChain(self):
        """executed when 'save' pushbutton is pressed"""
        text = unicode(self.filterChainLineEdit.text())
        template = self.templateList[self.exportTemplateComboBox.currentItem()]
        tmp_old = pref['export'][template]
        tmp_new = (text, tmp_old[1])
        # propagate changes
        Settings()['export'][template] = tmp_new
        updatePreferences()


    def exportTemplateChanged(self, index):
        """executed when user changes export template"""
        template = self.templateList[index]
        template_options = pref['export'][template]
        image_preview = fjoin(self.templatedir, splitext(template)[0])+".png"
        if (fexists(image_preview)):
            self.log.debug("Loading preview image %s", image_preview)
            img = QImage(image_preview).smoothScale(100,100, QImage.ScaleMin)
            self.previewPixmapLabel.setPixmap(QPixmap(img))
        else:
            self.log.warning("No preview image found for template %s", template)
            self.previewPixmapLabel.clear()
        self.filterChainLineEdit.setText(template_options[0])


    def getOptions(self):
        """return tuple of selected options"""
        # export filter
        exportTemplateIdx = self.exportTemplateComboBox.currentItem()
        exportTemplate = self.templateList[exportTemplateIdx]

        # sort criterea
        sortFieldIdx = self.sortComboBox.currentItem()
        sortField = self.sortFields[sortFieldIdx]

        # selection or all entries
        allEntries = True
        if (self.selectedEntriesRadioButton.isChecked()):
            allEntries = False

        # ascending or descending
        ascending = True
        if (self.descendingRadioButton.isChecked()):
            ascending = False

        return (exportTemplate, sortField, allEntries, not ascending)

                                


if (__name__ == '__main__'):
    pass
    
