# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 93 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QTimer, SLOT, SIGNAL, QMovie
from qt import PYSIGNAL


#-- Python imports
import logging
import os

from os.path import join as fjoin


#-- own imports
from defaults import resourcedir

from ScriptExecDialogBase import ScriptExecDialogBase
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)




class ScriptExecDialog(ScriptExecDialogBase):
    """executes a script and displays a dialog widget and enables to abort"""
    def __init__(self, process, parent=None, name=None, modal=False, fl=0):
        ScriptExecDialogBase.__init__(self, parent, name, modal, fl)

        # create logging instance
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # customisations
        self.labelGlobe.setMovie(QMovie(fjoin(resourcedir, "rotatingGlobe.mng")))

        # runtime variables
        self.process = process
        
        # connect signals
        self.connect(self.process, SIGNAL("processExited()"), self.accept)


    def reject(self):
        """called when user aborts process"""
        self.log.info("Aborting process execution")
        self.process.tryTerminate()
        QTimer.singleShot(5000, self.process, SLOT("kill()"))
        ScriptExecDialogBase.reject(self)


    def exec_loop(self):
        """starts dialogs event loop"""
        cmd = unicode(self.process.arguments().join(" "))
        self.log.info("Executing: %s", cmd)
        self.textLabelStatus.setText(cmd)

        # execute
        if (not self.process.start()):
            self.log.error("Could not start command execution")
            return self.Rejected
        return ScriptExecDialogBase.exec_loop(self)


#-- testarea -------------------------------------------------------------------
if (__name__ == '__main__'):
    import sys
    from qt import QApplication, QDialog

    from StdIOProcess import StdIOProcess
    
    a = QApplication(sys.argv)

    # need logging handlers for testing
    log = logging.getLogger("")
    hdlr = logging.StreamHandler()
    formatter = logging.Formatter('[%(name)s] %(levelname)s: %(message)s')
    hdlr.setFormatter(formatter)
    log.addHandler(hdlr) 
    log.setLevel(pref['logLevel'])

    cmd = "scripts/filmposterarchiv-de.pl \"Harry Potter and the Sorcerer's Stone\""
    script = StdIOProcess("filmposterarchiv-de.pl",
                          ["Harry Potter and the Sorcerer's Stone"],
                          {'http_proxy': 'http://proxy.hadiko.de:3128'},
                          './scripts')

    w = ScriptExecDialog(script)
    
    print "aborted: ",w.exec_loop() == QDialog.Rejected
    print script.stdout()

