%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : The GIMP ToolKit (GTK+), a library for creating GUIs for X
Name            : gtk2
Version         : 2.12.1
Release         : 1
License         : LGPL
Vendor          : Freescale
Packager        : Stuart Hughes
Group           : System Environment/Daemons
Source          : gtk+-%{version}.tar.gz
#Patch1          : gtk2-2.12.1-builtin_icons.patch
Patch2          : gtk2-2.12.1-no-update-icon-cache.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup -n gtk+-%{version}
#%patch1 -p1
%patch2 -p1

%Build
if rpm --dbpath %{_dbpath} -q xorg-server &>/dev/null
then
	extra_opts='--with-x';
else
	extra_opts='--without-x --with-gdktarget=directfb';
fi

./configure --prefix=%{_prefix} --host=$CFGHOST --build=%{_build} \
            $extra_opts -C

perl -pi -e 's,^sys_lib_search_path_spec=.*,sys_lib_search_path_spec=,' libtool
make

%Install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT/%{pfx}
find $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/lib/ -name "*.la" | xargs rm -f

install -d $RPM_BUILD_ROOT/%{pfx}/etc/rc.d/init.d
initscript=$RPM_BUILD_ROOT/%{pfx}/etc/rc.d/init.d/gtk2
cat > $initscript << EOF
#!/bin/sh
# Copyright 2008, Freescale Semiconductor Inc.
#
if [ "\$1" = "start" ]; then
	echo gtk: creating gdk-pixbuf.loaders
	if [ ! -f /usr/etc/gtk-2.0/gdk-pixbuf.loaders ] ; then
		mkdir -p /usr/etc/gtk-2.0
		/usr/bin/gdk-pixbuf-query-loaders > /usr/etc/gtk-2.0/gdk-pixbuf.loaders
	fi
fi
EOF
chmod 744 $initscript


#%Post
#export PATH=%{_prefix}/bin:$PATH
#mkdir -p %{_prefix}/etc/gtk-2.0
#gdk-pixbuf-query-loaders > %{_prefix}/etc/gtk-2.0/gdk-pixbuf.loaders


# Todo?  This may break certain workflows.
#%Postun
#echo Post uninstall: remove file generated by init script
#if [ -n "$RPM_INSTALL_PREFIX" -a -f $RPM_INSTALL_PREFIX/usr/etc/gtk-2.0/gdk-pixbuf.loaders ]; then
#	rm -f $RPM_INSTALL_PREFIX/usr/etc/gtk-2.0/gdk-pixbuf.loaders
#fi


%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


