%define pfx /opt/freescale/rootfs/%{_target_cpu}
%define bld_dir_name	ltp-full-20070930

Summary         : Linux Test Project
Name            : ltp-full
Version         : 20070930
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : John Faith
Group           : Testing
Source          : ltp-full-20070930.tgz
Patch0          : ltp-fsl-20070930.patch
Patch1          : ltp-full-20070930-config-base-small-fix.patch
Patch2          : ltp-full-20070930-uclibc.patch
Patch3          : ltp-full-20050608-del-failing-tests.patch
Patch4          : ltp-full-20070930-open-max.patch
Patch5          : ltp-full-20070930-linux-inotify.patch
Patch6          : ltp-full-20070930-linux-dirent-02.patch
BuildRoot       : %{_tmppath}/%{name}-%{version}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
echo BUILDROOT=$BUILDROOT
%setup 
%patch0 -p1
%patch1 -p1
%patch2 -p1
#%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1


%Build
make

%Install
rm -rf $RPM_BUILD_ROOT
ltpdir=$RPM_BUILD_ROOT/%{pfx}/usr/local/ltp
for dir in pan runtest testcases/bin testcases/bin/dumpdir testscripts; do
	install -d $ltpdir/$dir
done

cd testcases/kernel/io/stress_floppy
make generate
install -m 644 dumpdir/* $ltpdir/testcases/bin/dumpdir
cd -

cp -p tools/apicmds/ltpapicmd $ltpdir/testcases/bin
cd $ltpdir/testcases/bin
for file in tst_brk tst_brkm tst_res tst_resm tst_exit tst_flush tst_brkloop tst_brkloopm; do
	ln -sf ltpapicmd $file
done
cd -

cd tools/genload
install -m 755 ./stress $ltpdir/testcases/bin/genload
cd -

cd testscripts
install -m 755 *.sh $ltpdir/testscripts
cd -

for file in IDcheck.sh runltp ver_linux cmdrun embedded-tests; do
	install -m 755 $file $ltpdir
done
for file in pan/pan pan/bump pan/scanner; do
	install -m 755 $file $ltpdir/pan
done

cat << EOF > runtest_files.txt
./runtest/commands
./runtest/crashme
./runtest/dio
./runtest/fs
./runtest/fsx
./runtest/hyperthreading
./runtest/io
./runtest/ipc
./runtest/ipv6
./runtest/ipv6_noexpect
./runtest/lvm.part1
./runtest/lvm.part2
./runtest/math
./runtest/mm
./runtest/modules
./runtest/multicast
./runtest/nfs
./runtest/pipes
./runtest/pty
./runtest/quickhit
./runtest/rpc
./runtest/sched
./runtest/sctp
./runtest/stress.part1
./runtest/stress.part2
./runtest/stress.part3
./runtest/syscalls
./runtest/tcp_cmds
./runtest/tcp_cmds_noexpect
./runtest/timers
EOF
for file in `cat runtest_files.txt`; do
	install -m 644 $file $ltpdir/runtest
done
rm runtest_files.txt

cat << EOF > exe_files.txt
./testcases/commands/ade/ar/ar01
./testcases/commands/ade/objdump/objdump01
./testcases/commands/ade/objdump/test
./testcases/commands/ade/objdump/test_D
./testcases/commands/ade/size/size01
./testcases/commands/ade/ld/ld01
./testcases/commands/ade/ldd/ldd01
./testcases/commands/ade/nm/nm01
./testcases/commands/ade/file/file_test.sh
./testcases/commands/cpio/cpio_tests.sh
./testcases/commands/cron/cron_tests.sh
./testcases/commands/eject/check_tray
./testcases/commands/eject/eject-tests.sh
./testcases/commands/fileutils/cp/cp_tests.sh
./testcases/commands/fileutils/mv/mv_tests.sh
./testcases/commands/fileutils/mkdir/mkdir_tests.sh
./testcases/commands/fileutils/ln/ln_tests.sh
./testcases/commands/gzip/gzip_tests.sh
./testcases/commands/logrotate/logrotate_tests.sh
./testcases/commands/mail/mail_tests.sh
./testcases/commands/tar/tar_tests.sh
./testcases/misc/crash/crash01
./testcases/misc/crash/crash02
./testcases/misc/f00f/f00f
./testcases/misc/math/abs/abs01
./testcases/misc/math/atof/atof01
./testcases/misc/math/float/float_bessel
./testcases/misc/math/float/float_iperb
./testcases/misc/math/float/float_trigo
./testcases/misc/math/float/float_exp_log
./testcases/misc/math/float/float_power
./testcases/misc/math/float/bessel/genbessel
./testcases/misc/math/float/bessel/genj0
./testcases/misc/math/float/bessel/genj1
./testcases/misc/math/float/bessel/genlgamma
./testcases/misc/math/float/bessel/geny0
./testcases/misc/math/float/bessel/geny1
./testcases/misc/math/float/exp_log/genexp
./testcases/misc/math/float/exp_log/genexp_log
./testcases/misc/math/float/exp_log/genfrexp
./testcases/misc/math/float/exp_log/genhypot
./testcases/misc/math/float/exp_log/genldexp
./testcases/misc/math/float/exp_log/genlog
./testcases/misc/math/float/exp_log/genlog10
./testcases/misc/math/float/exp_log/genmodf
./testcases/misc/math/float/iperb/gencosh
./testcases/misc/math/float/iperb/geniperb
./testcases/misc/math/float/iperb/gensinh
./testcases/misc/math/float/iperb/gentanh
./testcases/misc/math/float/power/genceil
./testcases/misc/math/float/power/genfabs
./testcases/misc/math/float/power/genfloor
./testcases/misc/math/float/power/genfmod
./testcases/misc/math/float/power/genpow
./testcases/misc/math/float/power/genpower
./testcases/misc/math/float/power/gensqrt
./testcases/misc/math/float/trigo/genacos
./testcases/misc/math/float/trigo/genasin
./testcases/misc/math/float/trigo/genatan
./testcases/misc/math/float/trigo/genatan2
./testcases/misc/math/float/trigo/gencos
./testcases/misc/math/float/trigo/gensin
./testcases/misc/math/float/trigo/gentan
./testcases/misc/math/float/trigo/gentrigo
./testcases/misc/math/fptests/fptest01
./testcases/misc/math/fptests/fptest02
./testcases/misc/math/nextafter/nextafter01
./testcases/kernel/fs/doio/doio
./testcases/kernel/fs/doio/growfiles
./testcases/kernel/fs/doio/iogen
./testcases/kernel/fs/doio/rwtest
./testcases/kernel/fs/fs_inod/fs_inod
./testcases/kernel/fs/fsstress/fsstress
./testcases/kernel/fs/fs_perms/fs_perms
./testcases/kernel/fs/fsx-linux/fsxtest02
./testcases/kernel/fs/fsx-linux/fsxtest
./testcases/kernel/fs/fsx-linux/fsx-linux
./testcases/kernel/fs/ftest/ftest01
./testcases/kernel/fs/ftest/ftest02
./testcases/kernel/fs/ftest/ftest03
./testcases/kernel/fs/ftest/ftest04
./testcases/kernel/fs/ftest/ftest05
./testcases/kernel/fs/ftest/ftest06
./testcases/kernel/fs/ftest/ftest07
./testcases/kernel/fs/ftest/ftest08
./testcases/kernel/fs/inode/inode01
./testcases/kernel/fs/inode/inode02
./testcases/kernel/fs/lftest/lftest
./testcases/kernel/fs/linktest/linktest.pl
./testcases/kernel/fs/openfile/openfile
./testcases/kernel/fs/proc/proc01
./testcases/kernel/fs/stream/stream01
./testcases/kernel/fs/stream/stream02
./testcases/kernel/fs/stream/stream03
./testcases/kernel/fs/stream/stream04
./testcases/kernel/fs/stream/stream05
./testcases/kernel/io/direct_io/diotest1
./testcases/kernel/io/direct_io/diotest2
./testcases/kernel/io/direct_io/diotest3
./testcases/kernel/io/direct_io/diotest4
./testcases/kernel/io/direct_io/diotest5
./testcases/kernel/io/direct_io/diotest6
./testcases/kernel/io/disktest/disktest
./testcases/kernel/io/stress_cd/stress_cd
./testcases/kernel/io/stress_floppy/stress_floppy
./testcases/kernel/ipc/semaphore/sem01
./testcases/kernel/ipc/semaphore/sem02
./testcases/kernel/ipc/pipeio/pipeio
./testcases/kernel/ipc/ipc_stress/message_queue_test_01
./testcases/kernel/ipc/ipc_stress/message_queue_test_02_ctl
./testcases/kernel/ipc/ipc_stress/message_queue_test_02_get
./testcases/kernel/ipc/ipc_stress/message_queue_test_02_rcv
./testcases/kernel/ipc/ipc_stress/message_queue_test_02_snd
./testcases/kernel/ipc/ipc_stress/message_queue_test_04
./testcases/kernel/ipc/ipc_stress/message_queue_test_05
./testcases/kernel/ipc/ipc_stress/pipe_test_01
./testcases/kernel/ipc/ipc_stress/pipe_test_02
./testcases/kernel/ipc/ipc_stress/semaphore_test_01
./testcases/kernel/ipc/ipc_stress/semaphore_test_02
./testcases/kernel/ipc/ipc_stress/semaphore_test_03
./testcases/kernel/ipc/ipc_stress/shmem_test_01
./testcases/kernel/ipc/ipc_stress/shmem_test_02
./testcases/kernel/ipc/ipc_stress/shmem_test_03
./testcases/kernel/ipc/ipc_stress/shmem_test_04
./testcases/kernel/ipc/ipc_stress/shmem_test_05
./testcases/kernel/ipc/ipc_stress/shmem_test_06
./testcases/kernel/ipc/ipc_stress/shmem_test_07
./testcases/kernel/ipc/ipc_stress/signal_test_01
./testcases/kernel/ipc/ipc_stress/signal_test_02
./testcases/kernel/ipc/ipc_stress/signal_test_03
./testcases/kernel/ipc/ipc_stress/signal_test_04
./testcases/kernel/ipc/ipc_stress/signal_test_05
./testcases/kernel/ipc/ipc_stress/signal_test_06
./testcases/kernel/ipc/ipc_stress/signal_test_07
./testcases/kernel/ipc/ipc_stress/testall
./testcases/kernel/mem/mem/mem01
./testcases/kernel/mem/mem/mem02
./testcases/kernel/mem/mmapstress/mmapstress01
./testcases/kernel/mem/mmapstress/mmapstress02
./testcases/kernel/mem/mmapstress/mmapstress03
./testcases/kernel/mem/mmapstress/mmapstress04
./testcases/kernel/mem/mmapstress/mmapstress05
./testcases/kernel/mem/mmapstress/mmapstress06
./testcases/kernel/mem/mmapstress/mmapstress07
./testcases/kernel/mem/mmapstress/mmapstress08
./testcases/kernel/mem/mmapstress/mmapstress09
./testcases/kernel/mem/mmapstress/mmapstress10
./testcases/kernel/mem/mtest01/mtest01
./testcases/kernel/mem/mtest05/mmstress
./testcases/kernel/mem/mtest05/dummy
./testcases/kernel/mem/mtest06/mmap1
./testcases/kernel/mem/mtest06/mmap2
./testcases/kernel/mem/mtest06/mmap3
./testcases/kernel/mem/mtest06/shmat1
./testcases/kernel/mem/mtest07/mallocstress
./testcases/kernel/mem/mtest07/shm_test
./testcases/kernel/mem/page/page01
./testcases/kernel/mem/page/page02
./testcases/kernel/mem/shmt/shmt02
./testcases/kernel/mem/shmt/shmt03
./testcases/kernel/mem/shmt/shmt04
./testcases/kernel/mem/shmt/shmt05
./testcases/kernel/mem/shmt/shmt06
./testcases/kernel/mem/shmt/shmt07
./testcases/kernel/mem/shmt/shmt08
./testcases/kernel/mem/shmt/shmt09
./testcases/kernel/mem/shmt/shmt10
./testcases/kernel/mem/vmtests/data_space
./testcases/kernel/mem/vmtests/stack_space
./testcases/kernel/pty/hangup01
./testcases/kernel/pty/ptem01
./testcases/kernel/pty/pty01
./testcases/kernel/sched/clisrv/pthcli
./testcases/kernel/sched/clisrv/pthserv
./testcases/kernel/sched/pthreads/pth_str01
./testcases/kernel/sched/pthreads/pth_str02
./testcases/kernel/sched/pthreads/pth_str03
./testcases/kernel/sched/process_stress/process
./testcases/kernel/sched/sched_stress/sched_driver
./testcases/kernel/sched/sched_stress/sched_tc0
./testcases/kernel/sched/sched_stress/sched_tc1
./testcases/kernel/sched/sched_stress/sched_tc2
./testcases/kernel/sched/sched_stress/sched_tc3
./testcases/kernel/sched/sched_stress/sched_tc4
./testcases/kernel/sched/sched_stress/sched_tc5
./testcases/kernel/sched/sched_stress/sched_tc6
./testcases/kernel/sched/sched_stress/sched_stress.sh
./testcases/kernel/sched/tool/time-schedule
./testcases/kernel/sched/tool/trace_sched
./testcases/kernel/syscalls/abort/abort01
./testcases/kernel/syscalls/accept/accept01
./testcases/kernel/syscalls/access/access01
./testcases/kernel/syscalls/access/access02
./testcases/kernel/syscalls/access/access03
./testcases/kernel/syscalls/access/access04
./testcases/kernel/syscalls/access/access05
./testcases/kernel/syscalls/acct/acct01
./testcases/kernel/syscalls/acct/acct02
./testcases/kernel/syscalls/adjtimex/adjtimex01
./testcases/kernel/syscalls/adjtimex/adjtimex02
./testcases/kernel/syscalls/alarm/alarm01
./testcases/kernel/syscalls/alarm/alarm02
./testcases/kernel/syscalls/alarm/alarm03
./testcases/kernel/syscalls/alarm/alarm04
./testcases/kernel/syscalls/alarm/alarm05
./testcases/kernel/syscalls/alarm/alarm06
./testcases/kernel/syscalls/alarm/alarm07
./testcases/kernel/syscalls/alarm/sig_rev
./testcases/kernel/syscalls/asyncio/asyncio02
./testcases/kernel/syscalls/bind/bind01
./testcases/kernel/syscalls/brk/brk01
./testcases/kernel/syscalls/capget/capget01
./testcases/kernel/syscalls/capget/capget02
./testcases/kernel/syscalls/capset/capset01
./testcases/kernel/syscalls/capset/capset02
./testcases/kernel/syscalls/chdir/chdir01
./testcases/kernel/syscalls/chdir/chdir02
./testcases/kernel/syscalls/chdir/chdir03
./testcases/kernel/syscalls/chdir/chdir04
./testcases/kernel/syscalls/chmod/change_owner
./testcases/kernel/syscalls/chmod/chmod01
./testcases/kernel/syscalls/chmod/chmod02
./testcases/kernel/syscalls/chmod/chmod03
./testcases/kernel/syscalls/chmod/chmod04
./testcases/kernel/syscalls/chmod/chmod05
./testcases/kernel/syscalls/chmod/chmod06
./testcases/kernel/syscalls/chmod/chmod07
./testcases/kernel/syscalls/chown/change_owner
./testcases/kernel/syscalls/chown/chown01
./testcases/kernel/syscalls/chown/chown02
./testcases/kernel/syscalls/chown/chown03
./testcases/kernel/syscalls/chown/chown04
./testcases/kernel/syscalls/chown/chown05
./testcases/kernel/syscalls/chroot/chroot01
./testcases/kernel/syscalls/chroot/chroot02
./testcases/kernel/syscalls/chroot/chroot03
./testcases/kernel/syscalls/chroot/chroot04
./testcases/kernel/syscalls/clone/clone01
./testcases/kernel/syscalls/clone/clone02
./testcases/kernel/syscalls/clone/clone03
./testcases/kernel/syscalls/clone/clone04
./testcases/kernel/syscalls/clone/clone05
./testcases/kernel/syscalls/clone/clone06
./testcases/kernel/syscalls/clone/clone07
./testcases/kernel/syscalls/close/close01
./testcases/kernel/syscalls/close/close02
./testcases/kernel/syscalls/close/close08
./testcases/kernel/syscalls/confstr/confstr01
./testcases/kernel/syscalls/connect/connect01
./testcases/kernel/syscalls/creat/creat01
./testcases/kernel/syscalls/creat/creat03
./testcases/kernel/syscalls/creat/creat04
./testcases/kernel/syscalls/creat/creat05
./testcases/kernel/syscalls/creat/creat06
./testcases/kernel/syscalls/creat/creat07
./testcases/kernel/syscalls/creat/creat08
./testcases/kernel/syscalls/creat/creat09
./testcases/kernel/syscalls/creat/test1
./testcases/kernel/syscalls/dup2/dup201
./testcases/kernel/syscalls/dup2/dup202
./testcases/kernel/syscalls/dup2/dup203
./testcases/kernel/syscalls/dup2/dup204
./testcases/kernel/syscalls/dup2/dup205
./testcases/kernel/syscalls/dup/dup01
./testcases/kernel/syscalls/dup/dup02
./testcases/kernel/syscalls/dup/dup03
./testcases/kernel/syscalls/dup/dup04
./testcases/kernel/syscalls/dup/dup05
./testcases/kernel/syscalls/dup/dup06
./testcases/kernel/syscalls/dup/dup07
./testcases/kernel/syscalls/execle/execle01
./testcases/kernel/syscalls/execl/execl01
./testcases/kernel/syscalls/execlp/execlp01
./testcases/kernel/syscalls/execve/execve01
./testcases/kernel/syscalls/execve/execve02
./testcases/kernel/syscalls/execve/execve03
./testcases/kernel/syscalls/execve/execve04
./testcases/kernel/syscalls/execve/execve05
./testcases/kernel/syscalls/execve/execve06
./testcases/kernel/syscalls/execve/test3
./testcases/kernel/syscalls/execv/execv01
./testcases/kernel/syscalls/execvp/execvp01
./testcases/kernel/syscalls/exit/exit01
./testcases/kernel/syscalls/exit/exit02
./testcases/kernel/syscalls/fchdir/fchdir01
./testcases/kernel/syscalls/fchdir/fchdir02
./testcases/kernel/syscalls/fchdir/fchdir03
./testcases/kernel/syscalls/fchmod/change_owner
./testcases/kernel/syscalls/fchmod/fchmod01
./testcases/kernel/syscalls/fchmod/fchmod02
./testcases/kernel/syscalls/fchmod/fchmod03
./testcases/kernel/syscalls/fchmod/fchmod04
./testcases/kernel/syscalls/fchmod/fchmod05
./testcases/kernel/syscalls/fchmod/fchmod06
./testcases/kernel/syscalls/fchmod/fchmod07
./testcases/kernel/syscalls/fchown/change_owner
./testcases/kernel/syscalls/fchown/fchown01
./testcases/kernel/syscalls/fchown/fchown02
./testcases/kernel/syscalls/fchown/fchown03
./testcases/kernel/syscalls/fchown/fchown04
./testcases/kernel/syscalls/fchown/fchown05
./testcases/kernel/syscalls/fcntl/fcntl01
./testcases/kernel/syscalls/fcntl/fcntl02
./testcases/kernel/syscalls/fcntl/fcntl03
./testcases/kernel/syscalls/fcntl/fcntl04
./testcases/kernel/syscalls/fcntl/fcntl05
./testcases/kernel/syscalls/fcntl/fcntl06
./testcases/kernel/syscalls/fcntl/fcntl07B
./testcases/kernel/syscalls/fcntl/fcntl07
./testcases/kernel/syscalls/fcntl/fcntl08
./testcases/kernel/syscalls/fcntl/fcntl09
./testcases/kernel/syscalls/fcntl/fcntl10
./testcases/kernel/syscalls/fcntl/fcntl11
./testcases/kernel/syscalls/fcntl/fcntl12
./testcases/kernel/syscalls/fcntl/fcntl13
./testcases/kernel/syscalls/fcntl/fcntl14
./testcases/kernel/syscalls/fcntl/fcntl15
./testcases/kernel/syscalls/fcntl/fcntl16
./testcases/kernel/syscalls/fcntl/fcntl17
./testcases/kernel/syscalls/fcntl/fcntl18
./testcases/kernel/syscalls/fcntl/fcntl19
./testcases/kernel/syscalls/fcntl/fcntl20
./testcases/kernel/syscalls/fcntl/fcntl21
./testcases/kernel/syscalls/fcntl/fcntl22
./testcases/kernel/syscalls/fdatasync/fdatasync01
./testcases/kernel/syscalls/fdatasync/fdatasync02
./testcases/kernel/syscalls/flock/flock01
./testcases/kernel/syscalls/flock/flock02
./testcases/kernel/syscalls/flock/flock03
./testcases/kernel/syscalls/flock/flock04
./testcases/kernel/syscalls/flock/flock05
./testcases/kernel/syscalls/flock/flock06
./testcases/kernel/syscalls/fork/fork01
./testcases/kernel/syscalls/fork/fork02
./testcases/kernel/syscalls/fork/fork03
./testcases/kernel/syscalls/fork/fork04
./testcases/kernel/syscalls/fork/fork05
./testcases/kernel/syscalls/fork/fork06
./testcases/kernel/syscalls/fork/fork07
./testcases/kernel/syscalls/fork/fork08
./testcases/kernel/syscalls/fork/fork09
./testcases/kernel/syscalls/fork/fork10
./testcases/kernel/syscalls/fork/fork11
./testcases/kernel/syscalls/fork/fork12
./testcases/kernel/syscalls/fpathconf/fpathconf01
./testcases/kernel/syscalls/fstatfs/fstatfs01
./testcases/kernel/syscalls/fstatfs/fstatfs02
./testcases/kernel/syscalls/fstat/fstat01
./testcases/kernel/syscalls/fstat/fstat02
./testcases/kernel/syscalls/fstat/fstat03
./testcases/kernel/syscalls/fstat/fstat04
./testcases/kernel/syscalls/fstat/fstat05
./testcases/kernel/syscalls/fsync/fsync01
./testcases/kernel/syscalls/fsync/fsync02
./testcases/kernel/syscalls/fsync/fsync03
./testcases/kernel/syscalls/ftruncate/ftruncate01
./testcases/kernel/syscalls/ftruncate/ftruncate02
./testcases/kernel/syscalls/ftruncate/ftruncate03
./testcases/kernel/syscalls/ftruncate/ftruncate04
./testcases/kernel/syscalls/getcwd/getcwd01
./testcases/kernel/syscalls/getcwd/getcwd02
./testcases/kernel/syscalls/getcwd/getcwd03
./testcases/kernel/syscalls/getdents/getdents01
./testcases/kernel/syscalls/getdents/getdents02
./testcases/kernel/syscalls/getdents/getdents03
./testcases/kernel/syscalls/getdents/getdents04
./testcases/kernel/syscalls/getdomainname/getdomainname01
./testcases/kernel/syscalls/getegid/getegid01
./testcases/kernel/syscalls/geteuid/geteuid01
./testcases/kernel/syscalls/getgid/getgid01
./testcases/kernel/syscalls/getgid/getgid02
./testcases/kernel/syscalls/getgid/getgid03
./testcases/kernel/syscalls/getgroups/getgroups01
./testcases/kernel/syscalls/getgroups/getgroups02
./testcases/kernel/syscalls/getgroups/getgroups03
./testcases/kernel/syscalls/getgroups/getgroups04
./testcases/kernel/syscalls/gethostid/gethostid01
./testcases/kernel/syscalls/gethostname/gethostname01
./testcases/kernel/syscalls/getitimer/getitimer01
./testcases/kernel/syscalls/getitimer/getitimer02
./testcases/kernel/syscalls/getitimer/getitimer03
./testcases/kernel/syscalls/getpeername/getpeername01
./testcases/kernel/syscalls/getpgid/getpgid01
./testcases/kernel/syscalls/getpgid/getpgid02
./testcases/kernel/syscalls/getpgrp/getpgrp01
./testcases/kernel/syscalls/getpid/getpid01
./testcases/kernel/syscalls/getpid/getpid02
./testcases/kernel/syscalls/getppid/getppid01
./testcases/kernel/syscalls/getppid/getppid02
./testcases/kernel/syscalls/getpriority/getpriority01
./testcases/kernel/syscalls/getpriority/getpriority02
./testcases/kernel/syscalls/getresgid/getresgid01
./testcases/kernel/syscalls/getresgid/getresgid02
./testcases/kernel/syscalls/getresgid/getresgid03
./testcases/kernel/syscalls/getresuid/getresuid01
./testcases/kernel/syscalls/getresuid/getresuid02
./testcases/kernel/syscalls/getresuid/getresuid03
./testcases/kernel/syscalls/getrlimit/getrlimit01
./testcases/kernel/syscalls/getrlimit/getrlimit02
./testcases/kernel/syscalls/getrusage/getrusage01
./testcases/kernel/syscalls/getrusage/getrusage02
./testcases/kernel/syscalls/getsid/getsid01
./testcases/kernel/syscalls/getsid/getsid02
./testcases/kernel/syscalls/getsockname/getsockname01
./testcases/kernel/syscalls/getsockopt/getsockopt01
./testcases/kernel/syscalls/gettimeofday/gettimeofday01
./testcases/kernel/syscalls/gettimeofday/gettimeofday02
./testcases/kernel/syscalls/getuid/getuid01
./testcases/kernel/syscalls/getuid/getuid02
./testcases/kernel/syscalls/getuid/getuid03
./testcases/kernel/syscalls/ioctl/ioctl01
./testcases/kernel/syscalls/ioctl/ioctl02
./testcases/kernel/syscalls/ioperm/ioperm01
./testcases/kernel/syscalls/ioperm/ioperm02
./testcases/kernel/syscalls/iopl/iopl01
./testcases/kernel/syscalls/iopl/iopl02
./testcases/kernel/syscalls/ipc/msgctl/msgctl01
./testcases/kernel/syscalls/ipc/msgctl/msgctl02
./testcases/kernel/syscalls/ipc/msgctl/msgctl03
./testcases/kernel/syscalls/ipc/msgctl/msgctl04
./testcases/kernel/syscalls/ipc/msgctl/msgctl05
./testcases/kernel/syscalls/ipc/msgctl/msgctl06
./testcases/kernel/syscalls/ipc/msgctl/msgctl07
./testcases/kernel/syscalls/ipc/msgctl/msgctl08
./testcases/kernel/syscalls/ipc/msgctl/msgctl09
./testcases/kernel/syscalls/ipc/msgget/msgget01
./testcases/kernel/syscalls/ipc/msgget/msgget02
./testcases/kernel/syscalls/ipc/msgget/msgget03
./testcases/kernel/syscalls/ipc/msgget/msgget04
./testcases/kernel/syscalls/ipc/msgsnd/msgsnd01
./testcases/kernel/syscalls/ipc/msgsnd/msgsnd02
./testcases/kernel/syscalls/ipc/msgsnd/msgsnd03
./testcases/kernel/syscalls/ipc/msgsnd/msgsnd04
./testcases/kernel/syscalls/ipc/msgsnd/msgsnd05
./testcases/kernel/syscalls/ipc/msgsnd/msgsnd06
./testcases/kernel/syscalls/ipc/msgrcv/msgrcv01
./testcases/kernel/syscalls/ipc/msgrcv/msgrcv02
./testcases/kernel/syscalls/ipc/msgrcv/msgrcv03
./testcases/kernel/syscalls/ipc/msgrcv/msgrcv04
./testcases/kernel/syscalls/ipc/msgrcv/msgrcv05
./testcases/kernel/syscalls/ipc/msgrcv/msgrcv06
./testcases/kernel/syscalls/ipc/semget/semget01
./testcases/kernel/syscalls/ipc/semget/semget02
./testcases/kernel/syscalls/ipc/semget/semget03
./testcases/kernel/syscalls/ipc/semget/semget05
./testcases/kernel/syscalls/ipc/semget/semget06
./testcases/kernel/syscalls/ipc/semctl/semctl01
./testcases/kernel/syscalls/ipc/semctl/semctl02
./testcases/kernel/syscalls/ipc/semctl/semctl03
./testcases/kernel/syscalls/ipc/semctl/semctl04
./testcases/kernel/syscalls/ipc/semctl/semctl05
./testcases/kernel/syscalls/ipc/semctl/semctl06
./testcases/kernel/syscalls/ipc/semctl/semctl07
./testcases/kernel/syscalls/ipc/semop/semop01
./testcases/kernel/syscalls/ipc/semop/semop02
./testcases/kernel/syscalls/ipc/semop/semop03
./testcases/kernel/syscalls/ipc/semop/semop04
./testcases/kernel/syscalls/ipc/semop/semop05
./testcases/kernel/syscalls/ipc/shmat/shmat01
./testcases/kernel/syscalls/ipc/shmat/shmat02
./testcases/kernel/syscalls/ipc/shmat/shmat03
./testcases/kernel/syscalls/ipc/shmdt/shmdt01
./testcases/kernel/syscalls/ipc/shmdt/shmdt02
./testcases/kernel/syscalls/ipc/shmctl/shmctl01
./testcases/kernel/syscalls/ipc/shmctl/shmctl02
./testcases/kernel/syscalls/ipc/shmctl/shmctl03
./testcases/kernel/syscalls/ipc/shmctl/shmctl04
./testcases/kernel/syscalls/ipc/shmget/shmget01
./testcases/kernel/syscalls/ipc/shmget/shmget02
./testcases/kernel/syscalls/ipc/shmget/shmget03
./testcases/kernel/syscalls/ipc/shmget/shmget04
./testcases/kernel/syscalls/ipc/shmget/shmget05
./testcases/kernel/syscalls/kill/kill01
./testcases/kernel/syscalls/kill/kill02
./testcases/kernel/syscalls/kill/kill03
./testcases/kernel/syscalls/kill/kill04
./testcases/kernel/syscalls/kill/kill05
./testcases/kernel/syscalls/kill/kill06
./testcases/kernel/syscalls/kill/kill07
./testcases/kernel/syscalls/kill/kill08
./testcases/kernel/syscalls/kill/kill09
./testcases/kernel/syscalls/kill/kill10
./testcases/kernel/syscalls/kill/kill11
./testcases/kernel/syscalls/kill/kill12
./testcases/kernel/syscalls/lchown/create_link
./testcases/kernel/syscalls/lchown/lchown01
./testcases/kernel/syscalls/lchown/lchown02
./testcases/kernel/syscalls/link/link02
./testcases/kernel/syscalls/link/link03
./testcases/kernel/syscalls/link/link04
./testcases/kernel/syscalls/link/link05
./testcases/kernel/syscalls/link/link06
./testcases/kernel/syscalls/link/link07
./testcases/kernel/syscalls/listen/listen01
./testcases/kernel/syscalls/llseek/llseek01
./testcases/kernel/syscalls/llseek/llseek02
./testcases/kernel/syscalls/lseek/lseek01
./testcases/kernel/syscalls/lseek/lseek02
./testcases/kernel/syscalls/lseek/lseek03
./testcases/kernel/syscalls/lseek/lseek04
./testcases/kernel/syscalls/lseek/lseek05
./testcases/kernel/syscalls/lseek/lseek06
./testcases/kernel/syscalls/lseek/lseek07
./testcases/kernel/syscalls/lseek/lseek08
./testcases/kernel/syscalls/lseek/lseek09
./testcases/kernel/syscalls/lseek/lseek10
./testcases/kernel/syscalls/lstat/lstat01
./testcases/kernel/syscalls/lstat/lstat02
./testcases/kernel/syscalls/lstat/lstat03
./testcases/kernel/syscalls/mallopt/mallopt01
./testcases/kernel/syscalls/memcmp/memcmp01
./testcases/kernel/syscalls/memcpy/memcpy01
./testcases/kernel/syscalls/memset/memset01
./testcases/kernel/syscalls/mkdir/mkdir01
./testcases/kernel/syscalls/mkdir/mkdir02
./testcases/kernel/syscalls/mkdir/mkdir03
./testcases/kernel/syscalls/mkdir/mkdir04
./testcases/kernel/syscalls/mkdir/mkdir05
./testcases/kernel/syscalls/mkdir/mkdir08
./testcases/kernel/syscalls/mkdir/mkdir09
./testcases/kernel/syscalls/mknod/mknod01
./testcases/kernel/syscalls/mknod/mknod02
./testcases/kernel/syscalls/mknod/mknod03
./testcases/kernel/syscalls/mknod/mknod04
./testcases/kernel/syscalls/mknod/mknod05
./testcases/kernel/syscalls/mknod/mknod06
./testcases/kernel/syscalls/mknod/mknod07
./testcases/kernel/syscalls/mknod/mknod08
./testcases/kernel/syscalls/mknod/mknod09
./testcases/kernel/syscalls/mlockall/mlockall01
./testcases/kernel/syscalls/mlockall/mlockall02
./testcases/kernel/syscalls/mlock/mlock01
./testcases/kernel/syscalls/mlock/mlock02
./testcases/kernel/syscalls/mmap/mmap001
./testcases/kernel/syscalls/mmap/mmap01
./testcases/kernel/syscalls/mmap/mmap02
./testcases/kernel/syscalls/mmap/mmap03
./testcases/kernel/syscalls/mmap/mmap04
./testcases/kernel/syscalls/mmap/mmap05
./testcases/kernel/syscalls/mmap/mmap06
./testcases/kernel/syscalls/mmap/mmap07
./testcases/kernel/syscalls/mmap/mmap08
./testcases/kernel/syscalls/mmap/mmap09
./testcases/kernel/syscalls/modify_ldt/modify_ldt01
./testcases/kernel/syscalls/modify_ldt/modify_ldt02
./testcases/kernel/syscalls/mount/mount01
./testcases/kernel/syscalls/mount/mount02
./testcases/kernel/syscalls/mount/mount03
./testcases/kernel/syscalls/mount/mount04
./testcases/kernel/syscalls/mount/setuid_test
./testcases/kernel/syscalls/mprotect/mprotect01
./testcases/kernel/syscalls/mprotect/mprotect02
./testcases/kernel/syscalls/mprotect/mprotect03
./testcases/kernel/syscalls/mremap/mremap01
./testcases/kernel/syscalls/mremap/mremap02
./testcases/kernel/syscalls/mremap/mremap03
./testcases/kernel/syscalls/mremap/mremap04
./testcases/kernel/syscalls/msync/msync01
./testcases/kernel/syscalls/msync/msync02
./testcases/kernel/syscalls/msync/msync03
./testcases/kernel/syscalls/msync/msync04
./testcases/kernel/syscalls/msync/msync05
./testcases/kernel/syscalls/munlockall/munlockall01
./testcases/kernel/syscalls/munlockall/munlockall02
./testcases/kernel/syscalls/munlock/munlock01
./testcases/kernel/syscalls/munlock/munlock02
./testcases/kernel/syscalls/munmap/munmap01
./testcases/kernel/syscalls/munmap/munmap02
./testcases/kernel/syscalls/munmap/munmap03
./testcases/kernel/syscalls/nanosleep/nanosleep01
./testcases/kernel/syscalls/nanosleep/nanosleep02
./testcases/kernel/syscalls/nanosleep/nanosleep03
./testcases/kernel/syscalls/nanosleep/nanosleep04
./testcases/kernel/syscalls/nftw/nftw01
./testcases/kernel/syscalls/nftw/nftw6401
./testcases/kernel/syscalls/nice/nice01
./testcases/kernel/syscalls/nice/nice02
./testcases/kernel/syscalls/nice/nice03
./testcases/kernel/syscalls/nice/nice04
./testcases/kernel/syscalls/nice/nice05
./testcases/kernel/syscalls/open/open01
./testcases/kernel/syscalls/open/open02
./testcases/kernel/syscalls/open/open03
./testcases/kernel/syscalls/open/open04
./testcases/kernel/syscalls/open/open05
./testcases/kernel/syscalls/open/open06
./testcases/kernel/syscalls/open/open07
./testcases/kernel/syscalls/open/open08
./testcases/kernel/syscalls/open/open09
./testcases/kernel/syscalls/open/open10
./testcases/kernel/syscalls/pathconf/pathconf01
./testcases/kernel/syscalls/pause/pause01
./testcases/kernel/syscalls/pause/pause02
./testcases/kernel/syscalls/pause/pause03
./testcases/kernel/syscalls/personality/personality01
./testcases/kernel/syscalls/personality/personality02
./testcases/kernel/syscalls/pipe/pipe01
./testcases/kernel/syscalls/pipe/pipe02
./testcases/kernel/syscalls/pipe/pipe03
./testcases/kernel/syscalls/pipe/pipe04
./testcases/kernel/syscalls/pipe/pipe05
./testcases/kernel/syscalls/pipe/pipe06
./testcases/kernel/syscalls/pipe/pipe07
./testcases/kernel/syscalls/pipe/pipe08
./testcases/kernel/syscalls/pipe/pipe09
./testcases/kernel/syscalls/pipe/pipe10
./testcases/kernel/syscalls/pipe/pipe11
./testcases/kernel/syscalls/poll/poll01
./testcases/kernel/syscalls/prctl/prctl01
./testcases/kernel/syscalls/prctl/prctl02
./testcases/kernel/syscalls/pread/pread01
./testcases/kernel/syscalls/pread/pread02
./testcases/kernel/syscalls/pread/pread03
./testcases/kernel/syscalls/ptrace/ptrace01
./testcases/kernel/syscalls/ptrace/ptrace02
./testcases/kernel/syscalls/ptrace/ptrace03
./testcases/kernel/syscalls/pwrite/pwrite01
./testcases/kernel/syscalls/pwrite/pwrite02
./testcases/kernel/syscalls/pwrite/pwrite03
./testcases/kernel/syscalls/pwrite/pwrite04
./testcases/kernel/syscalls/readdir/readdir01
./testcases/kernel/syscalls/readdir/readdir02
./testcases/kernel/syscalls/readlink/creat_slink
./testcases/kernel/syscalls/readlink/readlink01
./testcases/kernel/syscalls/readlink/readlink02
./testcases/kernel/syscalls/readlink/readlink03
./testcases/kernel/syscalls/readlink/readlink04
./testcases/kernel/syscalls/read/read01
./testcases/kernel/syscalls/read/read02
./testcases/kernel/syscalls/read/read03
./testcases/kernel/syscalls/read/read04
./testcases/kernel/syscalls/readv/readv01
./testcases/kernel/syscalls/readv/readv02
./testcases/kernel/syscalls/readv/readv03
./testcases/kernel/syscalls/reboot/reboot01
./testcases/kernel/syscalls/reboot/reboot02
./testcases/kernel/syscalls/recvfrom/recvfrom01
./testcases/kernel/syscalls/recv/recv01
./testcases/kernel/syscalls/recvmsg/recvmsg01
./testcases/kernel/syscalls/rename/rename01
./testcases/kernel/syscalls/rename/rename02
./testcases/kernel/syscalls/rename/rename03
./testcases/kernel/syscalls/rename/rename04
./testcases/kernel/syscalls/rename/rename05
./testcases/kernel/syscalls/rename/rename06
./testcases/kernel/syscalls/rename/rename07
./testcases/kernel/syscalls/rename/rename08
./testcases/kernel/syscalls/rename/rename09
./testcases/kernel/syscalls/rename/rename10
./testcases/kernel/syscalls/rename/rename12
./testcases/kernel/syscalls/rename/rename13
./testcases/kernel/syscalls/rename/rename14
./testcases/kernel/syscalls/rmdir/rmdir01
./testcases/kernel/syscalls/rmdir/rmdir02
./testcases/kernel/syscalls/rmdir/rmdir03
./testcases/kernel/syscalls/rmdir/rmdir04
./testcases/kernel/syscalls/rmdir/rmdir05
./testcases/kernel/syscalls/sbrk/sbrk01
./testcases/kernel/syscalls/sched_getparam/sched_getparam01
./testcases/kernel/syscalls/sched_getparam/sched_getparam02
./testcases/kernel/syscalls/sched_getparam/sched_getparam03
./testcases/kernel/syscalls/sched_get_priority_max/sched_get_priority_max01
./testcases/kernel/syscalls/sched_get_priority_max/sched_get_priority_max02
./testcases/kernel/syscalls/sched_get_priority_min/sched_get_priority_min01
./testcases/kernel/syscalls/sched_get_priority_min/sched_get_priority_min02
./testcases/kernel/syscalls/sched_getscheduler/sched_getscheduler01
./testcases/kernel/syscalls/sched_getscheduler/sched_getscheduler02
./testcases/kernel/syscalls/sched_rr_get_interval/sched_rr_get_interval01
./testcases/kernel/syscalls/sched_rr_get_interval/sched_rr_get_interval02
./testcases/kernel/syscalls/sched_rr_get_interval/sched_rr_get_interval03
./testcases/kernel/syscalls/sched_setparam/sched_setparam01
./testcases/kernel/syscalls/sched_setparam/sched_setparam02
./testcases/kernel/syscalls/sched_setparam/sched_setparam03
./testcases/kernel/syscalls/sched_setparam/sched_setparam04
./testcases/kernel/syscalls/sched_setparam/sched_setparam05
./testcases/kernel/syscalls/sched_setscheduler/sched_setscheduler01
./testcases/kernel/syscalls/sched_setscheduler/sched_setscheduler02
./testcases/kernel/syscalls/sched_yield/sched_yield01
./testcases/kernel/syscalls/select/select01
./testcases/kernel/syscalls/select/select02
./testcases/kernel/syscalls/select/select03
./testcases/kernel/syscalls/sendfile/sendfile02
./testcases/kernel/syscalls/sendfile/sendfile03
./testcases/kernel/syscalls/send/send01
./testcases/kernel/syscalls/sendmsg/sendmsg01
./testcases/kernel/syscalls/sendto/sendto01
./testcases/kernel/syscalls/setdomainname/setdomainname01
./testcases/kernel/syscalls/setdomainname/setdomainname02
./testcases/kernel/syscalls/setdomainname/setdomainname03
./testcases/kernel/syscalls/setegid/setegid01
./testcases/kernel/syscalls/setfsgid/setfsgid01
./testcases/kernel/syscalls/setfsuid/setfsuid01
./testcases/kernel/syscalls/setgid/setgid01
./testcases/kernel/syscalls/setgid/setgid02
./testcases/kernel/syscalls/setgid/setgid03
./testcases/kernel/syscalls/setgroups/setgroups01
./testcases/kernel/syscalls/setgroups/setgroups02
./testcases/kernel/syscalls/setgroups/setgroups03
./testcases/kernel/syscalls/setgroups/setgroups04
./testcases/kernel/syscalls/sethostname/sethostname01
./testcases/kernel/syscalls/sethostname/sethostname02
./testcases/kernel/syscalls/sethostname/sethostname03
./testcases/kernel/syscalls/setitimer/setitimer01
./testcases/kernel/syscalls/setitimer/setitimer02
./testcases/kernel/syscalls/setitimer/setitimer03
./testcases/kernel/syscalls/setpgid/setpgid01
./testcases/kernel/syscalls/setpgid/setpgid02
./testcases/kernel/syscalls/setpgid/setpgid03
./testcases/kernel/syscalls/setpgrp/setpgrp01
./testcases/kernel/syscalls/setpgrp/setpgrp02
./testcases/kernel/syscalls/setpriority/setpriority01
./testcases/kernel/syscalls/setpriority/setpriority02
./testcases/kernel/syscalls/setpriority/setpriority03
./testcases/kernel/syscalls/setpriority/setpriority04
./testcases/kernel/syscalls/setpriority/setpriority05
./testcases/kernel/syscalls/setregid/setregid01
./testcases/kernel/syscalls/setregid/setregid02
./testcases/kernel/syscalls/setregid/setregid03
./testcases/kernel/syscalls/setregid/setregid04
./testcases/kernel/syscalls/setresgid/setresgid01
./testcases/kernel/syscalls/setresgid/setresgid02
./testcases/kernel/syscalls/setresgid/setresgid03
./testcases/kernel/syscalls/setresuid/setresuid01
./testcases/kernel/syscalls/setresuid/setresuid02
./testcases/kernel/syscalls/setresuid/setresuid03
./testcases/kernel/syscalls/setreuid/setreuid01
./testcases/kernel/syscalls/setreuid/setreuid02
./testcases/kernel/syscalls/setreuid/setreuid03
./testcases/kernel/syscalls/setreuid/setreuid04
./testcases/kernel/syscalls/setreuid/setreuid05
./testcases/kernel/syscalls/setreuid/setreuid06
./testcases/kernel/syscalls/setrlimit/setrlimit01
./testcases/kernel/syscalls/setrlimit/setrlimit02
./testcases/kernel/syscalls/setrlimit/setrlimit03
./testcases/kernel/syscalls/setsid/setsid01
./testcases/kernel/syscalls/setsockopt/setsockopt01
./testcases/kernel/syscalls/settimeofday/settimeofday01
./testcases/kernel/syscalls/settimeofday/settimeofday02
./testcases/kernel/syscalls/setuid/setuid01
./testcases/kernel/syscalls/setuid/setuid02
./testcases/kernel/syscalls/setuid/setuid03
./testcases/kernel/syscalls/sigaction/sigaction01
./testcases/kernel/syscalls/sigaction/sigaction02
./testcases/kernel/syscalls/sigaltstack/sigaltstack01
./testcases/kernel/syscalls/sigaltstack/sigaltstack02
./testcases/kernel/syscalls/sighold/sighold02
./testcases/kernel/syscalls/signal/signal01
./testcases/kernel/syscalls/signal/signal02
./testcases/kernel/syscalls/signal/signal03
./testcases/kernel/syscalls/signal/signal04
./testcases/kernel/syscalls/signal/signal05
./testcases/kernel/syscalls/sigpending/sigpending02
./testcases/kernel/syscalls/sigprocmask/sigprocmask01
./testcases/kernel/syscalls/sigrelse/sigrelse01
./testcases/kernel/syscalls/sigsuspend/sigsuspend01
./testcases/kernel/syscalls/socketcall/socketcall01
./testcases/kernel/syscalls/socketcall/socketcall02
./testcases/kernel/syscalls/socketcall/socketcall03
./testcases/kernel/syscalls/socketcall/socketcall04
./testcases/kernel/syscalls/socket/socket01
./testcases/kernel/syscalls/socketpair/socketpair01
./testcases/kernel/syscalls/sockioctl/sockioctl01
./testcases/kernel/syscalls/statfs/statfs01
./testcases/kernel/syscalls/statfs/statfs02
./testcases/kernel/syscalls/statfs/statfs03
./testcases/kernel/syscalls/stat/stat01
./testcases/kernel/syscalls/stat/stat02
./testcases/kernel/syscalls/stat/stat03
./testcases/kernel/syscalls/stat/stat05
./testcases/kernel/syscalls/stat/stat06
./testcases/kernel/syscalls/stime/stime01
./testcases/kernel/syscalls/stime/stime02
./testcases/kernel/syscalls/string/string01
./testcases/kernel/syscalls/swapoff/swapoff01
./testcases/kernel/syscalls/swapoff/swapoff02
./testcases/kernel/syscalls/swapon/swapon01
./testcases/kernel/syscalls/swapon/swapon02
./testcases/kernel/syscalls/symlink/symlink01
./testcases/kernel/syscalls/symlink/symlink02
./testcases/kernel/syscalls/symlink/symlink03
./testcases/kernel/syscalls/symlink/symlink04
./testcases/kernel/syscalls/symlink/symlink05
./testcases/kernel/syscalls/sync/sync01
./testcases/kernel/syscalls/sync/sync02
./testcases/kernel/syscalls/syscall/syscall01
./testcases/kernel/syscalls/sysconf/sysconf01
./testcases/kernel/syscalls/sysctl/sysctl01
./testcases/kernel/syscalls/sysctl/sysctl03
./testcases/kernel/syscalls/sysctl/sysctl04
./testcases/kernel/syscalls/sysctl/sysctl05
./testcases/kernel/syscalls/sysfs/sysfs01
./testcases/kernel/syscalls/sysfs/sysfs02
./testcases/kernel/syscalls/sysfs/sysfs03
./testcases/kernel/syscalls/sysfs/sysfs04
./testcases/kernel/syscalls/sysfs/sysfs05
./testcases/kernel/syscalls/sysfs/sysfs06
./testcases/kernel/syscalls/sysinfo/sysinfo01
./testcases/kernel/syscalls/sysinfo/sysinfo02
./testcases/kernel/syscalls/syslog/syslog01
./testcases/kernel/syscalls/syslog/syslog02
./testcases/kernel/syscalls/syslog/syslog03
./testcases/kernel/syscalls/syslog/syslog04
./testcases/kernel/syscalls/syslog/syslog05
./testcases/kernel/syscalls/syslog/syslog06
./testcases/kernel/syscalls/syslog/syslog07
./testcases/kernel/syscalls/syslog/syslog08
./testcases/kernel/syscalls/syslog/syslog09
./testcases/kernel/syscalls/syslog/syslog10
./testcases/kernel/syscalls/syslog/syslog11
./testcases/kernel/syscalls/syslog/syslog12
./testcases/kernel/syscalls/syslog/syslogtst
./testcases/kernel/syscalls/time/time01
./testcases/kernel/syscalls/time/time02
./testcases/kernel/syscalls/times/times01
./testcases/kernel/syscalls/times/times02
./testcases/kernel/syscalls/times/times03
./testcases/kernel/syscalls/truncate/truncate01
./testcases/kernel/syscalls/truncate/truncate02
./testcases/kernel/syscalls/truncate/truncate03
./testcases/kernel/syscalls/truncate/truncate04
./testcases/kernel/syscalls/ulimit/ulimit01
./testcases/kernel/syscalls/umask/umask01
./testcases/kernel/syscalls/umask/umask02
./testcases/kernel/syscalls/umask/umask03
./testcases/kernel/syscalls/umount/umount01
./testcases/kernel/syscalls/umount/umount02
./testcases/kernel/syscalls/umount/umount03
./testcases/kernel/syscalls/umount/umount04
./testcases/kernel/syscalls/uname/uname01
./testcases/kernel/syscalls/uname/uname02
./testcases/kernel/syscalls/uname/uname03
./testcases/kernel/syscalls/unlink/unlink05
./testcases/kernel/syscalls/unlink/unlink06
./testcases/kernel/syscalls/unlink/unlink07
./testcases/kernel/syscalls/unlink/unlink08
./testcases/kernel/syscalls/ustat/ustat01
./testcases/kernel/syscalls/ustat/ustat02
./testcases/kernel/syscalls/utime/utime01
./testcases/kernel/syscalls/utime/utime02
./testcases/kernel/syscalls/utime/utime03
./testcases/kernel/syscalls/utime/utime04
./testcases/kernel/syscalls/utime/utime05
./testcases/kernel/syscalls/utime/utime06
./testcases/kernel/syscalls/vfork/vfork01
./testcases/kernel/syscalls/vfork/vfork02
./testcases/kernel/syscalls/vhangup/vhangup01
./testcases/kernel/syscalls/vhangup/vhangup02
./testcases/kernel/syscalls/wait4/wait401
./testcases/kernel/syscalls/wait4/wait402
./testcases/kernel/syscalls/wait/wait02
./testcases/kernel/syscalls/waitpid/waitpid01
./testcases/kernel/syscalls/waitpid/waitpid02
./testcases/kernel/syscalls/waitpid/waitpid03
./testcases/kernel/syscalls/waitpid/waitpid04
./testcases/kernel/syscalls/waitpid/waitpid05
./testcases/kernel/syscalls/waitpid/waitpid06
./testcases/kernel/syscalls/waitpid/waitpid07
./testcases/kernel/syscalls/waitpid/waitpid08
./testcases/kernel/syscalls/waitpid/waitpid09
./testcases/kernel/syscalls/waitpid/waitpid10
./testcases/kernel/syscalls/waitpid/waitpid11
./testcases/kernel/syscalls/waitpid/waitpid12
./testcases/kernel/syscalls/waitpid/waitpid13
./testcases/kernel/syscalls/write/write01
./testcases/kernel/syscalls/write/write02
./testcases/kernel/syscalls/write/write03
./testcases/kernel/syscalls/write/write04
./testcases/kernel/syscalls/write/write05
./testcases/kernel/syscalls/writev/writev01
./testcases/kernel/syscalls/writev/writev02
./testcases/kernel/syscalls/writev/writev03
./testcases/kernel/syscalls/writev/writev04
./testcases/kernel/syscalls/writev/writev05
./testcases/network/dhcpd/dhcpd_tests.sh
./testcases/network/iptables/iptables_tests.sh
./testcases/network/iproute/ip_tests.sh
./testcases/network/ipv6/echo6/echo601
./testcases/network/ipv6/finger6/finger601
./testcases/network/ipv6/ftp6/ftp01
./testcases/network/ipv6/perf_lan6/perf_lan6
./testcases/network/ipv6/ping6/ping601
./testcases/network/ipv6/rcp6/rcp01
./testcases/network/ipv6/rsh6/rsh01
./testcases/network/ipv6/rwho6/rwho01
./testcases/network/ipv6/sendfile6/sendfile601
./testcases/network/ipv6/tcpdump6/tcpdump601
./testcases/network/multicast/mc_cmds/mc_cmds
./testcases/network/multicast/mc_commo/mc_commo
./testcases/network/multicast/mc_member/mc_member
./testcases/network/multicast/mc_opts/mc_opts
./testcases/network/multicast/mc_opts/opts
./testcases/network/multicast/mc_opts/opts_e
./testcases/network/nfs/nfs01/nfs01
./testcases/network/nfs/nfs02/nfs02
./testcases/network/nfs/nfs03/nfs03
./testcases/network/nfs/nfs04/create_file
./testcases/network/nfs/nfs04/nfs04
./testcases/network/nfs/nfs_fsstress/nfs_fsstress.sh
./testcases/network/nfs/nfs_fsstress/fsstress
./testcases/network/nfs/nfslock01/nfslock01
./testcases/network/nfs/nfsstat01/nfsstat01
./testcases/network/nfs/nfsstress/nfsstress
./testcases/network/nfs/fsx-linux/fsx.sh
./testcases/network/rpc/rpc01/rpc01
./testcases/network/rpc/rpcinfo/rpcinfo01
./testcases/network/rpc/rup/rup01
./testcases/network/rpc/rusers/rusers01
./testcases/network/sockets/ltpClient
./testcases/network/sockets/ltpServer
./testcases/network/tcp_cmds/arp/arp01
./testcases/network/tcp_cmds/echo/echo01
./testcases/network/tcp_cmds/finger/finger01
./testcases/network/tcp_cmds/host/host01
./testcases/network/tcp_cmds/netstat/netstat01
./testcases/network/tcp_cmds/perf_lan/perf_lan
./testcases/network/tcp_cmds/ping/ping01
./testcases/network/tcp_cmds/rcp/rcp01
./testcases/network/tcp_cmds/rdist/rdist01
./testcases/network/tcp_cmds/rsh/rsh01
./testcases/network/tcp_cmds/rwho/rwho01
./testcases/network/tcp_cmds/sendfile/sendfile01
./testcases/network/tcp_cmds/tcpdump/tcpdump01
./testcases/network/traceroute/traceroute_tests.sh
./testcases/network/xinetd/xinetd_tests.sh
./tools/netpipe-2.4/netpipe.sh
./tools/netpipe-2.4/NPtcp
./tools/netpipe-2.4-ipv6/NPtcp-ipv6
./tools/gethost
EOF
# These tests depend on /usr/bin/expect and could be added
# back if there is expect on the target.
#./testcases/network/ipv6/rlogin6/rlogin01
#./testcases/network/ipv6/telnet6/telnet01
#./testcases/network/tcp_cmds/telnet/telnet01
#./testcases/network/tcp_cmds/ftp/ftp01
#./testcases/network/tcp_cmds/rlogin/rlogin01

for file in `cat exe_files.txt`; do
    if [ -e "$file" ]
    then
	    install -m 755 $file $ltpdir/testcases/bin
    fi
done
rm exe_files.txt

# Fixes and cleanup.
cd $ltpdir/testcases/bin
mv eject-tests.sh eject_tests.sh
cd -

cat << EOF > obj_files.txt
./testcases/commands/ade/ar/file1.o
./testcases/commands/ade/ar/file*.in
./testcases/commands/ade/ld/*.o
./testcases/commands/ade/ldd/*.o
./testcases/commands/ade/nm/*.o
./testcases/commands/ade/nm/nmfile*.c
./testcases/commands/ade/objdump/test_arch.o
./testcases/kernel/io/stress_floppy/*_file
./testcases/kernel/sched/sched_stress/sched_datafile
EOF

for file in `cat obj_files.txt`; do
 install -m 644 $file $ltpdir/testcases/bin
done
rm obj_files.txt


%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*

