%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : Library for layout and rendering of internationalized text.
Name            : pango
Version         : 1.19.0
Release         : 1
License         : LGPL
Vendor          : Freescale
Packager        : Stuart Hughes
Group           : System Environment/Libraries
Source          : %{name}-%{version}.tar.gz
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup 

%Build
if rpm --dbpath %{_dbpath} -q xorg-server &>/dev/null
then
        extra_opts='--with-x';
else
        extra_opts='--without-x';
fi

./configure --prefix=%{_prefix} --host=$CFGHOST --build=%{_build} $extra_opts
make

%Install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT/%{pfx}
rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/lib/*.la
rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/lib/pango/*/modules/*.la 

install -d $RPM_BUILD_ROOT/%{pfx}/etc/rc.d/init.d
initscript=$RPM_BUILD_ROOT/%{pfx}/etc/rc.d/init.d/pango
cat > $initscript << EOF
#!/bin/sh
# Copyright 2008, Freescale Semiconductor Inc.
#
if [ "\$1" = "start" ]; then
	echo pango: creating module list
	if [ ! -f /usr/etc/pango/pango.modules ]; then
		mkdir -p /usr/etc/pango
		pango-querymodules > /usr/etc/pango/pango.modules
	fi
fi
EOF
chmod 744 $initscript

#%Post
#export PATH=%{_prefix}/bin:$PATH
#pango-querymodules > %{_prefix}/etc/pango/pango.modules


# Todo?  This may break certain workflows.
#%Postun
#echo Post uninstall: remove file generated by init script
#if [ -n "$RPM_INSTALL_PREFIX" -a -f $RPM_INSTALL_PREFIX/usr/etc/pango/pango.modules ]; then
#	rm -f $RPM_INSTALL_PREFIX/usr/etc/pango/pango.modules
#fi


%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


