%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : Lightweight http server for embedded systems
Name            : boa
Version         : 0.93.15
Release         : uc1
License         : GPL
Vendor          : Freescale
Packager        : Stuart Hughes
Group           : System/Servers
Source          : boa-ucd-20050906.tar.bz2
Patch1          : boa-0.93.15-standalone.patch
Patch2          : boa-0.93.15-daemon.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

This is the uclinux version extracted from uClinux-dist-test-20050906.tar.gz
at http://www.uclinux.org/pub/uClinux/dist/

%Prep
%setup -n boa
%patch1 -p1
%patch2 -p1

%Build
cd src
make CFLAGS="-DEMBED -DSTAND_ALONE -DBOA_TIME_LOG -Os -g" LIBCRYPT="-lcrypt" 

%Install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{pfx}/{etc,usr/sbin,usr/lib/boa,/var/log/boa}
install -m 755 src/boa $RPM_BUILD_ROOT/%{pfx}/usr/sbin
#install -m 755 src/boa_indexer $RPM_BUILD_ROOT/%{pfx}/usr/lib/boa/
install -m 644 examples/boa.conf $RPM_BUILD_ROOT/%{pfx}/etc/
perl -ni -e '
    m,^ScriptAlias, &&  do { $_ = "ScriptAlias /cgi-bin/ /var/www/cgi-bin/\n"};
    m,#ServerName,  &&  do { $_ = "ServerName localhost\n" } ;
    m,#DocumentRoot, && do { $_ = "DocumentRoot /var/www/html\n" };
    m,^DefaultType, && do { $_ = "DefaultType text/html\n" };
    print;
    ' $RPM_BUILD_ROOT/%{pfx}/etc/boa.conf

%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%{pfx}/*
