%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : A small executable that replaces many UNIX utilities
Name            : busybox
Version         : 1.00
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Steve Papacharalambous/Stuart Hughes
Group           : System Environment/Shells
Source          : %{name}-%{version}.tar.bz2
Patch1          : busybox-1.00-syslogd-p-2.patch
Patch2          : busybox-1.00-mmuless.patch
Patch3          : busybox-1.00-insmod.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%Build
PKG_BUSYBOX_PRECONFIG=${PKG_BUSYBOX_PRECONFIG:-busybox.config}
if [ -f "$PLATFORM_PATH/${PKG_BUSYBOX_PRECONFIG}" ]
then
    cp $PLATFORM_PATH/$PKG_BUSYBOX_PRECONFIG .config
else
    if [ -f "$CONFIG_DIR/defaults/$PKG_BUSYBOX_PRECONFIG" ]
    then
        cp "$CONFIG_DIR/defaults/$PKG_BUSYBOX_PRECONFIG"  .config
    fi
fi
if [ -n "$PKG_BUSYBOX_WANT_CF" -o -n "$SCB_WANT_CF" ]
then
    make menuconfig HOSTCC="$BUILDCC"
    cp .config $PLATFORM_PATH/$PKG_BUSYBOX_PRECONFIG
else
    yes "" | make config HOSTCC="$BUILDCC"
fi
make dep HOSTCC="$BUILDCC"
make HOSTCC="$BUILDCC" STRIP=true

%Install
rm -rf $RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT/%{pfx}/bin
make PREFIX=$RPM_BUILD_ROOT/%{pfx} install
mkdir -p $RPM_BUILD_ROOT/%{pfx}/etc/rc.d/init.d
install -d $RPM_BUILD_ROOT/%{pfx}/var/{run,log}
touch $RPM_BUILD_ROOT/%{pfx}/var/run/utmp
touch $RPM_BUILD_ROOT/%{pfx}/var/log/wtmp
cat <<EOF > $RPM_BUILD_ROOT/%{pfx}/etc/busybox.conf
[SUID]
#su = ssx root.root
passwd = ssx root.root
EOF
chmod 644 $RPM_BUILD_ROOT/%{pfx}/etc/busybox.conf

%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%attr(4755,root,root) %{pfx}/bin/busybox
%{pfx}/*

%changelog
* Thu Jul 21 2005 Stuart Hughes <stuarth@freescale.com>
- changed syslogd-p patch to be unconditional
