%define base %(echo %{_prefix} | sed -e s,/usr.*$,,)
%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : coreutils - GNU core utilities commonly used in shell scripts
Name            : coreutils
Version         : 5.0
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Stuart Hughes
Group           : System Environment/Base
Source          : coreutils-5.0.tar.bz2
Patch0          : coreutils-5.0-uname.patch
Patch1          : coreutils-5.0-hostname-2.patch
Patch2          : coreutils-5.0-kill.patch
Patch3          : coreutils-5.0-groups.patch
Patch4          : coreutils-5.0-4.patch
#Patch5          : coreutils-5.0-1146833344.patch
Patch5          : coreutils-5.0-eaccess.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

Provides        : sh-utils

%Description
%{summary}

%Prep
%setup
%patch0 -p1 
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%Build
# fu_cv_sys_stat_statfs2_bsize is needed to turn on df
utils_cv_sys_open_max=1019 fu_cv_sys_stat_statfs2_bsize=yes \
./configure --prefix=%{_prefix} --host=$CFGHOST --build=%{_build} --mandir=%{_mandir}
make

%Install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT/%{pfx}
# brutal, but more subtle attempts failed.
rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/bin/uptime
rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/man/man1/uptime.1

# fix up paths to be compatible with busybox/fileutils/sh-utils etc
mkdir -p $RPM_BUILD_ROOT/%{pfx}/{bin,sbin,%_sbindir}
for f in stty pwd df sync echo ln cat chown rmdir ls uname touch true cp chmod sleep mkdir false date mv chgrp mknod dd rm
do
    mv $RPM_BUILD_ROOT/%{pfx}/{%_bindir,%base/bin}/$f
done
mv $RPM_BUILD_ROOT/%{pfx}/{%_bindir,%_sbindir}/chroot


%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


