%define pfx /opt/freescale/rootfs/%{_target_cpu} 

Summary         : Various compilers (C, C++, Objective-C, Java, ...)
Name            : gcc
Version         : 3.4.3
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Steve Papacharalambous
Group           : Development/Languages
Source          : %{name}-%{version}.tar.bz2
Patch0          : gcc-3.4.0-arm-bigendian.patch
Patch1          : gcc-3.4.0-arm-lib1asm.patch
Patch2          : gcc-3.4.0-arm-nolibfloat.patch
Patch3          : gcc-3.4.3-ccross-syslimits.patch
Patch4          : pr15068-fix.patch
Patch5          : pr16201-fix.patch
Patch6          : gcc-3.4.3-libiberty-cp-demangle.h.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

%Build

# Temporary hack - stevep
# For building toolchain components an optimized version of the
# target is needed.  This should really be defined in the config
# area of ltib, and not done in the toolchain spec files.
# For now we assume that the optimised target can be derived by
# stripping the trailing "-" off the toolchain prefix, but this
# will not be true for all cases, eg when using uClibc toolchains.
OPT_CFGHOST=`echo ${TOOLCHAIN_PREFIX} | perl -n -e 's,-$,,;print'`

# Copy the crt files from the toolchain area to rootfs/usr/lib
# These are the crt files built by glibc (I think - stevep).
X_DIR=`echo ${TOOLCHAIN_PREFIX} | sed -e 's,-$,,'`
TC_PREFIX="`which ${TOOLCHAIN_PREFIX}gcc | perl -p -e 's,/bin/'${TOOLCHAIN_PREFIX}'gcc,,'`"
mkdir -p ${RPM_BUILD_ROOT}/%{pfx}/usr/lib
mkdir -p ${RPM_BUILD_ROOT}/%{pfx}/usr/${X_DIR}/lib
cp ${TC_PREFIX}/${X_DIR}/lib/*.o ${RPM_BUILD_ROOT}/%{pfx}/usr/lib
cp ${TC_PREFIX}/${X_DIR}/lib/*.o ${RPM_BUILD_ROOT}/%{pfx}/usr/${X_DIR}/lib

rm -rf build-gcc
mkdir build-gcc
cd build-gcc
export CPP=$BUILDCPP
    CC_FOR_BUILD="${BUILDCC}" \
    ../configure \
    --host=${OPT_CFGHOST} --build=%{_build} --target=${OPT_CFGHOST} \
    --prefix=%{_prefix} --disable-nls --enable-threads=posix \
    --enable-symvers=gnu --enable-__cxa_atexit --enable-c99 \
    --enable-long-long --enable-languages="c,c++" --enable-shared \
    --mandir=%{_mandir} --libdir=/lib
make all-build-libiberty
make all

%Install
cd build-gcc
make DESTDIR=${RPM_BUILD_ROOT}/%{pfx} install

# Remove the c++ pre-compiled header files.
X_DIR=`echo ${TOOLCHAIN_PREFIX} | sed -e 's,-$,,'`
rm ${RPM_BUILD_ROOT}/%{pfx}/%{_prefix}/include/c++/%{version}/${X_DIR}/bits/stdc++.h.gch/O[02]g
# Remove libtool .la files
find $RPM_BUILD_ROOT/%{pfx} -name \*.la -exec rm {} \;

%Clean
rm -rf ${RPM_BUILD_ROOT}


%Files
%defattr(-,root,root)
%{pfx}/*


