%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : qtopia palmtop environment
Name            : qtopia-free
Version         : 1.7.0
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : John Rigby
Group           : System Environment/Graphics
Source          : %{name}-%{version}.tar.gz
Patch0          : qtopia-mpeg3.patch
Patch1          : qtopia-ppc.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup
%patch0 -p1
%patch1 -p1

%Build
export PLATFORM=linux-powerpc-g++
export PATH=$UNSPOOF_PATH
export QTDIR=$DEV_IMAGE/opt/qt
export QPEDIR=$(pwd)
export TMAKEPATH=$TOP/bin/lib/linux-g++
cat > src/libraries/qtopia/custom-$PLATFORM.h << "EOF"
/*-------------------------------------------------------
 * custom-$PLATFORM.h
 * Autogenerated by qtopia.spec
 * DO NOT MODIFY BY HAND UNLESS YOU KNOW WHAT YOU ARE DOING
 *
 *-------------------------------------------------------*/
#define QPE_USE_MALLOC_FOR_NEW
#define QPE_NEED_CALIBRATION
EOF
cat > include/ppc_config.h << "EOF"
#define QT_QWS_DEPTH16_RGB555
#define QT_QWS_SWAPBYTES_VIDEO
#define QT_QWS_SWAPBYTES_AUDIO
EOF
cd src
./configure -release -platform linux-powerpc-g++
cd -
#rm -f $DEV_IMAGE/opt/qt/lib/libqpe*
cd src/3rdparty/plugins/codecs/libmpeg3
sed -e "s/\-lm \\$/\-lm -lstdc++ \\$/" Makefile > Makefile.new
mv Makefile.new Makefile
sed -e "s/\-lm \\$/\-lm -lstdc++ \\$/" Makefile.in > Makefile.in.new
mv Makefile.in.new Makefile.in
cd -
make -C src SYSCONF_LFLAGS="-Wl,-rpath-link,$DEV_IMAGE/usr/lib:$DEV_IMAGE/lib:$BUILD_DIR/lib -L$DEV_IMAGE/usr/lib --allow-shlib-undefined"


%Install
rm -rf $RPM_BUILD_ROOT
if [ ! $QPE_INSTALL_DIR ]
then
QPE_INSTALL_DIR=opt/QtPalmtop
fi
export QPEDIR=$(pwd)
export BUILD_DIR=$(pwd)
export QTDIR=$DEV_IMAGE/opt/qt
make -C src packages
install -d $RPM_BUILD_ROOT/%{pfx}/etc/rc.d
cat > $RPM_BUILD_ROOT/%{pfx}/etc/rc.d/rc.qpe << EOF
#!/bin/sh
#
# Copyright 2005, Freescale Semiconductor Inc.
#
# Set QPE_USE_TOUCHSCREEN to "y" to use touchscreen 
# otherwise mouse will be used
#
export QPE_USE_TOUCHSCREEN="$PKG_QTOPIA_WANT_TOUCHSCREEN"
# make sure usb input and touchscreen node exist
mkdir -p /dev/input
test -c /dev/input/mice || mknod /dev/input/mice c 13 63
test -c /dev/ts || mknod /dev/ts c 11 0
export QPEDIR="/opt/QtPalmtop"
export QTDIR="/opt/qt"
export LD_LIBRARY_PATH="/opt/qt/lib:/opt/QtPalmtop/lib"
export QWS_SIZE="1024x768"
export QWS_DISPLAY="Transformed:Rot0:0"

if [ _\$QPE_USE_TOUCHSCREEN = "_y" ]
then
# changing the :/dev/ts part will have no effect as it 
# is hardcoded in the source
export QWS_MOUSE_PROTO="TPanel:/dev/ts"
# hide cursor when using touchscreen
export QWS_HIDE_CURSOR="Yes"
grep touchscreen /proc/devices > /dev/null || insmod mpc5200_touch.ko
# remove pointercal if it is empty
[ -f /etc/pointercal -a ! -s /etc/pointercal ] && rm -f /etc/pointercal
else
# no QWS_KEYBOARD config it just defaults to /dev/tty0
# which means virtual console must be on
export QWS_MOUSE_PROTO="USB:/dev/input/mice"
# overide pointer calibration when using mouse
touch /etc/pointercal 
fi

export HOME=/root
export KDEHOME=/opt/QtPalmtop
export PATH="$PATH:$QPEDIR/bin"
cp /root/Settings/PluginLoader.conf.orig /root/Settings/PluginLoader.conf
cd /opt/QtPalmtop/bin
./qpe > /dev/null 2>&1
EOF
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/apps
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/pics
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/plugins
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/docs
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/library
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/include
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/etc
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/services/qpe
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/help
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/i18n
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/zone
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/zone
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/etc
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/include/qtopia
install -d $RPM_BUILD_ROOT/%{pfx}/var/lock/subsys
install -d $RPM_BUILD_ROOT/%{pfx}/home
cp -rf $BUILD_DIR/include/qtopia/. $RPM_BUILD_ROOT/%{pfx}/opt/qt/include/qtopia/
cp -af $BUILD_DIR/include/qpe $RPM_BUILD_ROOT/%{pfx}/opt/qt/include/
cp -af $BUILD_DIR/lib/*  $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/
cp -af $BUILD_DIR/bin/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/
cp -af $BUILD_DIR/apps/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/apps/
cp -af $BUILD_DIR/pics/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/pics/
cp -af $BUILD_DIR/plugins/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/plugins/
cp -af $BUILD_DIR/docs/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/docs/
cp -af $BUILD_DIR/etc/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/etc/
cp -af $BUILD_DIR/services/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/services/
cp -af $BUILD_DIR/help/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/help/
cp -af $BUILD_DIR/i18n/. $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/i18n/
ln -s /$QPE_INSTALL_DIR/etc/qimpen $RPM_BUILD_ROOT/%{pfx}/opt/qt/etc/qimpen
ln -s /$QPE_INSTALL_DIR/etc/ipkg.conf $RPM_BUILD_ROOT/%{pfx}/opt/qt/etc/ipkg.conf
ln -s /$QPE_INSTALL_DIR $RPM_BUILD_ROOT/%{pfx}/opt/Qtopia
ln -s /$QPE_INSTALL_DIR $RPM_BUILD_ROOT/%{pfx}/home/QtPalmtop
ln -s $DEV_IMAGE/opt/qt/include/qtopia $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/library/qpe
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/showimg
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/clock
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/todolist
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/calculator
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/addressbook
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/textedit
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/mpegplayer
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/datebook
ln -sf quicklauncher $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin/today
echo '1' > $RPM_BUILD_ROOT/%{pfx}/etc/firstuse


%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


