%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : The RPM package management system.
Name            : rpm
Version         : 4.0.4
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Stuart Hughes
Group           : System Environment/Base
Source          : %{name}-%{version}.tar.gz
Patch0          : rpm_lfs.patch
Patch1          : rpm-4.0.4-python-configure.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}
BuildRequires   : zlib

%Description
%{summary}

Modifications: 

 * Allow short circuited builds to produce binary rpms for incremental deploy

%Prep
%setup 
%patch0 -p1
%patch1 -p1
#perl -pi".bak" -e 's,^sys_lib_search_path_spec=".*,sys_lib_search_path_spec=,' `find . -name configure`

%Build
case "$LINTARCH" in
    arm*)
        mutex_type="POSIX/pthreads/library"
        ;;
    i386)
        mutex_type="x86/gcc-assembly"
        ;;
    m68k)
        mutex_type="68K/gcc-assembly"
        ;;
    ppc)
        mutex_type="PPC/gcc-assembly"
        ;;
    *)
       echo "dont know how to handle mutexes for $LINTARCH"
       exit 1
       ;;
esac

# obviously these need to be fixed for 64bit machines
ac_cv_have_working_aio=yes \
ac_cv_sizeof_char=1 \
ac_cv_sizeof_unsigned_char=1 \
ac_cv_sizeof_short=2 \
ac_cv_sizeof_unsigned_short=2 \
ac_cv_sizeof_int=4 \
ac_cv_sizeof_unsigned_int=4 \
ac_cv_sizeof_long=4 \
ac_cv_sizeof_unsigned_long=4 \
ac_cv_sizeof_long_long=8 \
ac_cv_sizeof_unsigned_long_long=8 \
ac_cv_sizeof_float=4 \
ac_cv_sizeof_double=8 \
db_cv_alignp_t="unsigned long" \
db_cv_mutex="$mutex_type" \
db_cv_fcntl_f_setfd="yes" \
db_cv_sprintf_count="yes" \
./configure --prefix=%{_prefix} --host=$CFGHOST --build=%{_build} --localstatedir=/var --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} --without-python --without-javaglue --disable-static

make

%Install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT/%{pfx}
rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/lib/*.la

%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


