%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : System configuration package
Name            : sysconfig
Version         : 1.0
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Stuart Hughes
Group           : System Environment/Base
#Source          : %{name}-%{version}.tar.bz2
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
#%setup 

%Build

%Install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{pfx}/etc/rc.d
if [ -n "$SYSCFG_DHCPC0" ]
then
    SYSCFG_IPADDR0="dhcp"
fi

if [ "$SYSCFG_START_SYSLOG" = "y" ]
then
    syslog=syslog
fi
if [ "$SYSCFG_START_NETWORK" = "y" ]
then
    network=network
fi
if [ "$SYSCFG_START_INETD" = "y" ]
then
    inetd=inetd
fi
if [ "$SYSCFG_START_PORTMAP" = "y" ]
then
    portmap=portmap
fi
if [ "$SYSCFG_START_DROPBEAR_SSH" = "y" ]
then
    dropbear=dropbear
fi
if [ "$SYSCFG_START_BOA" = "y" ]
then
    boa=boa
fi
if [ "$SYSCFG_SETTIME" = "y" ]
then
    settime=settime
fi

cat <<EOF > $RPM_BUILD_ROOT/%{pfx}/etc/rc.d/rc.conf
export HOSTNAME=${SYSCFG_HOSTNAME:-ltib}
export INTERFACE=${SYSCFG_NET_INTERFACE0:-eth0}
export IPADDR=${SYSCFG_IPADDR0:-192.168.0.253}
export NETMASK=${SYSCFG_NET_MASK0:-255.255.255.0}
export BROADCAST=${SYSCFG_NET_BROADCAST0:-192.168.0.255}
export GATEWAY=${SYSCFG_NET_GATEWAY0:-192.168.0.1}
export NAMESERVER=${SYSCFG_NAMESERVER0:-192.168.0.1}
export NTP_SERVER=${SYSCFG_NTP_SERVER:-ntp.cs.strath.ac.uk}
export MODLIST="$SYSCFG_MODLIST"
export RAMDIRS="$SYSCFG_RAM_DIRS"
export TMPFS="$SYSCFG_TMPFS"
export READONLY_FS="$SYSCFG_READONLY_FS"
export SYSLOG_SOCKET_FILE="$SYSCFG_SYSLOG_SOCKET_FILE"
export INETD_ARGS="${SYSCFG_INETD_ARGS}"
export BOA_ARGS="${SYSCFG_BOA_ARGS}"

all_services="splash hostname filesystems local syslog depmod modules network settime inetd portmap dropbear boa"
all_services_r="boa dropbear portmap inetd settime network modules depmod syslog filesystems hostname"

cfg_services="splash hostname filesystems local $syslog depmod modules $network $settime $inetd $portmap $dropbear $boa"

cfg_services_r="$boa $dropbear $portmap $inetd $settime $network modules depmod $syslog filesystems hostname"

EOF


if [ "$SYSCFG_WANT_LOGIN_TTY" = "y" ]
then
    sys_login="$SYSCFG_LOGING_TTY"
else
    sys_login="::respawn:-/bin/sh"
fi
cat <<EOF > $RPM_BUILD_ROOT/%{pfx}/etc/inittab
# see busybox-1.00rc2/examples/inittab for more examples
::sysinit:/etc/rc.d/rcS
$sys_login
::ctrlaltdel:/sbin/reboot
::shutdown:/etc/rc.d/rcS stop
::shutdown:/bin/umount -a -r
::shutdown:/sbin/swapoff -a
::restart:/sbin/init
EOF


%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%{pfx}/*
