######################################################################
#
# Copyright  Freescale Semiconductor, Inc. 2004-2007. All rights reserved.
#
# Stuart Hughes, stuarth@freescale.com,  27th March 2007
#
# This file is part of LTIB.
#
# LTIB is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LTIB is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LTIB; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
# Description:
#
# Additional seldom used addsrpms mode
#
# CVS version: $Revision: 1.1.1.1 $
#
######################################################################
package main;

sub addsrpms
{
    my ($packages, $srpm, $sn);

    # Use spec name but should really be name:<> in specfile
    foreach my $key (mk_buildlist()) {
         $packages->{$$key->{sn}} = 1;
    }

SRPM:
    for $srpm (@ARGV) {
        warn("skipping: $srpm, doesn't look like an srpm\n"), next
                                               unless $srpm =~ m,\.src\.rpm$,;
        foreach my $fl (`rpm --dbpath $cf->{rpmdb} -qlp $srpm`) {
            $fl =~ m,^(\w+)\.spec\s*$, and do { $sn = $1, last }; 
        }
        warn("skipping: $srpm, can't find a spec file\n"),next unless $sn;
        warn("skipping: $srpm, $sn is already in the package list\n"),next
                                               if $packages->{$sn};

        print "importing $srpm to $cf->{rpmdir}\n";
        my ($srpm_name) = $srpm =~  m,/?([^/]+)$,;
        system_nb(<<TXT) == 0 or die;
set -x -e
$echo rpm --dbpath $cf->{rpmdb} --define '_topdir $cf->{rpmdir}' -ivh $srpm
TXT
        # Fixup the spec file and move to the distro area
        my $specpath = "$cf->{rpmdir}/SPECS/$sn.spec";
        my $tok = parse_spec($specpath) or die();

        if( defined($tok->{pfx}) && $tok->{pfx} =~ m,^/opt/freescale, ) {
            # LTIB spec file do nothing
        } else {
            system_nb("mv $specpath $specpath.bak") == 0 or die();

            # attempt to fix the install destdir
            $tok->{install} =~ s,((?:DESTDIR|PREFIX)=\$RPM_BUILD_ROOT),$1/%{pfx},;

            open(SPEC, ">$specpath") or die("open $specpath : $!");
            print SPEC <<TXT;
%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : $tok->{summary}
Name            : $tok->{name}
Version         : $tok->{version}
Release         : $tok->{release}
License         : ${\( $tok->{license} || "UNKNOWN" )}
Vendor          : ${\( $tok->{vendor}  || "UNKNOWN" )}(Freescale)
Packager        : ${\( $tok->{packager}|| "UNKNOWN" )}(LTIB addsrpms)
Group           : $tok->{group}
URL             : ${\( $tok->{url} || "UNKNOWN" )}
TXT
            my $n = '';
            foreach my $fl ( split(/\s*\n/, $tok->{sources}) ) {
                print SPEC "Source$n          : $fl\n";
                $n = $n ? $n+1 : 1;
            }
            $n = 1;
            foreach my $fl ( split(/\s*\n/, $tok->{patches}) ) {
                print SPEC "Patch$n          : $fl\n";
                $n = $n ? $n+1 : 1;
            }
            print SPEC <<TXT;
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

NOTE: this was imported by ltib -m addsrpms $srpm_name

%Prep
$tok->{prep}

%Build
$tok->{build}

%Install
$tok->{install}

%Clean
rm -rf \$RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%{pfx}/*
TXT
        }

        # move the spec file to the right place, with checks
        my $specdir = "$cf->{top}/$pcf->{DISTRO}/$sn";
        if(-f "$specdir/$sn.spec" ) {
            print("WARNING: $specdir/$sn.spec exists\n",
                  "using:   $specdir/$sn-import.spec\n");
            $sn = "$sn-import";
        }
        mkdir($specdir) unless -d $specdir;
        system_nb("mv $specpath $specdir/$sn.spec") == 0 or die();

        # add an entry into pkg_map
        my $key = 'PKG_' . uc($tok->{name});
        $key =~ s,-,_,g;
        
        local $^I = '.bak';
        @ARGV = "$cf->{config_dir}/userspace/$cf->{pkg_map}";
        while(<>) {
            s,^(# leave these as the),$key = $tok->{name}\n\n$1,;
            print;
        }

        # Add an entry to packages.lkc
        my @pkeys = ();
        my $plkc  = "$cf->{config_dir}/userspace/packages.lkc";
        open(PLKC, $plkc) or die("open $plkc : $!\n");
        while(<PLKC>) {
            my ($ckey) = m,\s*config\s(PKG_\w+)\s*$,;
            next unless $ckey;
            warn("$key already exists in packages.lkc, not updating\n"), 
                                                    next SRPM if $ckey eq $key;
            push @pkeys, $ckey;
        }
        close PLKC;

        my $mark = 'PKG_ZLIB';
        foreach my $ckey ( sort @pkeys ) {
            if($key lt $ckey) {
                $mark = $ckey;
                last;
            }
        }
        @ARGV = $plkc;
        while(<>) {
            my ($ckey) = m,\s*config\s(PKG_\w+)\s*$,;
            if($ckey && $ckey eq $mark) {
                print <<TXT;
config $key
    depends CAP_HAS_MMU
    bool "$tok->{name}"
    help
      $tok->{summary}

TXT
            }
            print;
        }
    }
    return 1;
}
1;
