/* Generated by GOB (v2.0.11)   (do not edit directly) */



/***************************************************************************
                    lum-player.gob  -  Lumiere Player Widget (abstract)
                             -------------------
    begin                : dim jan  26 02:08:47 BST 2002
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <glib.h>
#include <glib-object.h>
#ifndef __LUM_PLAYER_H__
#define __LUM_PLAYER_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



#include "lum-config.h"
#include "lum-player-info.h"

#include <gtk/gtk.h>
#include <stdbool.h>


typedef enum {
	PLAYER_NONE,
	PLAYER_PLAYING,
	PLAYER_PAUSED,
	PLAYER_STOPPED
} LumPlayerStatus;
#define LUM_TYPE_PLAYER_STATUS lum_player_status_get_type()
GType lum_player_status_get_type (void);


/*
 * Type checking and casting macros
 */
#define LUM_TYPE_PLAYER	(lum_player_get_type())
#define LUM_PLAYER(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), lum_player_get_type(), LumPlayer)
#define LUM_PLAYER_CONST(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), lum_player_get_type(), LumPlayer const)
#define LUM_PLAYER_CLASS(klass)	G_TYPE_CHECK_CLASS_CAST((klass), lum_player_get_type(), LumPlayerClass)
#define LUM_IS_PLAYER(obj)	G_TYPE_CHECK_INSTANCE_TYPE((obj), lum_player_get_type ())

#define LUM_PLAYER_GET_CLASS(obj)	G_TYPE_INSTANCE_GET_CLASS((obj), lum_player_get_type(), LumPlayerClass)

/* Private structure type */
typedef struct _LumPlayerPrivate LumPlayerPrivate;

/*
 * Main object structure
 */
#ifndef __TYPEDEF_LUM_PLAYER__
#define __TYPEDEF_LUM_PLAYER__
typedef struct _LumPlayer LumPlayer;
#endif
struct _LumPlayer {
	GtkVBox __parent__;
	/*< private >*/
	bool repeat; /* protected */
	LumPlayerPrivate *_priv;
};

/*
 * Class definition
 */
typedef struct _LumPlayerClass LumPlayerClass;
struct _LumPlayerClass {
	GtkVBoxClass __parent__;
	bool (* open_file) (LumPlayer * self, const char * uri, LumPlayerInfo * info);
	void (* play_pause) (LumPlayer * self);
	void (* stop) (LumPlayer * self);
	int (* get_stream_length) (LumPlayer * self);
	void (* set_contrast) (LumPlayer * self, double pos);
	void (* set_brightness) (LumPlayer * self, double pos);
	void (* set_hue) (LumPlayer * self, double pos);
	void (* set_saturation) (LumPlayer * self, double pos);
	void (* set_eq) (LumPlayer * self, int hz, double pos);
	void (* set_volume) (LumPlayer * self, double vol);
	double (* get_volume) (LumPlayer * self);
	bool (* next) (LumPlayer * self);
	bool (* prev) (LumPlayer * self);
	bool (* is_running) (LumPlayer * self);
	bool (* can_play) (LumPlayer * self);
	char ** (* get_mime_types) (LumPlayer * self);
	char ** (* get_cdda_list) (LumPlayer * self, int * num);
	char ** (* get_dvd_list) (LumPlayer * self, int * num);
	/*signal*/void (* playbackfinished) (LumPlayer * self);
	/*signal*/void (* volume_changed) (LumPlayer * self, double volume);
};


/*
 * Public methods
 */
GType	lum_player_get_type	(void);
LumConfig * 	lum_player_get_config	(LumPlayer * self);
void 	lum_player_set_config	(LumPlayer * self,
					LumConfig * val);
LumPlayerStatus 	lum_player_get_status	(LumPlayer * self);
void 	lum_player_set_status	(LumPlayer * self,
					LumPlayerStatus val);
gdouble 	lum_player_get_position	(LumPlayer * self);
void 	lum_player_set_position	(LumPlayer * self,
					gdouble val);
gint 	lum_player_get_time	(LumPlayer * self);
void 	lum_player_set_time	(LumPlayer * self,
					gint val);
gboolean 	lum_player_get_is_seekable	(LumPlayer * self);
void 	lum_player_set_is_seekable	(LumPlayer * self,
					gboolean val);
gboolean 	lum_player_get_can_fullscreen	(LumPlayer * self);
void 	lum_player_set_can_fullscreen	(LumPlayer * self,
					gboolean val);
gboolean 	lum_player_get_fullscreen	(LumPlayer * self);
void 	lum_player_set_fullscreen	(LumPlayer * self,
					gboolean val);
gboolean 	lum_player_get_can_hide_bars	(LumPlayer * self);
void 	lum_player_set_can_hide_bars	(LumPlayer * self,
					gboolean val);
gboolean 	lum_player_get_mute	(LumPlayer * self);
void 	lum_player_set_mute	(LumPlayer * self,
					gboolean val);
gboolean 	lum_player_get_repeat	(LumPlayer * self);
void 	lum_player_set_repeat	(LumPlayer * self,
					gboolean val);
bool 	lum_player_open_file	(LumPlayer * self,
					const char * uri,
					LumPlayerInfo * info);
void 	lum_player_play_pause	(LumPlayer * self);
void 	lum_player_stop	(LumPlayer * self);
int 	lum_player_get_stream_length	(LumPlayer * self);
void 	lum_player_set_contrast	(LumPlayer * self,
					double pos);
void 	lum_player_set_brightness	(LumPlayer * self,
					double pos);
void 	lum_player_set_hue	(LumPlayer * self,
					double pos);
void 	lum_player_set_saturation	(LumPlayer * self,
					double pos);
void 	lum_player_set_eq	(LumPlayer * self,
					int hz,
					double pos);
void 	lum_player_set_volume	(LumPlayer * self,
					double vol);
double 	lum_player_get_volume	(LumPlayer * self);
bool 	lum_player_next	(LumPlayer * self);
bool 	lum_player_prev	(LumPlayer * self);
bool 	lum_player_is_running	(LumPlayer * self);
bool 	lum_player_can_play	(LumPlayer * self);
char ** 	lum_player_get_mime_types	(LumPlayer * self);
char ** 	lum_player_get_cdda_list	(LumPlayer * self,
					int * num);
char ** 	lum_player_get_dvd_list	(LumPlayer * self,
					int * num);
void 	lum_player_playbackfinished	(LumPlayer * self);
void 	lum_player_volume_changed	(LumPlayer * self,
					double volume);
void 	lum_player_show_runtime	(LumPlayer * self);
void 	lum_player_set_popup_menu	(LumPlayer * self,
					GtkMenu * menu);
void 	lum_player_show_props_window	(const LumPlayerInfo * info);
void 	lum_player_properties_cb	(GtkButton * button,
					LumPlayer * self);
LumPlayer * 	lum_player_factory	(LumConfigBackend player_type,
					LumConfig * config);

/*
 * Signal connection wrapper macros
 */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define lum_player_connect__playbackfinished(object,func,data)	g_signal_connect(LUM_PLAYER(__extension__ ({LumPlayer *___object = (object); ___object; })),"playbackfinished",(GCallback) __extension__ ({void (* ___playbackfinished) (LumPlayer * ___fake___self, gpointer ___data ) = (func); ___playbackfinished; }), (data))
#define lum_player_connect_after__playbackfinished(object,func,data)	g_signal_connect_after(LUM_PLAYER(__extension__ ({LumPlayer *___object = (object); ___object; })),"playbackfinished",(GCallback) __extension__ ({void (* ___playbackfinished) (LumPlayer * ___fake___self, gpointer ___data ) = (func); ___playbackfinished; }), (data))
#define lum_player_connect_data__playbackfinished(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(__extension__ ({LumPlayer *___object = (object); ___object; })),"playbackfinished",(GCallback) __extension__ ({void (* ___playbackfinished) (LumPlayer * ___fake___self, gpointer ___data ) = (func); ___playbackfinished; }), (data), (destroy_data), (GConnectFlags)(flags))
#define lum_player_connect__volume_changed(object,func,data)	g_signal_connect(LUM_PLAYER(__extension__ ({LumPlayer *___object = (object); ___object; })),"volume_changed",(GCallback) __extension__ ({void (* ___volume_changed) (LumPlayer * ___fake___self, double ___fake___volume, gpointer ___data ) = (func); ___volume_changed; }), (data))
#define lum_player_connect_after__volume_changed(object,func,data)	g_signal_connect_after(LUM_PLAYER(__extension__ ({LumPlayer *___object = (object); ___object; })),"volume_changed",(GCallback) __extension__ ({void (* ___volume_changed) (LumPlayer * ___fake___self, double ___fake___volume, gpointer ___data ) = (func); ___volume_changed; }), (data))
#define lum_player_connect_data__volume_changed(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(__extension__ ({LumPlayer *___object = (object); ___object; })),"volume_changed",(GCallback) __extension__ ({void (* ___volume_changed) (LumPlayer * ___fake___self, double ___fake___volume, gpointer ___data ) = (func); ___volume_changed; }), (data), (destroy_data), (GConnectFlags)(flags))
#else /* __GNUC__ && !__STRICT_ANSI__ */
#define lum_player_connect__playbackfinished(object,func,data)	g_signal_connect(LUM_PLAYER(object),"playbackfinished",(GCallback)(func),(data))
#define lum_player_connect_after__playbackfinished(object,func,data)	g_signal_connect_after(LUM_PLAYER(object),"playbackfinished",(GCallback)(func),(data))
#define lum_player_connect_data__playbackfinished(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(object),"playbackfinished",(GCallback)(func),(data),(destroy_data),(GConnectFlags)(flags))
#define lum_player_connect__volume_changed(object,func,data)	g_signal_connect(LUM_PLAYER(object),"volume_changed",(GCallback)(func),(data))
#define lum_player_connect_after__volume_changed(object,func,data)	g_signal_connect_after(LUM_PLAYER(object),"volume_changed",(GCallback)(func),(data))
#define lum_player_connect_data__volume_changed(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(object),"volume_changed",(GCallback)(func),(data),(destroy_data),(GConnectFlags)(flags))
#endif /* __GNUC__ && !__STRICT_ANSI__ */


/*
 * Argument wrapping macros
 */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define LUM_PLAYER_PROP_CONFIG(arg)    	"config", __extension__ ({LumConfig * z = (arg); z;})
#define LUM_PLAYER_GET_PROP_CONFIG(arg)	"config", __extension__ ({LumConfig * *z = (arg); z;})
#define LUM_PLAYER_PROP_STATUS(arg)    	"status", __extension__ ({LumPlayerStatus z = (arg); z;})
#define LUM_PLAYER_GET_PROP_STATUS(arg)	"status", __extension__ ({LumPlayerStatus *z = (arg); z;})
#define LUM_PLAYER_PROP_POSITION(arg)    	"position", __extension__ ({gdouble z = (arg); z;})
#define LUM_PLAYER_GET_PROP_POSITION(arg)	"position", __extension__ ({gdouble *z = (arg); z;})
#define LUM_PLAYER_PROP_TIME(arg)    	"time", __extension__ ({gint z = (arg); z;})
#define LUM_PLAYER_GET_PROP_TIME(arg)	"time", __extension__ ({gint *z = (arg); z;})
#define LUM_PLAYER_PROP_IS_SEEKABLE(arg)    	"is_seekable", __extension__ ({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_IS_SEEKABLE(arg)	"is_seekable", __extension__ ({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_CAN_FULLSCREEN(arg)    	"can_fullscreen", __extension__ ({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_CAN_FULLSCREEN(arg)	"can_fullscreen", __extension__ ({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_FULLSCREEN(arg)    	"fullscreen", __extension__ ({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_FULLSCREEN(arg)	"fullscreen", __extension__ ({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_CAN_HIDE_BARS(arg)    	"can_hide_bars", __extension__ ({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_CAN_HIDE_BARS(arg)	"can_hide_bars", __extension__ ({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_MUTE(arg)    	"mute", __extension__ ({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_MUTE(arg)	"mute", __extension__ ({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_REPEAT(arg)    	"repeat", __extension__ ({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_REPEAT(arg)	"repeat", __extension__ ({gboolean *z = (arg); z;})
#else /* __GNUC__ && !__STRICT_ANSI__ */
#define LUM_PLAYER_PROP_CONFIG(arg)    	"config",(LumConfig * )(arg)
#define LUM_PLAYER_GET_PROP_CONFIG(arg)	"config",(LumConfig * *)(arg)
#define LUM_PLAYER_PROP_STATUS(arg)    	"status",(LumPlayerStatus )(arg)
#define LUM_PLAYER_GET_PROP_STATUS(arg)	"status",(LumPlayerStatus *)(arg)
#define LUM_PLAYER_PROP_POSITION(arg)    	"position",(gdouble )(arg)
#define LUM_PLAYER_GET_PROP_POSITION(arg)	"position",(gdouble *)(arg)
#define LUM_PLAYER_PROP_TIME(arg)    	"time",(gint )(arg)
#define LUM_PLAYER_GET_PROP_TIME(arg)	"time",(gint *)(arg)
#define LUM_PLAYER_PROP_IS_SEEKABLE(arg)    	"is_seekable",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_IS_SEEKABLE(arg)	"is_seekable",(gboolean *)(arg)
#define LUM_PLAYER_PROP_CAN_FULLSCREEN(arg)    	"can_fullscreen",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_CAN_FULLSCREEN(arg)	"can_fullscreen",(gboolean *)(arg)
#define LUM_PLAYER_PROP_FULLSCREEN(arg)    	"fullscreen",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_FULLSCREEN(arg)	"fullscreen",(gboolean *)(arg)
#define LUM_PLAYER_PROP_CAN_HIDE_BARS(arg)    	"can_hide_bars",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_CAN_HIDE_BARS(arg)	"can_hide_bars",(gboolean *)(arg)
#define LUM_PLAYER_PROP_MUTE(arg)    	"mute",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_MUTE(arg)	"mute",(gboolean *)(arg)
#define LUM_PLAYER_PROP_REPEAT(arg)    	"repeat",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_REPEAT(arg)	"repeat",(gboolean *)(arg)
#endif /* __GNUC__ && !__STRICT_ANSI__ */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
