#include <lum-player.h>
#include <lum-config.h>
#include <lum-player-info.h>

int main(int argc, char **argv)
{
	LumPlayer *player;
	GtkWidget *window;

	gtk_init(&argc, &argv);

	for(int i = 0; i < 1; i++) {
		player = lum_player_factory(PLAYER_GL,
					LUM_CONFIG(g_object_new(LUM_TYPE_CONFIG,NULL)));
		g_object_set(G_OBJECT(player),
			"LumPlayer::can_hide_bars", FALSE, NULL);
		g_object_set(G_OBJECT(player), "GtkXine::show_vfx", FALSE,
						"LumPlayer::repeat", FALSE,
						"LumPlayer::can_fullscreen", TRUE, NULL);

		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

		gtk_container_add(GTK_CONTAINER(window), GTK_WIDGET(player));
		gtk_widget_show_all(window);
		LumPlayerInfo *info = lum_player_info_factory(argv[1], NULL);
		lum_player_open_file(player, argv[1], info);
		g_signal_connect(G_OBJECT(window), "delete-event",
			G_CALLBACK(gtk_widget_destroy), window);
	}
	gtk_main();
}
	
