#
# Note that this is NOT a relocatable package
#

%define ver      0.5.0
%define rel      1
%define prefix   /usr
%define name	 lumiere

Summary: Lumiere
Name: %name
Version: %ver
Release: %rel
Copyright: GPL
Group: Applications/Multimedia
Source: http://users.aber.ac.uk/ssk01/prog/sources/lumiere-%{ver}.tar.gz
BuildRoot: /var/tmp/eog
Obsoletes: lumiere
Packager: Stephane Konstantaropoulos <ssk01@aber.ac.uk>
URL: http://users.aber.ac.uk/ssk01/lumiere
Prereq: /sbin/install-info
Prefix: %{prefix}
Docdir: %{prefix}/doc
Requires: ORBit >= 0.5.0
Requires: oaf >= 0.3.0
Requires: gdk-pixbuf >= 0.9.0
Requires: bonobo >= 0.15
Requires: gconf >= 0.8

%description
Lumiere, a movie player for Gnome based on mplayer.

%changelog
%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="-pipe $RPM_OPT_FLAGS" ./autogen.sh       \
        --prefix=%{prefix} --sysconfdir=%{sysconfdir} \
        --localstatedir=%{localstatedir}
else
  CFLAGS="-pipe $RPM_OPT_FLAGS" ./configure       \
        --prefix=%{prefix} --sysconfdir=%{sysconfdir} \
        --localstatedir=%{localstatedir}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=$RPM_BUILD_ROOT%{prefix} \
        sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} \
        localstatedir=$RPM_BUILD_ROOT%{localstatedir}

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog HACKING NEWS README THANKS TODO
%{prefix}/bin/*
%{prefix}/share/gnome/apps/*
%{prefix}/share/pixmaps/*
%{prefix}/share/locale/*
%{prefix}/share/oaf/*
%{prefix}/share/gnome/help/*
%config /etc/CORBA/*
