/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                          gtk-player.gob  -  GtkWidget That embeds mplayer
                             -------------------
    begin                : lun jan 6 02:08:47 BST 2002
    copyright            : (C) 2002 by Stphane Konstantaropoulos
    email                : ssk01@aber.ac.uk | stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * GtkPlayer:
 *
 * Class derived from LumPlayer that embeds mplayer.
 * We use a GtkSocket that receives the mplayer window through
 * The Xembed protocol (implemented by mplayer).
 * The runtime calls are made through a pipe to mplayer's stdin,
 * it is no guaranteed that they will be executed immediately.
 * There is no control on whether mplayer is still running or not.
 * It can use only mplayer's xvideo output, the X11 output gives
 * Bad X Parameters.
 * This widget has no other dependencies than Gtk (v 2 probably),
 * You can use any config that you want, just implement LumConfig class.
 *
 * Thanks to the mplayer team for their great piece of software!
 * Visit them at http://www.mplayerhq.hu
 *
 */


#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include "gtk-player.h"

#include "gtk-player-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) GTK_PLAYER(x)
#define SELF_CONST(x) GTK_PLAYER_CONST(x)
#define IS_SELF(x) GTK_IS_PLAYER(x)
#define TYPE_SELF GTK_TYPE_PLAYER
#define SELF_CLASS(x) GTK_PLAYER_CLASS(x)

#define SELF_GET_CLASS(x) GTK_PLAYER_GET_CLASS(x)

/* self typedefs */
typedef GtkPlayer Self;
typedef GtkPlayerClass SelfClass;

/* here are local prototypes */
static void gtk_player_class_init (GtkPlayerClass * c) G_GNUC_UNUSED;
static void gtk_player_init (GtkPlayer * self) G_GNUC_UNUSED;
static void ___3_gtk_player_dispose (GObject * object) G_GNUC_UNUSED;
static void ___4_gtk_player_play_pause (LumPlayer * player) G_GNUC_UNUSED;
static void ___5_gtk_player_stop (LumPlayer * player) G_GNUC_UNUSED;
static void ___6_gtk_player_set_position (LumPlayer * player, gdouble position) G_GNUC_UNUSED;
static void ___7_gtk_player_osd (LumPlayer * player) G_GNUC_UNUSED;
static gboolean ___8_gtk_player_open_file (LumPlayer * player, gchar * uri, LumPlayerInfo * info) G_GNUC_UNUSED;
static gboolean ___9_gtk_player_get_position_time (LumPlayer * player, gdouble * position, gint * time) G_GNUC_UNUSED;
static gboolean ___a_gtk_player_is_running (LumPlayer * self) G_GNUC_UNUSED;
static gboolean ___b_gtk_player_can_play (LumPlayer * player) G_GNUC_UNUSED;
static void ___c_gtk_player_set_contrast (LumPlayer * player, gdouble contrast) G_GNUC_UNUSED;
static void ___d_gtk_player_set_brightness (LumPlayer * player, gdouble brightness) G_GNUC_UNUSED;
static void ___e_gtk_player_set_hue (LumPlayer * player, gdouble hue) G_GNUC_UNUSED;
static void ___f_gtk_player_set_saturation (LumPlayer * player, gdouble saturation) G_GNUC_UNUSED;
static void gtk_player_pause (GtkPlayer * self) G_GNUC_UNUSED;
static void gtk_player_restart (GtkPlayer * self) G_GNUC_UNUSED;
static gint gtk_player_check_pid (gpointer data) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static LumPlayerClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new(args...) gtk_player_new(args)
#define self_framedrop(args...) gtk_player_framedrop(args)
#define self_pause(args...) gtk_player_pause(args)
#define self_restart(args...) gtk_player_restart(args)
#define self_check_pid(args...) gtk_player_check_pid(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkPlayer * (* const self_new) (LumConfig * config, gboolean fullscreen_allowed) = gtk_player_new;
static void (* const self_framedrop) (GtkPlayer * self, gboolean drop) = gtk_player_framedrop;
static void (* const self_pause) (GtkPlayer * self) = gtk_player_pause;
static void (* const self_restart) (GtkPlayer * self) = gtk_player_restart;
static gint (* const self_check_pid) (gpointer data) = gtk_player_check_pid;

GType
gtk_player_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GtkPlayerClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gtk_player_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GtkPlayer),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gtk_player_init,
		};

		type = g_type_register_static (LUM_TYPE_PLAYER, "GtkPlayer", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GtkPlayer *)g_object_new(gtk_player_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GtkPlayer * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GtkPlayer *
GET_NEW_VARG (const char *first, ...)
{
	GtkPlayer *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GtkPlayer *)g_object_new_valist (gtk_player_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gtk:Player::finalize"
	GtkPlayer *self = GTK_PLAYER (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
gtk_player_class_init (GtkPlayerClass * c)
{
#define __GOB_FUNCTION__ "Gtk:Player::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;
	LumPlayerClass *lum_player_class = (LumPlayerClass *)c;

	parent_class = g_type_class_ref (LUM_TYPE_PLAYER);

	g_object_class->dispose = ___3_gtk_player_dispose;
	lum_player_class->play_pause = ___4_gtk_player_play_pause;
	lum_player_class->stop = ___5_gtk_player_stop;
	lum_player_class->set_position = ___6_gtk_player_set_position;
	lum_player_class->osd = ___7_gtk_player_osd;
	lum_player_class->open_file = ___8_gtk_player_open_file;
	lum_player_class->get_position_time = ___9_gtk_player_get_position_time;
	lum_player_class->is_running = ___a_gtk_player_is_running;
	lum_player_class->can_play = ___b_gtk_player_can_play;
	lum_player_class->set_contrast = ___c_gtk_player_set_contrast;
	lum_player_class->set_brightness = ___d_gtk_player_set_brightness;
	lum_player_class->set_hue = ___e_gtk_player_set_hue;
	lum_player_class->set_saturation = ___f_gtk_player_set_saturation;
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
gtk_player_init (GtkPlayer * self)
{
#define __GOB_FUNCTION__ "Gtk:Player::init"
	self->_priv = g_new0 (GtkPlayerPrivate, 1);
	self->_priv->socket = NULL;
	self->_priv->width = 0;
	self->_priv->height = 0;
	self->_priv->childpid = -1;
	self->_priv->timer = 0;
	self->_priv->pipe = NULL;
	self->_priv->child_in = -1;
	self->_priv->child_out = -1;
	self->_priv->child_err = -1;
 {

		selfp->socket = gtk_socket_new();
		gtk_widget_show(selfp->socket);
		gtk_box_pack_start(GTK_BOX(self), selfp->socket,
			TRUE, TRUE, 0);
	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__



GtkPlayer * 
gtk_player_new (LumConfig * config, gboolean fullscreen_allowed)
{
#define __GOB_FUNCTION__ "Gtk:Player::new"
	g_return_val_if_fail (config != NULL, (GtkPlayer * )NULL);
	g_return_val_if_fail (LUM_IS_CONFIG (config), (GtkPlayer * )NULL);
{
	
		Self *self = GET_NEW_VARG("GtkWidget::can-focus", TRUE,
			"GtkBox::homogeneous", FALSE,
			"GtkBox::spacing", 0,
			"LumPlayer::can_fullscreen", fullscreen_allowed,
			NULL, NULL);

		(LUM_PLAYER(self)->config = config);
/*		gtk_widget_set_events(GTK_WIDGET(ret),
				GDK_EXPOSURE_MASK|
				GDK_KEY_PRESS_MASK|
				GDK_KEY_RELEASE_MASK|
				GDK_BUTTON_PRESS_MASK|
				GDK_BUTTON_RELEASE_MASK|
				GDK_POINTER_MOTION_MASK|
				GDK_POINTER_MOTION_HINT_MASK);
*/
		return self;
	}}
#undef __GOB_FUNCTION__

static void 
___3_gtk_player_dispose (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Gtk:Player::dispose"
{
	
		Self *self = SELF(object);

		if(selfp->child_in != -1) 
			lum_player_stop(LUM_PLAYER(self));
			
		PARENT_HANDLER(object);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___4_gtk_player_play_pause (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->play_pause) \
		(* LUM_PLAYER_CLASS(parent_class)->play_pause)(___player); }
{
#define __GOB_FUNCTION__ "Gtk:Player::play_pause"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		Self *self = SELF(player);
		switch(player->status) {
			case PLAYER_STOPPED:
				self_restart(self);
				player->status = PLAYER_PLAYING;
				break;
			case PLAYER_PLAYING:
				self_pause(GTK_PLAYER(self));
				player->status = PLAYER_PAUSED;
				break;
			case PLAYER_PAUSED:
				self_pause(GTK_PLAYER(self));
				player->status = PLAYER_PLAYING;
				break;
			default:
				break;
		}
		lum_player_status_changed(LUM_PLAYER(self));
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___5_gtk_player_stop (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->stop) \
		(* LUM_PLAYER_CLASS(parent_class)->stop)(___player); }
{
#define __GOB_FUNCTION__ "Gtk:Player::stop"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		if(player->status != PLAYER_STOPPED) {
			Self *self = SELF(player);
			if(selfp->childpid != -1) {
				dprintf(selfp->child_in, "quit\n");
				fsync(selfp->child_in);
				if(close(selfp->child_in) == -1)
					printf("Error closing pipe: %s\n", strerror(errno));
				selfp->child_in = -1;
				selfp->child_out = -1;
				player->status = PLAYER_STOPPED;
				if(kill(selfp->childpid, SIGHUP) == -1)
					printf("Error killing mplayer: %s\n",
							strerror(errno));
			}
		lum_player_status_changed(LUM_PLAYER(self));
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___6_gtk_player_set_position (LumPlayer * player, gdouble position)
#define PARENT_HANDLER(___player,___position) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_position) \
		(* LUM_PLAYER_CLASS(parent_class)->set_position)(___player,___position); }
{
#define __GOB_FUNCTION__ "Gtk:Player::set_position"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		Self *self = SELF(player);
		if(selfp->child_in != -1) {
			dprintf(selfp->child_in, "seek %d 1\n", (gint) position);
			fsync(selfp->child_in);
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___7_gtk_player_osd (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->osd) \
		(* LUM_PLAYER_CLASS(parent_class)->osd)(___player); }
{
#define __GOB_FUNCTION__ "Gtk:Player::osd"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		int osd;
		Self *self = SELF(player);
		osd = player->config->osd;
		if(selfp->child_in != -1) {
			dprintf(selfp->child_in, "osd %d\n", osd);
			fsync(selfp->child_in);
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___8_gtk_player_open_file (LumPlayer * player, gchar * uri, LumPlayerInfo * info)
#define PARENT_HANDLER(___player,___uri,___info) \
	((LUM_PLAYER_CLASS(parent_class)->open_file)? \
		(* LUM_PLAYER_CLASS(parent_class)->open_file)(___player,___uri,___info): \
		((gboolean )FALSE))
{
#define __GOB_FUNCTION__ "Gtk:Player::open_file"
	g_return_val_if_fail (uri != NULL, (gboolean )FALSE);
	g_return_val_if_fail (info != NULL, (gboolean )FALSE);
	g_return_val_if_fail (LUM_IS_PLAYER_INFO (info), (gboolean )FALSE);
{
	
		lum_player_set_uri(player, uri);
		lum_player_set_info(player, info);
		return TRUE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___9_gtk_player_get_position_time (LumPlayer * player, gdouble * position, gint * time)
#define PARENT_HANDLER(___player,___position,___time) \
	((LUM_PLAYER_CLASS(parent_class)->get_position_time)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_position_time)(___player,___position,___time): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Gtk:Player::get_position_time"
	g_return_val_if_fail (player != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYER (player), (gboolean )0);
{
	
		Self *self = SELF(player);
		int pos;
		if(selfp->child_in != -1) {
			dprintf(selfp->child_in, "get_percent_pos\n");
			fsync(selfp->child_in);
			while(1) {
				gchar string[256];
				gchar *before;
				int i;
				i = read(selfp->child_out, string, sizeof string);
				if(i == -1){
					printf("Error reading position : %s", strerror(errno));
					return FALSE;
				} else if(i == 0)
					break;
				before = strtok(string, "=");

				if(!g_ascii_strcasecmp("ANS_PERCENT_POSITION", before))
					sscanf(strtok(NULL,"="), "%d", &pos);
			}
		}
		*position = pos;
		*time = 0;
		return TRUE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___a_gtk_player_is_running (LumPlayer * self)
#define PARENT_HANDLER(___self) \
	((LUM_PLAYER_CLASS(parent_class)->is_running)? \
		(* LUM_PLAYER_CLASS(parent_class)->is_running)(___self): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Gtk:Player::is_running"
{
	
		if ((self->status == PLAYER_PLAYING ||
			self->status == PLAYER_PAUSED) &&
				GTK_PLAYER(self)->_priv->childpid > 0)
			return TRUE;
		return FALSE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___b_gtk_player_can_play (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->can_play)? \
		(* LUM_PLAYER_CLASS(parent_class)->can_play)(___player): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Gtk:Player::can_play"
{
	
		Self *self = SELF(player);
		return GTK_WIDGET_REALIZED(selfp->socket);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___c_gtk_player_set_contrast (LumPlayer * player, gdouble contrast)
#define PARENT_HANDLER(___player,___contrast) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_contrast) \
		(* LUM_PLAYER_CLASS(parent_class)->set_contrast)(___player,___contrast); }
{
#define __GOB_FUNCTION__ "Gtk:Player::set_contrast"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		static gint pos = 0;
		Self *self = SELF(player);
		if(selfp->child_in != -1) {
			dprintf(selfp->child_in, "contrast %d\n",((gint)contrast) - pos);
			fsync(selfp->child_in);
			pos = contrast;
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___d_gtk_player_set_brightness (LumPlayer * player, gdouble brightness)
#define PARENT_HANDLER(___player,___brightness) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_brightness) \
		(* LUM_PLAYER_CLASS(parent_class)->set_brightness)(___player,___brightness); }
{
#define __GOB_FUNCTION__ "Gtk:Player::set_brightness"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		static int pos = 0;
		Self *self = SELF(player);
		if(selfp->child_in != -1) {
			dprintf(selfp->child_in, "brightness %d\n",
					((gint)brightness) - pos);
			fsync(selfp->child_in);
			pos = brightness;
		}
		
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___e_gtk_player_set_hue (LumPlayer * player, gdouble hue)
#define PARENT_HANDLER(___player,___hue) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_hue) \
		(* LUM_PLAYER_CLASS(parent_class)->set_hue)(___player,___hue); }
{
#define __GOB_FUNCTION__ "Gtk:Player::set_hue"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		static gint pos = 0;
		Self *self = SELF(player);
		if(selfp->child_in != -1) {
			dprintf(selfp->child_in, "hue %d\n", ((gint)hue) - pos);
			fsync(selfp->child_in);
			pos = hue;
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___f_gtk_player_set_saturation (LumPlayer * player, gdouble saturation)
#define PARENT_HANDLER(___player,___saturation) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_saturation) \
		(* LUM_PLAYER_CLASS(parent_class)->set_saturation)(___player,___saturation); }
{
#define __GOB_FUNCTION__ "Gtk:Player::set_saturation"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		static gint pos = 0;
		Self *self = SELF(player);
		if(selfp->child_in != -1) {
			dprintf(selfp->child_in, "saturation %d\n",
					((gint)saturation) - pos);
			fsync(selfp->child_in);
			pos = saturation;
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

void 
gtk_player_framedrop (GtkPlayer * self, gboolean drop)
{
#define __GOB_FUNCTION__ "Gtk:Player::framedrop"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_PLAYER (self));
{
	
		if(drop) {
			if(selfp->child_in != -1) {
				dprintf(selfp->child_in, "frame_drop 1\n");
				fsync(selfp->child_in);
			}
		} else {
			if(selfp->child_in != -1) {
				dprintf(selfp->child_in, "frame_drop 0\n");
				fsync(selfp->child_in);
			}
		}
	}}
#undef __GOB_FUNCTION__

static void 
gtk_player_pause (GtkPlayer * self)
{
#define __GOB_FUNCTION__ "Gtk:Player::pause"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_PLAYER (self));
{
	
		if(selfp->child_in != -1) {
			dprintf(selfp->child_in, "pause\n");
			fsync(selfp->child_in);
		}
	}}
#undef __GOB_FUNCTION__

static void 
gtk_player_restart (GtkPlayer * self)
{
#define __GOB_FUNCTION__ "Gtk:Player::restart"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_PLAYER (self));
{
	
		gchar *cmd[100];
		guint32 xid = 0;
		LumPlayerInfo *info = lum_player_get_info(LUM_PLAYER(self));

		if (lum_player_is_running(LUM_PLAYER(self))) {
			lum_player_stop(LUM_PLAYER(self));
		}

		if (LUM_PLAYER(self)->status != PLAYER_PLAYING &&
				LUM_PLAYER(self)->status != PLAYER_PAUSED) {

			if (selfp->timer) {
				gtk_timeout_remove(selfp->timer);
				selfp->timer = FALSE;
			}
				
			if(info)
				if(info->has_video){
					if(!GTK_IS_SOCKET(selfp->socket)){
						selfp->socket = gtk_socket_new();
						gtk_widget_show(selfp->socket);
						gtk_box_pack_start(GTK_BOX(self), selfp->socket,
							TRUE, TRUE, 0);
					}
					gtk_widget_set_size_request(selfp->socket,
							info->video_width,
							info->video_height);
				}

			xid = gtk_socket_get_id(GTK_SOCKET(selfp->socket));
			
			{/*config*/
				gchar *drop;
				switch(LUM_PLAYER(self)->config->framedrop) {
					case 0:
						drop = g_strdup(" ");
						break;
					case 1:
						drop = g_strdup("-framedrop");
						break;
					case 2:
						drop = g_strdup("-hardframedrop");
						break;
					default:
						drop = g_strdup(" ");
				}

				if(selfp->childpid != -1)
					kill(selfp->childpid, SIGHUP);

				cmd[0] = "/usr/bin/mplayer";
				cmd[1] = "-vo";
				cmd[2] = LUM_PLAYER(self)->config->xv ? "xv" : "x11 -zoom ";
				cmd[3] = "-slave";
				cmd[4] = "-nolirc";
				cmd[5] = "-nofs";
				cmd[6] = "-nojoystick";
				cmd[7] = "-nomouseinput";
				cmd[8] = "-quiet";
				cmd[9] = "-xy";
				cmd[10] = g_strdup_printf("%d", info->has_video ?
							info->video_width : 30);
				cmd[11] = "-wid";
				cmd[12] = g_strdup_printf("%d", xid);
				cmd[13] = "-ao";
				cmd[14] = LUM_PLAYER(self)->config->esd_out ? "esd" : "oss";
				cmd[15] = "-alang";
				cmd[16] = LUM_PLAYER(self)->config->alang;
				cmd[17] = "-slang";
				cmd[18] = LUM_PLAYER(self)->config->slang;
				cmd[19] = "-dvd-device";
				cmd[20] = LUM_PLAYER(self)->config->dvd_dev;
				cmd[21] = LUM_PLAYER(self)->config->db ? "-double" : " ";
				cmd[22] = LUM_PLAYER(self)->config->index ? "-idx" : " ";
				cmd[23] = LUM_PLAYER(self)->config->rtc ? " " : "-nortc";
				cmd[24] = LUM_PLAYER(self)->config->softsleep ? "-softsleep" : " ";
				cmd[25] = LUM_PLAYER(self)->config->stop_ssaver ? "-stop_xscreensaver" : " ";
				cmd[26] = LUM_PLAYER(self)->config->dr ? "-dr" : " ";
				cmd[27] = "-ffactor";
				cmd[28] = g_strdup_printf("%f", 
							LUM_PLAYER(self)->config->font_factor);
				cmd[29] = g_strdup(drop);
				cmd[30] = "-cache";
				cmd[31] = g_strdup_printf("%d",
							LUM_PLAYER(self)->config->cache);
				cmd[32] = "-autoq";
				cmd[33] = g_strdup_printf("%d", LUM_PLAYER(self)->config->autoq);
				cmd[34] = "-autosync";
				cmd[35] = g_strdup_printf("%d", LUM_PLAYER(self)->config->autosync);
				cmd[36] = "-osdlevel";
				cmd[37] = g_strdup_printf("%d", LUM_PLAYER(self)->config->osd);
				cmd[38] = "-nokeepaspect";

				char *uri, *tmp;
				tmp = gnome_vfs_uri_to_string(
						gnome_vfs_uri_new(
							lum_player_get_uri(LUM_PLAYER(self))),
						GNOME_VFS_URI_HIDE_NONE);
				if(!g_ascii_strncasecmp("file:", tmp, 5)){
					uri = g_strdup_printf("%s%s", "file:/",(tmp+5));
					g_free(tmp);
				} else
					uri = tmp;
				cmd[39] = uri;
				cmd[40] = NULL;
				{
					GError *error;
					g_spawn_async_with_pipes(NULL,
						cmd, NULL, 0, NULL, NULL,
						&selfp->childpid,
						&selfp->child_in,
						&selfp->child_out,
						NULL,//&selfp->child_err,
						&error);
				/* process error */	
				}
				selfp->timer = gtk_timeout_add(1000,
						self_check_pid, self);
				int i;
				for(i = 0; i < 40; ++i)
					printf("%s ", cmd[i]);
				printf("\n");
/*				while(TRUE){
					static int i = 0;
					g_free(cmd[i]);
					if(i++ == 36){
						i = 0;
						break;
					}
				}
				g_free(drop);
*/			}
		}
	}}
#undef __GOB_FUNCTION__

static gint 
gtk_player_check_pid (gpointer data)
{
#define __GOB_FUNCTION__ "Gtk:Player::check_pid"
{
	
		Self *self = SELF(data);

		if(kill(selfp->childpid, 0) == -1){
			if(errno == ESRCH){
				lum_player_stop(LUM_PLAYER(self));
				LUM_PLAYER(self)->status = PLAYER_STOPPED;
				return FALSE;
			}	
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___gtk_player_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	((void (*)(void))self_framedrop)();
	((void (*)(void))self_pause)();
	((void (*)(void))self_restart)();
	((void (*)(void))self_check_pid)();
	___gtk_player_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

