/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                          gtk-xine.gob  -  Xine Gtk Widget
                             -------------------
    begin                : dim jan  26 02:08:47 BST 2002
    copyright            : (C) 2002, 2004 by Stphane Konstantaropoulos
    email                : ssk01@aber.ac.uk | stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * Code taken / inspired from gtk-xine.c from the totem project by Hadess
 * 
 * Thanks go to him for his nice implementation
 * 	Copyright (C) 2001-2002 the xine project
 * 	Heavily modified by Bastien Nocera <hadess@hadess.net>
 * 
 * My modifications:
 * Use gob for easier syntax, remove signals and a few properties,
 * remove fullscreen code. Implement fully LumPlayer.
 *
 * #TODO apply LumConfig fully. Remove unnecessary things.
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gtk-xine.h"

#include "gtk-xine-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
static const GEnumValue _gtk_xine_error_values[] = {
	{ GTX_STARTUP, "GTX_STARTUP", "startup" },
	{ GTX_NO_INPUT_PLUGIN, "GTX_NO_INPUT_PLUGIN", "no-input-plugin" },
	{ GTX_NO_DEMUXER_PLUGIN, "GTX_NO_DEMUXER_PLUGIN", "no-demuxer-plugin" },
	{ GTX_DEMUXER_FAILED, "GTX_DEMUXER_FAILED", "demuxer-failed" },
	{ GTX_NO_CODEC, "GTX_NO_CODEC", "no-codec" },
	{ GTX_MALFORMED_MRL, "GTX_MALFORMED_MRL", "malformed-mrl" },
	{ 0, NULL, NULL }
};

GType
gtk_xine_error_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("GtkXineError", _gtk_xine_error_values);
	return type;
}

static const GEnumValue _gtk_xine_speed_values[] = {
	{ SPEED_PAUSE, "SPEED_PAUSE", "pause" },
	{ SPEED_NORMAL, "SPEED_NORMAL", "normal" },
	{ 0, NULL, NULL }
};

GType
gtk_xine_speed_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("GtkXineSpeed", _gtk_xine_speed_values);
	return type;
}

/* self casting macros */
#define SELF(x) GTK_XINE(x)
#define SELF_CONST(x) GTK_XINE_CONST(x)
#define IS_SELF(x) GTK_IS_XINE(x)
#define TYPE_SELF GTK_TYPE_XINE
#define SELF_CLASS(x) GTK_XINE_CLASS(x)

#define SELF_GET_CLASS(x) GTK_XINE_GET_CLASS(x)

/* self typedefs */
typedef GtkXine Self;
typedef GtkXineClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void gtk_xine_class_init (GtkXineClass * class) G_GNUC_UNUSED;
static void gtk_xine_init (GtkXine * self) G_GNUC_UNUSED;
static void ___4_gtk_xine_finalize (GObject * object) G_GNUC_UNUSED;
static void ___5_gtk_xine_play_pause (LumPlayer * player) G_GNUC_UNUSED;
static void ___6_gtk_xine_stop (LumPlayer * player) G_GNUC_UNUSED;
static gint ___7_gtk_xine_get_stream_length (LumPlayer * player) G_GNUC_UNUSED;
static void ___8_gtk_xine_set_position (LumPlayer * player, gdouble position) G_GNUC_UNUSED;
static void ___9_gtk_xine_set_contrast (LumPlayer * player, gdouble value) G_GNUC_UNUSED;
static void ___a_gtk_xine_set_brightness (LumPlayer * player, gdouble value) G_GNUC_UNUSED;
static void ___b_gtk_xine_set_hue (LumPlayer * player, gdouble value) G_GNUC_UNUSED;
static void ___c_gtk_xine_set_saturation (LumPlayer * player, gdouble value) G_GNUC_UNUSED;
static void ___d_gtk_xine_set_eq (LumPlayer * player, gint hz, gdouble value) G_GNUC_UNUSED;
static void ___e_gtk_xine_set_volume (LumPlayer * player, gdouble volume) G_GNUC_UNUSED;
static gdouble ___f_gtk_xine_get_volume (LumPlayer * player) G_GNUC_UNUSED;
static void ___10_gtk_xine_set_mute (LumPlayer * player) G_GNUC_UNUSED;
static gboolean ___11_gtk_xine_get_position_time (LumPlayer * player, gdouble * position, gint * time) G_GNUC_UNUSED;
static gboolean ___12_gtk_xine_is_seekable (LumPlayer * player) G_GNUC_UNUSED;
static gboolean ___13_gtk_xine_is_running (LumPlayer * player) G_GNUC_UNUSED;
static gboolean ___14_gtk_xine_can_play (LumPlayer * player) G_GNUC_UNUSED;
static gboolean gtk_xine_play (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_pause (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_dest_size_cb (void * data, int video_width, int video_height, double video_pixel_aspect, int * dest_width, int * dest_height, double * dest_pixel_aspect) G_GNUC_UNUSED;
static void gtk_xine_frame_output_cb (void * gtx_gen, int video_width, int video_height, double video_pixel_aspect, int * dest_x, int * dest_y, int * dest_width, int * dest_height, double * dest_pixel_aspect, int * win_x, int * win_y) G_GNUC_UNUSED;
static gboolean gtk_xine_idle_resize (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_load_video_out_driver (GtkXine * self) G_GNUC_UNUSED;
static gboolean gtk_xine_video_window_translate_point (GtkXine * self, int gui_x, int gui_y, int * video_x, int * video_y) G_GNUC_UNUSED;
static gboolean gtk_xine_generate_mouse_event (GtkXine * self, GdkEvent * event, gboolean is_motion) G_GNUC_UNUSED;
static gboolean gtk_xine_xine_configure_cb (GtkWidget * widget, GdkEventConfigure * event, Self * self) G_GNUC_UNUSED;
static void gtk_xine_event (gpointer user_data, const xine_event_t * event) G_GNUC_UNUSED;
static void gtk_xine_xine_error (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_stream_clean (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_set_vis (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_set_vis_embed (GtkXine * self) G_GNUC_UNUSED;
static gboolean gtk_xine_idle (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_xine_realize_cb (GtkWidget * widget, Self * self) G_GNUC_UNUSED;
static void gtk_xine_xine_unrealize_cb (GtkWidget * widget, Self * self) G_GNUC_UNUSED;
static gboolean gtk_xine_xine_timeout_cb (GtkXine * self) G_GNUC_UNUSED;
static gboolean gtk_xine_xine_expose_cb (GtkWidget * widget, GdkEventExpose * event, Self * self) G_GNUC_UNUSED;
static gboolean gtk_xine_xine_motion_notify_cb (GtkWidget * widget, GdkEventMotion * event, Self * self) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_SHOW_VFX,
	PROP_SHOW_VFX_EMBED
};

/* pointer to the class of our parent */
static LumPlayerClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new(args...) gtk_xine_new(args)
#define self_set_reparent(args...) gtk_xine_set_reparent(args)
#define self_get_info(args...) gtk_xine_get_info(args)
#define self_get_cdda_list(args...) gtk_xine_get_cdda_list(args)
#define self_get_dvd_list(args...) gtk_xine_get_dvd_list(args)
#define self_play(args...) gtk_xine_play(args)
#define self_pause(args...) gtk_xine_pause(args)
#define self_dest_size_cb(args...) gtk_xine_dest_size_cb(args)
#define self_frame_output_cb(args...) gtk_xine_frame_output_cb(args)
#define self_idle_resize(args...) gtk_xine_idle_resize(args)
#define self_load_video_out_driver(args...) gtk_xine_load_video_out_driver(args)
#define self_load_audio_out_driver(args...) gtk_xine_load_audio_out_driver(args)
#define self_video_window_translate_point(args...) gtk_xine_video_window_translate_point(args)
#define self_generate_mouse_event(args...) gtk_xine_generate_mouse_event(args)
#define self_xine_configure_cb(args...) gtk_xine_xine_configure_cb(args)
#define self_event(args...) gtk_xine_event(args)
#define self_xine_error(args...) gtk_xine_xine_error(args)
#define self_stream_clean(args...) gtk_xine_stream_clean(args)
#define self_set_vis(args...) gtk_xine_set_vis(args)
#define self_set_vis_embed(args...) gtk_xine_set_vis_embed(args)
#define self_idle(args...) gtk_xine_idle(args)
#define self_xine_realize_cb(args...) gtk_xine_xine_realize_cb(args)
#define self_xine_unrealize_cb(args...) gtk_xine_xine_unrealize_cb(args)
#define self_xine_timeout_cb(args...) gtk_xine_xine_timeout_cb(args)
#define self_xine_expose_cb(args...) gtk_xine_xine_expose_cb(args)
#define self_xine_motion_notify_cb(args...) gtk_xine_xine_motion_notify_cb(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkXine * (* const self_new) (LumConfig * config) = gtk_xine_new;
static void (* const self_set_reparent) (GtkXine * self, GdkWindow * parent) = gtk_xine_set_reparent;
static GtkXineInfo * (* const self_get_info) (const gchar * uri) = gtk_xine_get_info;
static char ** (* const self_get_cdda_list) (int * num) = gtk_xine_get_cdda_list;
static char ** (* const self_get_dvd_list) (int * num) = gtk_xine_get_dvd_list;
static gboolean (* const self_play) (GtkXine * self) = gtk_xine_play;
static void (* const self_pause) (GtkXine * self) = gtk_xine_pause;
static void (* const self_dest_size_cb) (void * data, int video_width, int video_height, double video_pixel_aspect, int * dest_width, int * dest_height, double * dest_pixel_aspect) = gtk_xine_dest_size_cb;
static void (* const self_frame_output_cb) (void * gtx_gen, int video_width, int video_height, double video_pixel_aspect, int * dest_x, int * dest_y, int * dest_width, int * dest_height, double * dest_pixel_aspect, int * win_x, int * win_y) = gtk_xine_frame_output_cb;
static gboolean (* const self_idle_resize) (GtkXine * self) = gtk_xine_idle_resize;
static void (* const self_load_video_out_driver) (GtkXine * self) = gtk_xine_load_video_out_driver;
static void (* const self_load_audio_out_driver) (GtkXine * self) = gtk_xine_load_audio_out_driver;
static gboolean (* const self_video_window_translate_point) (GtkXine * self, int gui_x, int gui_y, int * video_x, int * video_y) = gtk_xine_video_window_translate_point;
static gboolean (* const self_generate_mouse_event) (GtkXine * self, GdkEvent * event, gboolean is_motion) = gtk_xine_generate_mouse_event;
static gboolean (* const self_xine_configure_cb) (GtkWidget * widget, GdkEventConfigure * event, Self * self) = gtk_xine_xine_configure_cb;
static void (* const self_event) (gpointer user_data, const xine_event_t * event) = gtk_xine_event;
static void (* const self_xine_error) (GtkXine * self) = gtk_xine_xine_error;
static void (* const self_stream_clean) (GtkXine * self) = gtk_xine_stream_clean;
static void (* const self_set_vis) (GtkXine * self) = gtk_xine_set_vis;
static void (* const self_set_vis_embed) (GtkXine * self) = gtk_xine_set_vis_embed;
static gboolean (* const self_idle) (GtkXine * self) = gtk_xine_idle;
static void (* const self_xine_realize_cb) (GtkWidget * widget, Self * self) = gtk_xine_xine_realize_cb;
static void (* const self_xine_unrealize_cb) (GtkWidget * widget, Self * self) = gtk_xine_xine_unrealize_cb;
static gboolean (* const self_xine_timeout_cb) (GtkXine * self) = gtk_xine_xine_timeout_cb;
static gboolean (* const self_xine_expose_cb) (GtkWidget * widget, GdkEventExpose * event, Self * self) = gtk_xine_xine_expose_cb;
static gboolean (* const self_xine_motion_notify_cb) (GtkWidget * widget, GdkEventMotion * event, Self * self) = gtk_xine_xine_motion_notify_cb;

GType
gtk_xine_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GtkXineClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gtk_xine_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GtkXine),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gtk_xine_init,
		};

		type = g_type_register_static (LUM_TYPE_PLAYER, "GtkXine", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GtkXine *)g_object_new(gtk_xine_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GtkXine * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GtkXine *
GET_NEW_VARG (const char *first, ...)
{
	GtkXine *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GtkXine *)g_object_new_valist (gtk_xine_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::dispose"
	GtkXine *self = GTK_XINE (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
	if(self->_priv->queue) { ((*(void (*)(void *))g_async_queue_unref)) (self->_priv->queue); self->_priv->queue = NULL; }
	if(self->_priv->video_widget) { ((*(void (*)(void *))g_object_unref)) (self->_priv->video_widget); self->_priv->video_widget = NULL; }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::finalize"
	GtkXine *self = GTK_XINE (obj_self);
	gpointer priv = self->_priv;
	___4_gtk_xine_finalize(obj_self);
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
gtk_xine_class_init (GtkXineClass * class)
{
#define __GOB_FUNCTION__ "Gtk:Xine::class_init"
	GObjectClass *g_object_class = (GObjectClass*) class;
	LumPlayerClass *lum_player_class = (LumPlayerClass *)class;
	class->xine = xine_new();
	class->info_stream = NULL;
	class->info_vo = NULL;
	class->info_ao = NULL;

	parent_class = g_type_class_ref (LUM_TYPE_PLAYER);

	g_object_class->finalize = ___finalize;
	lum_player_class->play_pause = ___5_gtk_xine_play_pause;
	lum_player_class->stop = ___6_gtk_xine_stop;
	lum_player_class->get_stream_length = ___7_gtk_xine_get_stream_length;
	lum_player_class->set_position = ___8_gtk_xine_set_position;
	lum_player_class->set_contrast = ___9_gtk_xine_set_contrast;
	lum_player_class->set_brightness = ___a_gtk_xine_set_brightness;
	lum_player_class->set_hue = ___b_gtk_xine_set_hue;
	lum_player_class->set_saturation = ___c_gtk_xine_set_saturation;
	lum_player_class->set_eq = ___d_gtk_xine_set_eq;
	lum_player_class->set_volume = ___e_gtk_xine_set_volume;
	lum_player_class->get_volume = ___f_gtk_xine_get_volume;
	lum_player_class->set_mute = ___10_gtk_xine_set_mute;
	lum_player_class->get_position_time = ___11_gtk_xine_get_position_time;
	lum_player_class->is_seekable = ___12_gtk_xine_is_seekable;
	lum_player_class->is_running = ___13_gtk_xine_is_running;
	lum_player_class->can_play = ___14_gtk_xine_can_play;
	g_object_class->dispose = ___dispose;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("show_vfx" /* name */,
		 _("Show video effect") /* nick */,
		 _("If no video, show animation") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SHOW_VFX,
		param_spec);
	param_spec = g_param_spec_boolean
		("show_vfx_embed" /* name */,
		 _("Show embedded video effect") /* nick */,
		 _("embed visualization") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SHOW_VFX_EMBED,
		param_spec);
    }
 {

		char *xine_config;
		if (!g_thread_supported ())
			g_thread_init (NULL);
		gdk_threads_init ();

		xine_config = g_build_filename (g_get_home_dir(), LUM_DIR,
				"xine-config", NULL);
		if(g_file_test(xine_config, G_FILE_TEST_EXISTS)){
			xine_config_load (class->xine, xine_config);
			xine_init(class->xine);
		} else {
			xine_init(class->xine);
			xine_config_save(class->xine, xine_config);
		}
#ifdef DEBUG
		xine_engine_set_param(class->xine, 1, 1);
#else
		xine_engine_set_param(class->xine, 1, 0);
#endif
		g_free(xine_config);
		class->info_vo = xine_open_video_driver (class->xine,
				"none", XINE_VISUAL_TYPE_NONE, NULL);
		class->info_ao = xine_open_audio_driver(class->xine,
				"none", NULL);
		class->info_stream = xine_stream_new (class->xine,
					class->info_ao, class->info_vo);
	
 }
	return;
	class = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
gtk_xine_init (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::init"
	self->_priv = g_new0 (GtkXinePrivate, 1);
	self->_priv->stream = NULL;
	self->_priv->vo_driver = NULL;
	self->_priv->ao_driver = NULL;
	self->_priv->ev_queue = NULL;
	self->_priv->queue = g_async_queue_new();
	self->_priv->video_widget = 
			gtk_xine_widget_new(self);
			g_object_ref(selfp->video_widget);
	self->_priv->display = NULL;
	self->_priv->cursor_visible = TRUE;
	self->_priv->timeout = FALSE;
	self->_priv->buffering = 100;
	self->_priv->buffering_desc = NULL;
	self->_priv->vis = NULL;
	self->_priv->parent = NULL;
	self->_priv->prev_parent = NULL;
	self->_priv->prev_video = FALSE;
 {

		g_signal_connect_after(G_OBJECT(selfp->video_widget), "realize",
				G_CALLBACK(self_xine_realize_cb), self);
		g_signal_connect_after(G_OBJECT(selfp->video_widget), "unrealize",
				G_CALLBACK(self_xine_unrealize_cb), self);
		g_signal_connect_after(G_OBJECT(selfp->video_widget), "expose-event",
				G_CALLBACK(self_xine_expose_cb), self);
		g_signal_connect_after(G_OBJECT(selfp->video_widget), "motion-notify-event",
				G_CALLBACK(self_xine_motion_notify_cb), self);

		gtk_box_pack_start(GTK_BOX(self),
				GTK_WIDGET(selfp->video_widget),
				TRUE, TRUE, 0);
	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL,
	GParamSpec *pspec)
#define __GOB_FUNCTION__ "Gtk:Xine::set_property"
{
	GtkXine *self;

	self = GTK_XINE (object);

	switch (property_id) {
	case PROP_SHOW_VFX:
		{
 selfp->show_vfx = g_value_get_boolean(VAL);
			if(selfp->show_vfx){
				selfp->show_vfx_embed = FALSE;
				self_set_vis_embed(self);
			}
			self_set_vis(self); 
		}
		break;
	case PROP_SHOW_VFX_EMBED:
		{
 selfp->show_vfx_embed = g_value_get_boolean(VAL);
			if(selfp->show_vfx_embed){
			    selfp->show_vfx = FALSE;
				self_set_vis(self);
			}
			self_set_vis_embed(self); 
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
	return;
	self = NULL;
	VAL = NULL;
	pspec = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL,
	GParamSpec *pspec)
#define __GOB_FUNCTION__ "Gtk:Xine::get_property"
{
	GtkXine *self;

	self = GTK_XINE (object);

	switch (property_id) {
	case PROP_SHOW_VFX:
		{
 g_value_set_boolean(VAL, selfp->show_vfx); 
		}
		break;
	case PROP_SHOW_VFX_EMBED:
		{
 g_value_set_boolean(VAL, selfp->show_vfx_embed); 
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
	return;
	self = NULL;
	VAL = NULL;
	pspec = NULL;
}
#undef __GOB_FUNCTION__



GtkXine * 
gtk_xine_new (LumConfig * config)
{
#define __GOB_FUNCTION__ "Gtk:Xine::new"
	g_return_val_if_fail (!(config) || LUM_IS_CONFIG (config), (GtkXine * )NULL);
	g_return_val_if_fail (config != NULL, (GtkXine * )NULL);
{
	
		xine_cfg_entry_t entry;
		Self *self = GET_NEW_VARG("GtkWidget::can-focus", TRUE,
				"GtkBox::homogeneous", FALSE,
				"GtkBox::spacing", 0,
			    	NULL, NULL);

		if (!XInitThreads ()) {
			printf ("lumiere gtkxine: XInitThreads failed - "
				"looks like you don't have a thread-safe xlib.\n");
			return NULL;
		}

		LUM_PLAYER(self)->config = g_object_ref(config);
		memset (&entry, 0, sizeof (&entry));
		if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_device", &entry)){
			xine_config_register_string(SELF_GET_CLASS(self)->xine,
					"input.dvd_device",
					config->dvd_dev, "", NULL, 10,
					NULL, NULL);
			xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_device", &entry);
		}
		entry.str_value = g_strdup(config->dvd_dev);
		xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);

		memset (&entry, 0, sizeof (&entry));
		if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_language", &entry)){
			xine_config_register_string(SELF_GET_CLASS(self)->xine,
					"input.dvd_language",
					config->alang, "", NULL, 10,
					NULL, NULL);
			xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_language", &entry);
		}
		entry.str_value = g_strdup(config->alang);
		xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		/* TODO in LumConfig
		memset (&entry, 0, sizeof (&entry));
		if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.cdda_device", &entry)){
			xine_config_register_string(SELF_GET_CLASS(self)->xine,
					"input.cdda_device",
					config->cdda_dev, "", NULL, 10,
					NULL, NULL);
			xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.cdda_dev", &entry);
		}
		entry.str_value = g_strdup(config->cdda_dev);
		xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		*/
		const char *demux_strategies[] = {"default", "reverse", "content",
			"extension", NULL};

		/* default demux strategy */
		xine_config_register_enum (SELF_GET_CLASS(self)->xine,
				"misc.demux_strategy", 0,
				(char **) demux_strategies,
				 "media format detection strategy",
				 NULL, 10, NULL, NULL);
		xine_config_lookup_entry (SELF_GET_CLASS(self)->xine,
				"misc.demux_strategy", &entry);
		entry.num_value = 0;
		xine_config_update_entry (SELF_GET_CLASS(self)->xine, &entry);

		/* Proxy configuration */

		if (LUM_PLAYER(self)->config->use_proxy == FALSE){
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host",
						&entry)){
				xine_config_register_string(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host", &entry);
			}
			entry.str_value = "";
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		} else {
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host",
						&entry)){
				xine_config_register_string(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host", &entry);
			}

			entry.str_value = g_strdup(LUM_PLAYER(self)->config->proxy_host);
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_port",
						&entry)){
				xine_config_register_num(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_port",
						8080, "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_port", &entry);
			}
			entry.num_value = LUM_PLAYER(self)->config->proxy_port;
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		}
		if (LUM_PLAYER(self)->config->proxy_auth == FALSE){
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(
					SELF_GET_CLASS(self)->xine,
					"input.http_proxy_user",
					&entry)){
				xine_config_register_string(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_user",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_user", &entry);
			}
			entry.str_value = "";
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(
					SELF_GET_CLASS(self)->xine,
					"input.http_proxy_password",
					&entry)){
				xine_config_register_string(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_password",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_password", &entry);
			}
			entry.str_value = "";
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		} else {
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(
					SELF_GET_CLASS(self)->xine,
					"input.http_proxy_user",
					&entry)){
				xine_config_register_string(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_user",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_user", &entry);
			}
			entry.str_value = g_strdup(LUM_PLAYER(self)->config->proxy_user);
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(
					SELF_GET_CLASS(self)->xine,
					"input.http_proxy_password",
					&entry)){
				xine_config_register_string(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_password",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_password", &entry);
			}
			entry.str_value = g_strdup(LUM_PLAYER(self)->config->proxy_password);
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		}

		self_load_video_out_driver(self);
		selfp->ao_driver = xine_open_audio_driver(SELF_GET_CLASS(self)->xine,
				"none", NULL);

		selfp->stream = xine_stream_new (SELF_GET_CLASS(self)->xine,
				selfp->ao_driver, selfp->vo_driver);
		selfp->ev_queue = xine_event_new_queue(selfp->stream);

		return self;
	}}
#undef __GOB_FUNCTION__

static void 
___4_gtk_xine_finalize (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::finalize"
	g_return_if_fail (object != NULL);
	g_return_if_fail (G_IS_OBJECT (object));
{
	
#ifdef DEBUG
		printf(__FILE__ ": finalize\n");
#endif
		Self *self = SELF(object);
		self_stream_clean(self);		
		PARENT_HANDLER(object);
#ifdef DEBUG
		printf(__FILE__ ": finalized\n");
#endif
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___5_gtk_xine_play_pause (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->play_pause) \
		(* LUM_PLAYER_CLASS(parent_class)->play_pause)(___player); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::play_pause"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		Self *self = SELF(player);
		switch(player->status) {
			case PLAYER_STOPPED:
				self_play(self);
 				self_set_vis(self);
//				self_set_vis_embed(self);
				player->status = PLAYER_PLAYING;
				break;
			case PLAYER_PLAYING:
				self_pause(self);
				player->status = PLAYER_PAUSED;
				break;
			case PLAYER_PAUSED:
				self_pause(self);
				player->status = PLAYER_PLAYING;
				break;
			default:
				break;
		}
		lum_player_status_changed(LUM_PLAYER(self));
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___6_gtk_xine_stop (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->stop) \
		(* LUM_PLAYER_CLASS(parent_class)->stop)(___player); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::stop"
{
	
#ifdef DEBUG
		printf(__FILE__ ": stop\n");
#endif
		Self *self = SELF(player);
		g_return_if_fail (SELF_GET_CLASS(self)->xine != NULL);
		
		if(player->status == PLAYER_STOPPED)
			return;

		if(selfp->stream){
			self_stream_clean(self);
		}

		PARENT_HANDLER(player);
#ifdef DEBUG
		printf(__FILE__ ": stopped\n");
#endif
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gint 
___7_gtk_xine_get_stream_length (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->get_stream_length)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_stream_length)(___player): \
		((gint )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_stream_length"
	g_return_val_if_fail (player != NULL, (gint )0);
	g_return_val_if_fail (LUM_IS_PLAYER (player), (gint )0);
{
	
		Self *self = SELF(player);
		int length_time = 0;
		int pos_stream, pos_time;

		if (lum_player_get_uri(player) == NULL)
			return 0;
		if(!selfp->stream)
			return 0;

		xine_get_pos_length (selfp->stream, &pos_stream,
				&pos_time, &length_time);

		return length_time;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___8_gtk_xine_set_position (LumPlayer * player, gdouble position)
#define PARENT_HANDLER(___player,___position) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_position) \
		(* LUM_PLAYER_CLASS(parent_class)->set_position)(___player,___position); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_position"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		gint length, absolute_position;
		Self *self = SELF(player);
		length = lum_player_get_stream_length(player);
		absolute_position = ((gdouble) length / 100.0) * position;
		if(!selfp->stream)
			return;
	
		xine_play(selfp->stream, 0, absolute_position);

		player->position = position;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___9_gtk_xine_set_contrast (LumPlayer * player, gdouble value)
#define PARENT_HANDLER(___player,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_contrast) \
		(* LUM_PLAYER_CLASS(parent_class)->set_contrast)(___player,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_contrast"
	g_return_if_fail (player != NULL);
{
	
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			xine_set_param(selfp->stream,XINE_PARAM_VO_CONTRAST,
					(gint) (value* 65535.0 / 100.0));
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___a_gtk_xine_set_brightness (LumPlayer * player, gdouble value)
#define PARENT_HANDLER(___player,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_brightness) \
		(* LUM_PLAYER_CLASS(parent_class)->set_brightness)(___player,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_brightness"
	g_return_if_fail (player != NULL);
{
	
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			xine_set_param(selfp->stream,XINE_PARAM_VO_BRIGHTNESS,
					(gint) (value* 65535.0 / 100.0));
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___b_gtk_xine_set_hue (LumPlayer * player, gdouble value)
#define PARENT_HANDLER(___player,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_hue) \
		(* LUM_PLAYER_CLASS(parent_class)->set_hue)(___player,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_hue"
	g_return_if_fail (player != NULL);
{
	
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			xine_set_param(selfp->stream,XINE_PARAM_VO_HUE,
					(gint) (value* 65535.0 / 100.0));
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___c_gtk_xine_set_saturation (LumPlayer * player, gdouble value)
#define PARENT_HANDLER(___player,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_saturation) \
		(* LUM_PLAYER_CLASS(parent_class)->set_saturation)(___player,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_saturation"
	g_return_if_fail (player != NULL);
{
	
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			xine_set_param(selfp->stream,XINE_PARAM_VO_SATURATION,
					(gint) (value* 65535.0 / 100.0));
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___d_gtk_xine_set_eq (LumPlayer * player, gint hz, gdouble value)
#define PARENT_HANDLER(___player,___hz,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_eq) \
		(* LUM_PLAYER_CLASS(parent_class)->set_eq)(___player,___hz,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_eq"
	g_return_if_fail (player != NULL);
{
	
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			switch(hz){
				case 30:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_30HZ, (gint) value);
					break;
				case 60:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_60HZ, (gint) value);
					break;
				case 125:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_125HZ, (gint) value);
					break;
				case 250:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_250HZ, (gint) value);
					break;
				case 500:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_500HZ, (gint) value);
					break;
				case 1000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_1000HZ, (gint) value);
					break;
				case 2000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_2000HZ, (gint) value);
					break;
				case 4000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_4000HZ, (gint) value);
					break;
				case 8000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_8000HZ, (gint) value);
					break;
				case 16000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_16000HZ, (gint) value);
					break;
			}
		}
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___e_gtk_xine_set_volume (LumPlayer * player, gdouble volume)
#define PARENT_HANDLER(___player,___volume) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_volume) \
		(* LUM_PLAYER_CLASS(parent_class)->set_volume)(___player,___volume); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_volume"
	g_return_if_fail (player != NULL);
	g_return_if_fail (LUM_IS_PLAYER (player));
{
	
		Self *self = SELF(player);
		if(!selfp->stream)
			return;

		xine_set_param(selfp->stream, XINE_PARAM_AUDIO_AMP_LEVEL, (gint) volume);

		PARENT_HANDLER(player, volume);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gdouble 
___f_gtk_xine_get_volume (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->get_volume)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_volume)(___player): \
		((gdouble )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_volume"
	g_return_val_if_fail (player != NULL, (gdouble )0);
	g_return_val_if_fail (LUM_IS_PLAYER (player), (gdouble )0);
{
	
		Self *self = SELF(player);
		if(!selfp->stream)
			return 0;
		return (gdouble)
			xine_get_param(selfp->stream, XINE_PARAM_AUDIO_VOLUME);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___10_gtk_xine_set_mute (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_mute) \
		(* LUM_PLAYER_CLASS(parent_class)->set_mute)(___player); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_mute"
	g_return_if_fail (player != NULL);
{
	
		Self *self = SELF(player);
		if(selfp->stream != NULL)
			xine_set_param(selfp->stream, XINE_PARAM_AUDIO_MUTE, player->_priv->mute);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___11_gtk_xine_get_position_time (LumPlayer * player, gdouble * position, gint * time)
#define PARENT_HANDLER(___player,___position,___time) \
	((LUM_PLAYER_CLASS(parent_class)->get_position_time)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_position_time)(___player,___position,___time): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_position_time"
	g_return_val_if_fail (player != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYER (player), (gboolean )0);
{
	
		Self *self = SELF(player);
		int pos_stream = 0, i = 0;
		int pos_time, length_time;
		gboolean ret;

		if (lum_player_get_uri(player) == NULL)
			return FALSE;

		if (lum_player_is_running(player) == FALSE)
			return FALSE;

		if(!selfp->stream)
			return FALSE;

		ret = xine_get_pos_length (selfp->stream, &pos_stream,
				&pos_time, &length_time);

		while (ret == FALSE && i < 10){
			usleep (100000);
			ret = xine_get_pos_length (selfp->stream, &pos_stream,
				&pos_time, &length_time);
			i++;
		}

		if (ret == FALSE)
			return FALSE;

		*position = ((gdouble)(pos_stream * 100) / 65535.0);
		*time = pos_time;
		return TRUE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___12_gtk_xine_is_seekable (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->is_seekable)? \
		(* LUM_PLAYER_CLASS(parent_class)->is_seekable)(___player): \
		((gboolean )FALSE))
{
#define __GOB_FUNCTION__ "Gtk:Xine::is_seekable"
	g_return_val_if_fail (player != NULL, (gboolean )FALSE);
	g_return_val_if_fail (LUM_IS_PLAYER (player), (gboolean )FALSE);
{
	
		Self *self = SELF(player);
		if (lum_player_get_stream_length (player) == 0)
			return FALSE;
		if(!selfp->stream)
			return FALSE;
		if(selfp->buffering < 100)
			return FALSE;

		return xine_get_stream_info (selfp->stream,
				XINE_STREAM_INFO_SEEKABLE);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___13_gtk_xine_is_running (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->is_running)? \
		(* LUM_PLAYER_CLASS(parent_class)->is_running)(___player): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::is_running"
{
	
		Self *self = SELF(player);

		if (selfp->stream == NULL)
			return FALSE;

		return xine_get_status (selfp->stream) == XINE_STATUS_PLAY;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___14_gtk_xine_can_play (LumPlayer * player)
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->can_play)? \
		(* LUM_PLAYER_CLASS(parent_class)->can_play)(___player): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::can_play"
	g_return_val_if_fail (player != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYER (player), (gboolean )0);
{
	
		if(GTK_WIDGET_REALIZED(GTK_WIDGET(player)))
			return TRUE;
		else
			return FALSE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

void 
gtk_xine_set_reparent (GtkXine * self, GdkWindow * parent)
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_reparent"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_XINE (self));
	g_return_if_fail (parent != NULL);
	g_return_if_fail (GDK_IS_WINDOW (parent));
{
		selfp->parent = parent; }}
#undef __GOB_FUNCTION__

GtkXineInfo * 
gtk_xine_get_info (const gchar * uri)
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_info"
	g_return_val_if_fail (uri != NULL, (GtkXineInfo * )NULL);
{
	
		SelfClass *klass = NULL;
		GtkXineInfo *info;

		klass = GTK_XINE_CLASS(g_type_class_peek(gtk_xine_get_type()));
		if(klass == NULL)
			klass = GTK_XINE_CLASS(g_type_class_ref(gtk_xine_get_type()));
		if(klass == NULL)
			printf("bad luck: klass == NULL\n");

		if(!xine_open(klass->info_stream, uri))
			return NULL;

		info = gtk_xine_info_new(klass->info_stream, uri);
		xine_close(klass->info_stream);

		return info;
	}}
#undef __GOB_FUNCTION__

char ** 
gtk_xine_get_cdda_list (int * num)
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_cdda_list"
{
	
		SelfClass *klass = NULL;

		klass = GTK_XINE_CLASS(g_type_class_peek(gtk_xine_get_type()));
		if(klass == NULL)
			klass = GTK_XINE_CLASS(g_type_class_ref(gtk_xine_get_type()));
		if(klass == NULL)
			printf("bad luck: klass == NULL\n");

		return xine_get_autoplay_mrls
			(klass->xine, "CD", num);
	}}
#undef __GOB_FUNCTION__

char ** 
gtk_xine_get_dvd_list (int * num)
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_dvd_list"
{
	
		SelfClass *klass = NULL;

		klass = GTK_XINE_CLASS(g_type_class_peek(gtk_xine_get_type()));
		if(klass == NULL)
			klass = GTK_XINE_CLASS(g_type_class_ref(gtk_xine_get_type()));
		if(klass == NULL)
			printf("bad luck: klass == NULL\n");

		return xine_get_autoplay_mrls
			(klass->xine, "DVD", num);
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_play (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::play"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (GTK_IS_XINE (self), (gboolean )0);
{
	
#ifdef DEBUG
		printf(__FILE__ ": play\n");
#endif
		int error;
		LumPlayerInfo *info = lum_player_get_info(LUM_PLAYER(self));
		if(info == NULL)
			return FALSE;

		if((info->has_video || selfp->show_vfx 
				|| selfp->show_vfx_embed) &&
				(!selfp->prev_video || selfp->stream == NULL)){
			if(selfp->stream != NULL)
				self_stream_clean(self);
			XLockDisplay (selfp->display);
			self_load_video_out_driver(self);
			self_load_audio_out_driver(self);
			selfp->stream = xine_stream_new (SELF_GET_CLASS(self)->xine,
					selfp->ao_driver, selfp->vo_driver);
			selfp->ev_queue = xine_event_new_queue (selfp->stream);
			xine_event_create_listener_thread (selfp->ev_queue,
					self_event, (gpointer) self);
		 	XFlush(selfp->display);
			XUnlockDisplay (selfp->display);
			selfp->prev_video = TRUE;
		} else if(selfp->stream == NULL) {
			self_load_video_out_driver(self);
			self_load_audio_out_driver(self);
			selfp->stream = xine_stream_new (SELF_GET_CLASS(self)->xine,
						selfp->ao_driver, selfp->vo_driver);
			selfp->ev_queue = xine_event_new_queue (selfp->stream);
			xine_event_create_listener_thread (selfp->ev_queue,
					self_event, (gpointer) self);
			selfp->prev_video = FALSE;
		} else if(info->has_video || selfp->show_vfx 
				|| selfp->show_vfx_embed){
			selfp->prev_video = TRUE;
		} else {
			selfp->prev_video = FALSE;
		}

		if(selfp->show_vfx_embed){
			gdk_window_resize(GTK_WIDGET(selfp->video_widget)->window,
					76, 16);
		}

		selfp->timeout = gtk_timeout_add(
				4000, (GtkFunction) self_xine_timeout_cb, self);
		if(xine_get_status (selfp->stream) == XINE_STATUS_PLAY)
			xine_stop(selfp->stream);
		error = xine_open (selfp->stream,
				lum_player_get_uri(LUM_PLAYER(self)));
		if (error == 0) {
			lum_player_stop (LUM_PLAYER(self));
			printf("xine error\n");
			//self_xine_error (self);
			return FALSE;
		}

		if (xine_get_stream_info (selfp->stream,
				XINE_STREAM_INFO_VIDEO_HANDLED) == FALSE
				&& xine_get_stream_info (selfp->stream,
				XINE_STREAM_INFO_AUDIO_HANDLED) == FALSE) {
			char *name = g_strdup (xine_get_meta_info (selfp->stream,
					XINE_META_INFO_VIDEOCODEC));
			lum_player_stop (LUM_PLAYER(self));
			
			g_error("Xine error.\nReason: Video type '%s' is not handled.", name);
			g_free (name);
			return FALSE;
		}

		error = xine_play (selfp->stream, 0, 0);

		if (error == 0){
			lum_player_stop (LUM_PLAYER(self));
			//self_xine_error (self);
			return FALSE;
		}
	
#ifdef DEBUG
		printf(__FILE__ ": out play\n");
#endif
		return TRUE;
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_pause (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::pause"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_XINE (self));
{
	
		if (lum_player_is_running(LUM_PLAYER(self)) == FALSE)
			return;
		if(LUM_PLAYER(self)->status == PLAYER_PAUSED)
			xine_set_param(selfp->stream,
				XINE_PARAM_SPEED,
				XINE_SPEED_NORMAL);
		else if(LUM_PLAYER(self)->status == PLAYER_PLAYING)
			xine_set_param(selfp->stream,
				XINE_PARAM_SPEED,
				XINE_SPEED_PAUSE);
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_dest_size_cb (void * data, int video_width, int video_height, double video_pixel_aspect, int * dest_width, int * dest_height, double * dest_pixel_aspect)
{
#define __GOB_FUNCTION__ "Gtk:Xine::dest_size_cb"
{
	
		Self *self = SELF(data);

		if (self == NULL || selfp == NULL)
			return;

		if (video_pixel_aspect >= selfp->display_ratio)
			video_width  = video_width * video_pixel_aspect
					/ selfp->display_ratio + .5;
		else
			video_height = video_height * selfp->display_ratio
					/ video_pixel_aspect + .5;

		if(selfp->show_vfx_embed){
			*dest_width = 76;
			*dest_height = 16;
			*dest_pixel_aspect = ((double)video_width /
					(double)video_height) /
					((double) 76 / (double) 16);
		} else {
			*dest_width = GTK_WIDGET(selfp->video_widget)->allocation.width;
			*dest_height = GTK_WIDGET(selfp->video_widget)->allocation.height;
			*dest_pixel_aspect = selfp->display_ratio;
		}
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_frame_output_cb (void * gtx_gen, int video_width, int video_height, double video_pixel_aspect, int * dest_x, int * dest_y, int * dest_width, int * dest_height, double * dest_pixel_aspect, int * win_x, int * win_y)
{
#define __GOB_FUNCTION__ "Gtk:Xine::frame_output_cb"
{
	
		Self *self = SELF(gtx_gen);

		if (self == NULL || selfp == NULL)
			return;

		/* correct size with video_pixel_aspect */
		if (video_pixel_aspect >= selfp->display_ratio)
			video_width = video_width * video_pixel_aspect
					/ selfp->display_ratio + .5;
		else
			video_height = video_height * selfp->display_ratio
					/ video_pixel_aspect + .5;

		*dest_x = 0;
		*dest_y = 0;
		*win_x = selfp->xpos;
		*win_y = selfp->ypos;

		if(selfp->show_vfx_embed){
			*dest_width = 76;
			*dest_height = 16;
			*dest_pixel_aspect =
				((double)video_width / (double)video_height) /
				((double) 76 / (double) 16);
		} else {
			*dest_width = GTK_WIDGET(selfp->video_widget)->allocation.width;
			*dest_height = GTK_WIDGET(selfp->video_widget)->allocation.height;
			*dest_pixel_aspect = selfp->display_ratio;
		}

		/* Size changed */
		if (LUM_PLAYER(self)->_priv->info->video_width != video_width
				|| LUM_PLAYER(self)->_priv->info->video_height != video_height) {
			LUM_PLAYER(self)->_priv->info->video_width = video_width;
			LUM_PLAYER(self)->_priv->info->video_height = video_height;
			if(!selfp->show_vfx_embed)
				g_idle_add ((GSourceFunc) self_idle_resize, self);
		}
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_idle_resize (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::idle_resize"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (GTK_IS_XINE (self), (gboolean )0);
{
	
		GtkWidget *toplevel;
		int video_width  = LUM_PLAYER(self)->_priv->info->video_width;
		int video_height = LUM_PLAYER(self)->_priv->info->video_height;
		int win_w, win_h, new_h, new_w;

		gdk_threads_enter ();
		toplevel = gtk_widget_get_toplevel (GTK_WIDGET(self));
		gtk_window_set_resizable(GTK_WINDOW(toplevel), TRUE);
		gdk_drawable_get_size (GDK_DRAWABLE (toplevel->window),
			&win_w, &win_h);

		new_w = win_w - GTK_WIDGET(selfp->video_widget)->allocation.width + video_width;
		new_h = win_h
			- GTK_WIDGET(selfp->video_widget)->allocation.height
			+ video_height +
			(GTK_WIDGET(self)->allocation.height - GTK_WIDGET(selfp->video_widget)->allocation.height);

		gtk_widget_set_size_request(GTK_WIDGET(selfp->video_widget),
			       video_width, video_height);
		gtk_window_resize (GTK_WINDOW (toplevel), new_w, new_h);
		gdk_flush();
		gdk_threads_leave ();

		return FALSE;
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_load_video_out_driver (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::load_video_out_driver"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_XINE (self));
{
	
		double res_h, res_v;
		x11_visual_t vis;
		const char *video_driver_id = selfp->show_vfx_embed ||
			!LUM_PLAYER(self)->config->xv ? "Xshm" : "Xv";

		if(!GTK_WIDGET_REALIZED(GTK_WIDGET(selfp->video_widget))){
			selfp->vo_driver = xine_open_video_driver (
					GTK_XINE_GET_CLASS(self)->xine,
					"none", XINE_VISUAL_TYPE_NONE, NULL);
			return;
		}

		if(!selfp->show_vfx  && !selfp->show_vfx_embed &&
				!lum_player_get_info(LUM_PLAYER(self))->has_video){
			selfp->vo_driver = xine_open_video_driver (
					GTK_XINE_GET_CLASS(self)->xine,
					"none", XINE_VISUAL_TYPE_NONE, NULL);
			return;
		}
		printf(__FILE__ ": loading video driver\n");

		vis.display = selfp->display;
		vis.screen = selfp->screen;
		vis.d = GDK_WINDOW_XID(GTK_WIDGET(selfp->video_widget)->window);
		res_h =
		    (DisplayWidth (selfp->display, selfp->screen) * 1000 /
		     DisplayWidthMM (selfp->display, selfp->screen));
		res_v =
		    (DisplayHeight (selfp->display, selfp->screen) * 1000 /
		     DisplayHeightMM (selfp->display, selfp->screen));
		selfp->display_ratio = res_v / res_h;

		if (fabs (selfp->display_ratio - 1.0) < 0.01) {
			selfp->display_ratio = 1.0;
		}

		vis.dest_size_cb = self_dest_size_cb;
		vis.frame_output_cb = self_frame_output_cb;
		vis.user_data = self;

		selfp->vo_driver = xine_open_video_driver (
						GTK_XINE_GET_CLASS(self)->xine,
						video_driver_id,
						XINE_VISUAL_TYPE_X11,
						(void *) &vis);
		if (!selfp->vo_driver){
			selfp->vo_driver = xine_open_video_driver (
					GTK_XINE_GET_CLASS(self)->xine, "auto",
					XINE_VISUAL_TYPE_X11, (void *) &vis);
		}
	}}
#undef __GOB_FUNCTION__

void 
gtk_xine_load_audio_out_driver (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::load_audio_out_driver"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_XINE (self));
{
	
		if(LUM_IS_PLAYER(self) &&
				LUM_PLAYER(self)->config != NULL)
			selfp->ao_driver = xine_open_audio_driver (
					SELF_GET_CLASS(self)->xine,
					LUM_PLAYER(self)->config->esd_out ?
					"esd" : "alsa", NULL);
		if (selfp->ao_driver == NULL){
			selfp->ao_driver = xine_open_audio_driver (
						SELF_GET_CLASS(self)->xine,
						NULL, NULL);
		}
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_video_window_translate_point (GtkXine * self, int gui_x, int gui_y, int * video_x, int * video_y)
{
#define __GOB_FUNCTION__ "Gtk:Xine::video_window_translate_point"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (GTK_IS_XINE (self), (gboolean )0);
{
	
		x11_rectangle_t rect;

		rect.x = gui_x;
		rect.y = gui_y;
		rect.w = 0;
		rect.h = 0;

		if (xine_port_send_gui_data (selfp->vo_driver,
				XINE_GUI_SEND_TRANSLATE_GUI_TO_VIDEO,
				(void*)&rect) != -1) {
		/* the driver implements gui->video coordinate space translation
		 * so we use it */
			*video_x = rect.x;
			*video_y = rect.y;
			return TRUE;
		}

		return FALSE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_generate_mouse_event (GtkXine * self, GdkEvent * event, gboolean is_motion)
{
#define __GOB_FUNCTION__ "Gtk:Xine::generate_mouse_event"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (GTK_IS_XINE (self), (gboolean )0);
{
	
		GdkEventMotion *mevent = (GdkEventMotion *) event;
		GdkEventButton *bevent = (GdkEventButton *) event;
		int x, y;
		gboolean retval;

		if (is_motion == FALSE && bevent->button != 1)
			return FALSE;

		if (is_motion == TRUE)
			retval = self_video_window_translate_point (self,
					mevent->x, mevent->y, &x, &y);
		else
			retval = self_video_window_translate_point (self,
					bevent->x, bevent->y, &x, &y);
	
		if (retval == TRUE)	{
			xine_event_t event;
			xine_input_data_t input;

			if (is_motion == TRUE){
				event.type = XINE_EVENT_INPUT_MOUSE_MOVE;
				input.button = 0; /* Just motion. */
			} else {
				event.type = XINE_EVENT_INPUT_MOUSE_BUTTON;
				input.button = 1;
			}

			input.x = x;
			input.y = y;
			event.stream = selfp->stream;
			event.data = &input;
			event.data_length = sizeof(input);

			xine_event_send (selfp->stream,
					(xine_event_t *) (&event));

			return TRUE;
		}

		return FALSE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_xine_configure_cb (GtkWidget * widget, GdkEventConfigure * event, Self * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_configure_cb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (IS_SELF (self), (gboolean )0);
{
	
		selfp->xpos = event->x +
			GTK_WIDGET(selfp->video_widget)->allocation.x;
		selfp->ypos = event->y +
			GTK_WIDGET(selfp->video_widget)->allocation.x;

		return FALSE;
 	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_event (gpointer user_data, const xine_event_t * event)
{
#define __GOB_FUNCTION__ "Gtk:Xine::event"
{
	
		Self *self = SELF(user_data);

		switch (event->type) {
		case XINE_EVENT_UI_PLAYBACK_FINISHED:
			g_async_queue_push(selfp->queue,
					GINT_TO_POINTER(XINE_EVENT_UI_PLAYBACK_FINISHED));
			g_idle_add((GSourceFunc)self_idle, self);
#ifdef DEBUG
			printf(__FILE__ ": received finished event\n");
#endif
			break;
		case XINE_EVENT_PROGRESS:
			selfp->buffering = ((xine_progress_data_t*)event->data)->percent;
			selfp->buffering_desc = g_strdup(
				((xine_progress_data_t*)event->data)->description);
#ifdef DEBUG
			printf(__FILE__ "received progress event\n");
#endif
			g_async_queue_push(selfp->queue,
					GINT_TO_POINTER(XINE_EVENT_PROGRESS));
			g_idle_add((GSourceFunc)self_idle, self);
			break;
		case XINE_EVENT_UI_SET_TITLE:
			break;
		default:
			break;
		}
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_xine_error (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_error"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_XINE (self));
{
	
		int error;

		error = xine_get_error (selfp->stream);
		if (error == XINE_ERROR_NONE)
			return;

		switch (error)	{
			case XINE_ERROR_NO_INPUT_PLUGIN:
			break;
		case XINE_ERROR_NO_DEMUX_PLUGIN:
			break;
		case XINE_ERROR_DEMUX_FAILED:
			break;
		case XINE_ERROR_MALFORMED_MRL:
			break;
		default:
			break;
		}
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_stream_clean (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::stream_clean"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_XINE (self));
{
	
#ifdef DEBUG
		printf(__FILE__ ": stream clean\n");
#endif

		if(selfp->timeout){
			gtk_timeout_remove(selfp->timeout);
			selfp->timeout = FALSE;
		}
		if(selfp->stream){
			xine_close (selfp->stream);
			if(selfp->ev_queue){
				xine_event_dispose_queue (selfp->ev_queue);
				selfp->ev_queue = NULL;
			}
			xine_dispose (selfp->stream);
			selfp->stream = NULL;
		}
		if(selfp->vis){
			xine_post_dispose(SELF_GET_CLASS(self)->xine, selfp->vis);
			selfp->vis = NULL;
		}
		if(selfp->vo_driver){
			xine_close_video_driver(SELF_GET_CLASS(self)->xine, selfp->vo_driver);
			selfp->vo_driver = NULL;
		}
		if(selfp->ao_driver){
			xine_close_audio_driver(SELF_GET_CLASS(self)->xine, selfp->ao_driver);
			selfp->ao_driver = NULL;
		}
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_set_vis (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_vis"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_XINE (self));
{
	
		if(selfp->stream) {
			if(xine_get_status(selfp->stream) == XINE_STATUS_PLAY) {
				if(selfp->vis) {
					xine_post_out_t *pp;
					pp = xine_get_audio_source(selfp->stream);
					xine_post_wire_audio_port(pp, selfp->ao_driver);
					xine_post_dispose(SELF_GET_CLASS(self)->xine,
							selfp->vis);
					selfp->vis = NULL;
		    		}
	    			if(selfp->show_vfx) {
					xine_post_out_t *audio_source;
					const xine_post_in_t *input;
					if(!selfp->vis){
						if(LUM_PLAYER(self)->status == PLAYER_PLAYING ||
							LUM_PLAYER(self)->status == PLAYER_PAUSED){
							double pos;
							gint time;
							lum_player_get_position_time(
								LUM_PLAYER(self), &pos, &time);
							self_stream_clean(self);
							self_play(self);
							xine_play(selfp->stream, 0, time);	
						}
						selfp->vis = xine_post_init(
								SELF_GET_CLASS(self)->xine,
								"goom", 0, 
		   						&selfp->ao_driver, 
		   						&selfp->vo_driver);
					}
					audio_source = xine_get_audio_source(selfp->stream);
					input = xine_post_input(selfp->vis, g_strdup("audio in"));
					xine_post_wire(audio_source, input);
		    		}
		 	}
	   	}
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_set_vis_embed (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_vis_embed"
	g_return_if_fail (self != NULL);
	g_return_if_fail (GTK_IS_XINE (self));
{
	
		if(selfp->show_vfx_embed){
			selfp->prev_parent = gtk_widget_get_parent_window(
					GTK_WIDGET(selfp->video_widget));
			gdk_window_resize(GTK_WIDGET(selfp->video_widget)->window,
					76, 16);
			gdk_window_reparent(GTK_WIDGET(selfp->video_widget)->window,
					selfp->parent, 24, 43);
			if(selfp->stream) {
				xine_post_out_t *audio_source;
				const xine_post_in_t *input;
				if(!selfp->vis){
					if(LUM_PLAYER(self)->status == PLAYER_PLAYING ||
							LUM_PLAYER(self)->status == PLAYER_PAUSED){
						double pos;
						gint time;
						lum_player_get_position_time(
								LUM_PLAYER(self), &pos, &time);
						self_play(self);
						xine_play(selfp->stream, 0, time);
					}
					selfp->vis = xine_post_init(
								SELF_GET_CLASS(self)->xine,
								"fftscope", 0, 
		   						&selfp->ao_driver, 
		   						&selfp->vo_driver);
				}
				audio_source = xine_get_audio_source(selfp->stream);
				input = xine_post_input(selfp->vis, g_strdup("audio in"));
				xine_post_wire(audio_source, input);
			}
		} else {
			if(selfp->stream) {
				if(xine_get_status(selfp->stream) == XINE_STATUS_PLAY) {
					if(selfp->vis) {
						xine_post_out_t *pp;
						pp = xine_get_audio_source(selfp->stream);
						xine_post_wire_audio_port(pp, selfp->ao_driver);
						xine_post_dispose(SELF_GET_CLASS(self)->xine,
								selfp->vis);
						selfp->vis = NULL;
			    		}
				}
			}
			if(selfp->prev_parent){
				gdk_window_reparent(
						GTK_WIDGET(selfp->video_widget)->window,
						selfp->prev_parent, 24, 43);
				selfp->prev_parent = NULL;
			}
		}
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_idle (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::idle"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (GTK_IS_XINE (self), (gboolean )0);
{
	
		int event, queue_length;
		event = GPOINTER_TO_INT(g_async_queue_try_pop (selfp->queue));
		gdk_threads_enter();
		switch(event){
			case XINE_EVENT_UI_PLAYBACK_FINISHED:
				if(LUM_PLAYER(self)->repeat)
					lum_player_set_position(LUM_PLAYER(self), 0.0);
				lum_player_playbackfinished(LUM_PLAYER(self));
				break;
			case XINE_EVENT_PROGRESS:
				printf("buffering: %s, percent: %d\n",
						selfp->buffering_desc,
						selfp->buffering);
				break;
			default:
				break;
		}
		gdk_threads_leave();
		queue_length = g_async_queue_length(selfp->queue);

		return (queue_length > 0);
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_xine_realize_cb (GtkWidget * widget, Self * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_realize_cb"
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_WIDGET (widget));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		GtkXineWidget *xine_widget = GTK_XINE_WIDGET(widget);
	   	Pixmap        bm_no;
		unsigned long black_pixel;

		self_stream_clean(self);
		
		/* track configure events of toplevel window */
		g_signal_connect (gtk_widget_get_toplevel(widget),
	 			"configure-event",
	 			G_CALLBACK (self_xine_configure_cb), self);

		selfp->display = XOpenDisplay (gdk_display_get_name(
					gdk_display_get_default ()));
		XLockDisplay (selfp->display);
		selfp->screen = DefaultScreen(selfp->display);

		if (XShmQueryExtension (selfp->display) == True) {
			selfp->completion_event =
				XShmGetEventBase (selfp->display) + ShmCompletion;
		} else {
			selfp->completion_event = -1;
		}

		XFlush(selfp->display);
		XUnlockDisplay(selfp->display);
		
		/*
		 * * create mouse cursors
		 */
		bm_no = XCreateBitmapFromData(selfp->display,
                                xine_widget->video_window,
                                bm_no_data, 8, 8);
		selfp->no_cursor = XCreatePixmapCursor(
					selfp->display, bm_no, bm_no,
					(XColor *) &black_pixel,
					(XColor *) &black_pixel,
					0, 0);
		selfp->on_cursor = XCreateFontCursor(
					selfp->display, XC_left_ptr);
		selfp->cursor_visible = TRUE;

		return;
	}}
#undef __GOB_FUNCTION__

static void 
gtk_xine_xine_unrealize_cb (GtkWidget * widget, Self * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_unrealize_cb"
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_WIDGET (widget));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_stream_clean(self);
		
		GTK_WIDGET_UNSET_FLAGS (widget, GTK_MAPPED);
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_xine_timeout_cb (GtkXine * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_timeout_cb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (GTK_IS_XINE (self), (gboolean )0);
{
	
		if(LUM_PLAYER(self)->_priv->fullscreen
				&& selfp->cursor_visible) {
	 		XLockDisplay(selfp->display);
		 	XDefineCursor(selfp->display,
					selfp->video_widget->video_window,
		  			selfp->no_cursor);
		 	XFlush(selfp->display);
		 	selfp->cursor_visible = FALSE;
		 	XUnlockDisplay(selfp->display);
	 	}

		return TRUE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_xine_expose_cb (GtkWidget * widget, GdkEventExpose * event, Self * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_expose_cb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (IS_SELF (self), (gboolean )0);
{
	
		if(event->count != 0)
			return FALSE;

		XExposeEvent *expose;
		expose = g_new0 (XExposeEvent, 1);
		expose->count = event->count;

		if(selfp->vo_driver)
	    		xine_port_send_gui_data (selfp->vo_driver,
					XINE_GUI_SEND_EXPOSE_EVENT, &expose);
		g_free (expose);
		return FALSE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
gtk_xine_xine_motion_notify_cb (GtkWidget * widget, GdkEventMotion * event, Self * self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_motion_notify_cb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (IS_SELF (self), (gboolean )0);
{
	
		x11_rectangle_t   rect;
		xine_event_t      xevent;
		xine_input_data_t input;

		rect.x = event->x;
		rect.y = event->y;
		rect.w = 0;
		rect.h = 0;
		
		if(selfp->vo_driver){
			XLockDisplay (selfp->display);
			xine_port_send_gui_data (selfp->vo_driver,
					XINE_GUI_SEND_TRANSLATE_GUI_TO_VIDEO, 
					(void*)&rect);
		   	XFlush (selfp->display);
		   	XUnlockDisplay(selfp->display);
		}
		if(selfp->stream){
			xevent.type = XINE_EVENT_INPUT_MOUSE_MOVE;
			xevent.data = &input;
			xevent.data_length = sizeof(input);
			input.button = 0; /*  no buttons, just motion */
			input.x = rect.x;
			input.y = rect.y;
			xine_event_send(selfp->stream, &xevent);
		}
		if(LUM_PLAYER(self)->_priv->fullscreen &&
				!selfp->cursor_visible) {
			/* make mouse pointer visible */
			XLockDisplay (selfp->display);
			XDefineCursor (selfp->display,
					selfp->video_widget->video_window,
					selfp->on_cursor);
			XFlush (selfp->display);
			XUnlockDisplay(selfp->display);
			selfp->cursor_visible = TRUE;
		}
		return FALSE;
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___gtk_xine_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	((void (*)(void))self_set_reparent)();
	((void (*)(void))self_get_info)();
	((void (*)(void))self_get_cdda_list)();
	((void (*)(void))self_get_dvd_list)();
	((void (*)(void))self_play)();
	((void (*)(void))self_pause)();
	((void (*)(void))self_dest_size_cb)();
	((void (*)(void))self_frame_output_cb)();
	((void (*)(void))self_idle_resize)();
	((void (*)(void))self_load_video_out_driver)();
	((void (*)(void))self_load_audio_out_driver)();
	((void (*)(void))self_video_window_translate_point)();
	((void (*)(void))self_generate_mouse_event)();
	((void (*)(void))self_xine_configure_cb)();
	((void (*)(void))self_event)();
	((void (*)(void))self_xine_error)();
	((void (*)(void))self_stream_clean)();
	((void (*)(void))self_set_vis)();
	((void (*)(void))self_set_vis_embed)();
	((void (*)(void))self_idle)();
	((void (*)(void))self_xine_realize_cb)();
	((void (*)(void))self_xine_unrealize_cb)();
	((void (*)(void))self_xine_timeout_cb)();
	((void (*)(void))self_xine_expose_cb)();
	((void (*)(void))self_xine_motion_notify_cb)();
	___gtk_xine_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

