/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                          lum-config.gob  -  Lumiere Configuration Class
                             -------------------
    begin                : mer jan  15 02:08:47 BST 2002
    copyright            : (C) 2002, 2004 by Stphane Konstantaropoulos
    email                : ssk01@aber.ac.uk | stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * LumConfig:
 * Configuration class for lumiere
 * It holds all the data needed to run the player in a very customized way
 * This implementation uses GConf but you can use your own, there are
 * no public functions, so you just need the fields and the constructor.
 *
 * The GConf database is queried and notifiers are registered,
 * the configuration is changed when something is modifyed in the
 * GConf database.
 * Boring class, but I wanted to isolate the GConf processing out of 
 * the player classes.
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-config.h"

#include "lum-config-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
static const GEnumValue _lum_config_backend_values[] = {
	{ PLAYER_MPLAYER, "PLAYER_MPLAYER", "mplayer" },
	{ PLAYER_XINE, "PLAYER_XINE", "xine" },
	{ PLAYER_GL, "PLAYER_GL", "gl" },
	{ 0, NULL, NULL }
};

GType
lum_config_backend_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumConfigBackend", _lum_config_backend_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_CONFIG(x)
#define SELF_CONST(x) LUM_CONFIG_CONST(x)
#define IS_SELF(x) LUM_IS_CONFIG(x)
#define TYPE_SELF LUM_TYPE_CONFIG
#define SELF_CLASS(x) LUM_CONFIG_CLASS(x)

#define SELF_GET_CLASS(x) LUM_CONFIG_GET_CLASS(x)

/* self typedefs */
typedef LumConfig Self;
typedef LumConfigClass SelfClass;

/* here are local prototypes */
static void lum_config_class_init (LumConfigClass * c) G_GNUC_UNUSED;
static void lum_config_init (LumConfig * self) G_GNUC_UNUSED;
static void ___4_lum_config_dispose (GObject * object) G_GNUC_UNUSED;
static void lum_config_notify_cb (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__changed(object,func,data)	lum_config_connect__changed((object),(func),(data))
#define self_connect_after__changed(object,func,data)	lum_config_connect_after__changed((object),(func),(data))
#define self_connect_data__changed(object,func,data,destroy_data,flags)	lum_config_connect_data__changed((object),(func),(data),(destroy_data),(flags))

enum {
	CHANGED_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_changed(args...) lum_config_changed(args)
#define self_new() lum_config_new()
#define self_notify_cb(args...) lum_config_notify_cb(args)
#define self_set_server(args...) lum_config_set_server(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static void (* const self_changed) (LumConfig * self) = lum_config_changed;
static LumConfig * (* const self_new) (void) = lum_config_new;
static void (* const self_notify_cb) (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data) = lum_config_notify_cb;
static void (* const self_set_server) (LumConfig * self, gboolean mode) = lum_config_set_server;

GType
lum_config_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumConfigClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_config_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumConfig),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_config_init,
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumConfig", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumConfig *)g_object_new(lum_config_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumConfig * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumConfig *
GET_NEW_VARG (const char *first, ...)
{
	LumConfig *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumConfig *)g_object_new_valist (lum_config_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Config::dispose"
	LumConfig *self = LUM_CONFIG (obj_self);
	___4_lum_config_dispose(obj_self);
	if(self->_priv->client) { ((*(void (*)(void *))g_object_unref)) (self->_priv->client); self->_priv->client = NULL; }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Config::finalize"
	LumConfig *self = LUM_CONFIG (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	if(self->slang) { ((*(void (*)(void *))g_free)) (self->slang); self->slang = NULL; }
	if(self->alang) { ((*(void (*)(void *))g_free)) (self->alang); self->alang = NULL; }
	if(self->dvd_dev) { ((*(void (*)(void *))g_free)) (self->dvd_dev); self->dvd_dev = NULL; }
	if(self->proxy_host) { ((*(void (*)(void *))g_free)) (self->proxy_host); self->proxy_host = NULL; }
	if(self->proxy_user) { ((*(void (*)(void *))g_free)) (self->proxy_user); self->proxy_user = NULL; }
	if(self->proxy_password) { ((*(void (*)(void *))g_free)) (self->proxy_password); self->proxy_password = NULL; }
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_config_class_init (LumConfigClass * c)
{
#define __GOB_FUNCTION__ "Lum:Config::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[CHANGED_SIGNAL] =
		g_signal_new ("changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LumConfigClass, changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

	c->changed = NULL;
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_config_init (LumConfig * self)
{
#define __GOB_FUNCTION__ "Lum:Config::init"
	self->_priv = g_new0 (LumConfigPrivate, 1);
	self->backend = PLAYER_XINE;
	self->slang = g_strdup("en");
	self->alang = g_strdup("en");
	self->dvd_dev = g_strdup("/dev/dvd");
	self->db = FALSE;
	self->index = TRUE;
	self->rtc = FALSE;
	self->softsleep = FALSE;
	self->stop_ssaver = FALSE;
	self->dr = FALSE;
	self->esd_out = FALSE;
	self->xv = FALSE;
	self->font_factor = 0.75;
	self->framedrop = 0;
	self->cache = 4096;
	self->autoq = 0;
	self->autosync = 0;
	self->osd = 0;
	self->proxy_host = NULL;
	self->proxy_user = NULL;
	self->proxy_password = NULL;
	self->server_mode = FALSE;
	self->tray_icon = FALSE;
	self->_priv->client = NULL;
 {

		GError *error = NULL;
		
		if (!gconf_is_initialized ())
			gconf_init (0, NULL, NULL);

		selfp->client = gconf_client_get_default();
		gconf_client_add_dir(selfp->client,
				LUM_DIR,
				GCONF_CLIENT_PRELOAD_RECURSIVE,
				&error);
		if (error != NULL){
		 	printf(__FILE__ ": client add dir: %s\n", error->message);
			g_error_free (error);
	   	} 	
		gconf_client_add_dir(selfp->client,
				"/desktop/gnome/sound",
				GCONF_CLIENT_PRELOAD_ONELEVEL,
				NULL);
		gconf_client_add_dir(selfp->client,
				"/system/http_proxy",
				GCONF_CLIENT_PRELOAD_ONELEVEL,
				NULL);

		gchar *type;
		type = gconf_client_get_string(selfp->client, LUM_BACKEND, NULL);
		selfp->backend_id = gconf_client_notify_add (selfp->client,
							LUM_BACKEND, self_notify_cb, 
							self, NULL, NULL);

		if(!g_ascii_strcasecmp("glplay", type))
			self->backend = PLAYER_GL;
		else if(!g_ascii_strcasecmp("mplayer", type))
			self->backend = PLAYER_MPLAYER;
		else if(!g_ascii_strcasecmp("xine", type))
			self->backend = PLAYER_XINE;
		g_free(type);
			
		self->esd_out = gconf_client_get_bool(selfp->client,
				"/desktop/gnome/sound/enable_esd", NULL);
		self->xv = gconf_client_get_bool(selfp->client, LUM_XV, NULL);
		self->slang = gconf_client_get_string(selfp->client, LUM_SLANG, NULL);
		self->alang = gconf_client_get_string(selfp->client, LUM_ALANG, NULL);
		self->dvd_dev = gconf_client_get_string(selfp->client,
					LUM_DVDDEV, NULL);
		self->db = gconf_client_get_bool(selfp->client, LUM_DOUBLE, NULL);
		self->index = gconf_client_get_bool(selfp->client, LUM_INDEX, NULL);
		self->rtc = gconf_client_get_bool(selfp->client, LUM_RTC, NULL);
		self->softsleep = gconf_client_get_bool(selfp->client,
					LUM_SOFTSLEEP, NULL);
		self->stop_ssaver = gconf_client_get_bool(selfp->client,
					LUM_STOPSSAVER, NULL);
		self->dr = gconf_client_get_bool(selfp->client, LUM_DR, NULL);
		self->font_factor = gconf_client_get_float(selfp->client,
					LUM_FFACTOR, NULL);
		self->framedrop = gconf_client_get_int(selfp->client,
					LUM_FRAMEDROP, NULL);
		self->autosync = gconf_client_get_int(selfp->client,
					LUM_AUTOSYNC, NULL);
		self->osd = gconf_client_get_int(selfp->client, LUM_OSD, NULL);
		self->cache = gconf_client_get_int(selfp->client,
					LUM_CACHE, NULL);
		self->autoq = gconf_client_get_int(selfp->client,
					LUM_AUTOQ, NULL);
		self->server_mode = gconf_client_get_bool(selfp->client,
					LUM_SERVER, NULL);
		self->tray_icon = gconf_client_get_bool(selfp->client,
					LUM_TRAY, NULL);
		self->use_proxy = gconf_client_get_bool(selfp->client,
				"/system/http_proxy/use_http_proxy", NULL);
		selfp->use_proxy_id = gconf_client_notify_add (selfp->client,
				"/system/http_proxy/use_http_proxy",
			    self_notify_cb, self, NULL, NULL);
		self->proxy_host = gconf_client_get_string(selfp->client,
					"/system/http_proxy/host", NULL);
		selfp->proxy_host_id = gconf_client_notify_add (selfp->client,
					"/system/http_proxy/host",
				    self_notify_cb, self, NULL, NULL);
		self->proxy_port = gconf_client_get_int(selfp->client,
				"/system/http_proxy/port", NULL);
		selfp->proxy_port_id = gconf_client_notify_add (selfp->client,
					"/system/http_proxy/port",
				    self_notify_cb, self, NULL, NULL);
		self->proxy_auth = gconf_client_get_bool(selfp->client,
					"/system/http_proxy/use_authentication", NULL);
		selfp->proxy_auth_id = gconf_client_notify_add (selfp->client,
					"/system/http_proxy/use_authentication",
				    self_notify_cb, self, NULL, NULL);
		self->proxy_user = gconf_client_get_string (selfp->client,
				"/system/http_proxy/authentication_user",
				NULL);
		selfp->proxy_user_id = gconf_client_notify_add (selfp->client,
				"/system/http_proxy/authentication_user",
				    self_notify_cb, self, NULL, NULL);
		self->proxy_password = gconf_client_get_string (selfp->client,
				"/system/http_proxy/authentication_password",
				NULL);
		selfp->proxy_password_id = gconf_client_notify_add (selfp->client,
				"/system/http_proxy/authentication_password",
				    self_notify_cb, self, NULL, NULL);

		
		selfp->autoq_id = gconf_client_notify_add (selfp->client,
					 LUM_AUTOQ, self_notify_cb, self, NULL, NULL);
		selfp->esd_out_id =  gconf_client_notify_add (selfp->client,
					 "/desktop/gnome/sound/enable_esd", 
					 self_notify_cb, self, NULL, NULL);
		selfp->xv_id = gconf_client_notify_add (selfp->client, 
					LUM_XV, self_notify_cb, self, NULL, NULL);
		selfp->slang_id = gconf_client_notify_add (selfp->client,
					 LUM_SLANG, self_notify_cb, self, NULL, NULL);
		selfp->alang_id = gconf_client_notify_add(selfp->client,
					 LUM_ALANG, self_notify_cb, self, NULL, NULL);
		selfp->dvd_dev_id = gconf_client_notify_add (selfp->client,
					 LUM_DVDDEV, self_notify_cb, self, NULL, NULL);
		selfp->db_id = gconf_client_notify_add (selfp->client,
					 LUM_DOUBLE, self_notify_cb, self, NULL, NULL);
		selfp->index_id = gconf_client_notify_add (selfp->client,
					 LUM_INDEX, self_notify_cb, self, NULL, NULL);
		selfp->rtc_id = gconf_client_notify_add (selfp->client,
					 LUM_RTC, self_notify_cb, self, NULL, NULL);
		selfp->softsleep_id = gconf_client_notify_add (selfp->client,
					 LUM_SOFTSLEEP, self_notify_cb, self, NULL, NULL);
		selfp->stop_ssaver_id = gconf_client_notify_add (selfp->client,
					 LUM_STOPSSAVER, self_notify_cb, self, NULL, NULL);
		selfp->dr_id = gconf_client_notify_add (selfp->client,
					 LUM_DR, self_notify_cb, self, NULL, NULL);
		selfp->font_factor_id = gconf_client_notify_add (selfp->client,
					 LUM_FFACTOR, self_notify_cb, self, NULL, NULL);
		selfp->framedrop_id = gconf_client_notify_add (selfp->client,
					 LUM_FRAMEDROP, self_notify_cb,
					 self, NULL, NULL);
		selfp->cache_id = gconf_client_notify_add (selfp->client,
					 LUM_CACHE, self_notify_cb, self, NULL, NULL);
		selfp->autosync_id = gconf_client_notify_add (selfp->client,
					 LUM_AUTOSYNC, self_notify_cb,
					 self, NULL, NULL);
		selfp->osd_id = gconf_client_notify_add (selfp->client,
					 LUM_OSD, self_notify_cb, self, NULL, NULL);
		selfp->tray_icon_id = gconf_client_notify_add (selfp->client,
					 LUM_TRAY, self_notify_cb, self, NULL, NULL);
		selfp->server_mode_id = gconf_client_notify_add (selfp->client,
					 LUM_SERVER, self_notify_cb, self, NULL, &error);

		if (error != NULL){
		 	printf(__FILE__ ": client add dir: %s\n", error->message);
			g_error_free (error);
	   	} 	

	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


void 
lum_config_changed (LumConfig * self)
{
	GValue ___param_values[1];
	GValue ___return_val = {0};

	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_CONFIG (self));

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

LumConfig * 
lum_config_new (void)
{
#define __GOB_FUNCTION__ "Lum:Config::new"
{
	
		return GET_NEW;
	}}
#undef __GOB_FUNCTION__


static void 
___4_lum_config_dispose (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Config::dispose"
{
	
		Self *self = SELF(object);
#ifdef DEBUG
		printf(__FILE__ ": dispose\n");
#endif

		gconf_client_notify_remove (selfp->client,
					selfp->autoq_id);
		gconf_client_notify_remove (selfp->client,
					selfp->slang_id);
		gconf_client_notify_remove (selfp->client,
					selfp->alang_id);
		gconf_client_notify_remove (selfp->client,
					selfp->dvd_dev_id);
		gconf_client_notify_remove (selfp->client,
					selfp->db_id);
		gconf_client_notify_remove (selfp->client,
					selfp->index_id);
		gconf_client_notify_remove (selfp->client,
					selfp->osd_id);
		gconf_client_notify_remove (selfp->client,
					selfp->rtc_id);
		gconf_client_notify_remove (selfp->client,
					selfp->softsleep_id);
		gconf_client_notify_remove (selfp->client,
					selfp->stop_ssaver_id);
		gconf_client_notify_remove (selfp->client,
					selfp->dr_id);
		gconf_client_notify_remove (selfp->client,
					selfp->font_factor_id);
		gconf_client_notify_remove (selfp->client,
					selfp->framedrop_id);
		gconf_client_notify_remove (selfp->client,
					selfp->cache_id);
		gconf_client_notify_remove (selfp->client,
					selfp->autosync_id);
		gconf_client_notify_remove (selfp->client,
					selfp->backend_id);
		gconf_client_notify_remove (selfp->client,
					selfp->server_mode_id);
		gconf_client_notify_remove (selfp->client,
					selfp->tray_icon_id);
		PARENT_HANDLER(object);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
lum_config_notify_cb (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data)
{
#define __GOB_FUNCTION__ "Lum:Config::notify_cb"
	g_return_if_fail (user_data != NULL);
{
	
		Self *self = SELF(user_data);
#ifdef DEBUG
		printf(__FILE__ ": notify_cb\n");
#endif
		if(cnxn_id == selfp->autoq_id){
			self->autoq = gconf_value_get_int(entry->value);
			
		} else if(cnxn_id == selfp->esd_out_id){
			self->esd_out = gconf_value_get_bool(entry->value);
			
		} else if(cnxn_id == selfp->xv_id){
			self->xv = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->slang_id){
			g_free(self->slang);
			self->slang = NULL;
			self->slang = g_strdup(gconf_value_get_string (entry->value));
			
		} else if(cnxn_id == selfp->alang_id){
			g_free(self->alang);
			self->alang = NULL;
			self->alang = g_strdup(gconf_value_get_string (entry->value));
			
		} else if(cnxn_id == selfp->dvd_dev_id){
			g_free(self->dvd_dev);
			self->dvd_dev = NULL;
			self->dvd_dev = g_strdup(gconf_value_get_string (entry->value));
			
		} else if(cnxn_id == selfp->db_id){
			self->db = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->index_id){
			self->index = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->rtc_id){
			self->rtc = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->softsleep_id){
			self->softsleep = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->stop_ssaver_id){
			self->stop_ssaver = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->dr_id){
			self->dr = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->font_factor_id){
			self->font_factor = gconf_value_get_float(entry->value);
			
		} else if(cnxn_id == selfp->framedrop_id){
			self->framedrop = gconf_value_get_int (entry->value);
			
		} else if(cnxn_id == selfp->cache_id){
			self->cache = gconf_value_get_int(entry->value);
			
		} else if(cnxn_id == selfp->autosync_id){
			self->autosync = gconf_value_get_int(entry->value);
			
		} else if(cnxn_id == selfp->osd_id){
			self->osd = gconf_value_get_int(entry->value);
			
		} else if(cnxn_id == selfp->backend_id){
			gchar *type = gconf_client_get_string(selfp->client,
					LUM_BACKEND, NULL);
			if(!g_ascii_strcasecmp("glplay", type))
				self->backend = PLAYER_GL;
			else if(!g_ascii_strcasecmp("mplayer", type))
				self->backend = PLAYER_MPLAYER;
			else if(!g_ascii_strcasecmp("xine", type))
				self->backend = PLAYER_XINE;
			g_free(type);
		} else if(cnxn_id == selfp->server_mode_id){
			self->server_mode = gconf_value_get_bool(entry->value);
			lum_shell_set_server_mode(lum_shell, self->server_mode);

		} else if(cnxn_id == selfp->tray_icon_id){
			self->tray_icon = gconf_value_get_bool(entry->value);
			lum_shell_set_tray_icon(lum_shell, self->tray_icon);
		}

		self_changed(self);
	}}
#undef __GOB_FUNCTION__

void 
lum_config_set_server (LumConfig * self, gboolean mode)
{
#define __GOB_FUNCTION__ "Lum:Config::set_server"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_CONFIG (self));
{
	
		gconf_client_set_bool(selfp->client,
			       LUM_SERVER, mode, NULL);
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_config_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_changed)();
	((void (*)(void))self_new)();
	((void (*)(void))self_notify_cb)();
	((void (*)(void))self_set_server)();
	___lum_config_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

