/* Generated by GOB (v2.0.5)   (do not edit directly) */



/***************************************************************************
                          lum-config.gob  -  Lumiere Configuration Class
                             -------------------
    begin                : mer jan  15 02:08:47 BST 2002
    copyright            : (C) 2002, 2004 by Stphane Konstantaropoulos
    email                : ssk01@aber.ac.uk | stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * LumConfig:
 * Configuration class for lumiere
 * It holds all the data needed to run the player in a very customized way
 * This implementation uses GConf but you can use your own, there are
 * no public functions, so you just need the fields and the constructor.
 *
 * The GConf database is queried and notifiers are registered,
 * the configuration is changed when something is modifyed in the
 * GConf database.
 * Boring class, but I wanted to isolate the GConf processing out of 
 * the player classes.
 */

#include <glib.h>
#include <glib-object.h>
#ifndef __LUM_CONFIG_H__
#define __LUM_CONFIG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef enum {
	PLAYER_MPLAYER,
	PLAYER_XINE,
	PLAYER_GL
} LumConfigBackend;
#define LUM_TYPE_CONFIG_BACKEND lum_config_backend_get_type()
GType lum_config_backend_get_type (void);


/*
 * Type checking and casting macros
 */
#define LUM_TYPE_CONFIG	(lum_config_get_type())
#define LUM_CONFIG(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), lum_config_get_type(), LumConfig)
#define LUM_CONFIG_CONST(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), lum_config_get_type(), LumConfig const)
#define LUM_CONFIG_CLASS(klass)	G_TYPE_CHECK_CLASS_CAST((klass), lum_config_get_type(), LumConfigClass)
#define LUM_IS_CONFIG(obj)	G_TYPE_CHECK_INSTANCE_TYPE((obj), lum_config_get_type ())

#define LUM_CONFIG_GET_CLASS(obj)	G_TYPE_INSTANCE_GET_CLASS((obj), lum_config_get_type(), LumConfigClass)

/* Private structure type */
typedef struct _LumConfigPrivate LumConfigPrivate;

/*
 * Main object structure
 */
#ifndef __TYPEDEF_LUM_CONFIG__
#define __TYPEDEF_LUM_CONFIG__
typedef struct _LumConfig LumConfig;
#endif
struct _LumConfig {
	GObject __parent__;
	/*< public >*/
	LumConfigBackend backend;
	gchar * slang;
	gchar * alang;
	gchar * dvd_dev;
	gboolean db;
	gboolean index;
	gboolean rtc;
	gboolean softsleep;
	gboolean stop_ssaver;
	gboolean dr;
	gboolean esd_out;
	gboolean xv;
	gfloat font_factor;
	gint framedrop;
	gint cache;
	gint autoq;
	gint autosync;
	gint osd;
	gboolean use_proxy;
	gint proxy_port;
	gboolean proxy_auth;
	gchar * proxy_host;
	gchar * proxy_user;
	gchar * proxy_password;
	gboolean server_mode;
	gboolean tray_icon;
	/*< private >*/
	LumConfigPrivate *_priv;
};

/*
 * Class definition
 */
typedef struct _LumConfigClass LumConfigClass;
struct _LumConfigClass {
	GObjectClass __parent__;
	/*signal*/void (* changed) (LumConfig * self);
};


/*
 * Public methods
 */
GType	lum_config_get_type	(void);
void 	lum_config_changed	(LumConfig * self);
LumConfig * 	lum_config_new	(void);
void 	lum_config_set_server	(LumConfig * self,
					gboolean mode);

/*
 * Signal connection wrapper macros
 */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define lum_config_connect__changed(object,func,data)	g_signal_connect(LUM_CONFIG(({LumConfig *___object = (object); ___object; })),"changed",(GCallback)({void (* ___changed) (LumConfig * self, gpointer ___data ) = (func); ___changed; }), (data))
#define lum_config_connect_after__changed(object,func,data)	g_signal_connect_after(LUM_CONFIG(({LumConfig *___object = (object); ___object; })),"changed",(GCallback)({void (* ___changed) (LumConfig * self, gpointer ___data ) = (func); ___changed; }), (data))
#define lum_config_connect_data__changed(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_CONFIG(({LumConfig *___object = (object); ___object; })),"changed",(GCallback)({void (* ___changed) (LumConfig * self, gpointer ___data ) = (func); ___changed; }), (data), (destroy_data), (GConnectFlags)(flags))
#else /* __GNUC__ && !__STRICT_ANSI__ */
#define lum_config_connect__changed(object,func,data)	g_signal_connect(LUM_CONFIG(object),"changed",(GCallback)(func),(data))
#define lum_config_connect_after__changed(object,func,data)	g_signal_connect_after(LUM_CONFIG(object),"changed",(GCallback)(func),(data))
#define lum_config_connect_data__changed(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_CONFIG(object),"changed",(GCallback)(func),(data),(destroy_data),(GConnectFlags)(flags))
#endif /* __GNUC__ && !__STRICT_ANSI__ */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
