/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                          lum-parser.gob  -  Lumiere Media Parser 
                             -------------------
    begin                : lun jan 6 02:08:47 BST 2002
    copyright            : (C) 2002 by Stphane Konstantaropoulos
    email                : ssk01@aber.ac.uk | stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * Parse midentify output:
 * midentify is a wrapper script around mplayer that prints the info
 * about the media to stdout, grab it, parse it and set various fields.
 * More could be retreived here.
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-parser.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

/* self casting macros */
#define SELF(x) LUM_PARSER(x)
#define SELF_CONST(x) LUM_PARSER_CONST(x)
#define IS_SELF(x) LUM_IS_PARSER(x)
#define TYPE_SELF LUM_TYPE_PARSER
#define SELF_CLASS(x) LUM_PARSER_CLASS(x)

#define SELF_GET_CLASS(x) LUM_PARSER_GET_CLASS(x)

/* self typedefs */
typedef LumParser Self;
typedef LumParserClass SelfClass;

/* here are local prototypes */
static void lum_parser_init (LumParser * o) G_GNUC_UNUSED;
static void lum_parser_class_init (LumParserClass * c) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new(args...) lum_parser_new(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static LumParser * (* const self_new) (gchar * file) = lum_parser_new;

GType
lum_parser_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumParserClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_parser_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumParser),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_parser_init,
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumParser", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumParser *)g_object_new(lum_parser_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumParser * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumParser *
GET_NEW_VARG (const char *first, ...)
{
	LumParser *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumParser *)g_object_new_valist (lum_parser_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Parser::finalize"
	LumParser *self = LUM_PARSER (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	if(self->filename) { ((*(void (*)(void *))g_free)) (self->filename); self->filename = NULL; }
	if(self->video_format) { ((*(void (*)(void *))g_free)) (self->video_format); self->video_format = NULL; }
	if(self->audio_codec) { ((*(void (*)(void *))g_free)) (self->audio_codec); self->audio_codec = NULL; }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_parser_init (LumParser * o)
{
#define __GOB_FUNCTION__ "Lum:Parser::init"
	o->filename = NULL;
	o->video_format = NULL;
	o->video_width = -1;
	o->video_height = -1;
	o->video_fps = -1.0;
	o->audio_codec = NULL;
	o->audio_bitrate = -1;
	o->audio_rate = -1;
	o->audio_nch = -1;
	o->length = -1;
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_parser_class_init (LumParserClass * c)
{
#define __GOB_FUNCTION__ "Lum:Parser::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__



LumParser * 
lum_parser_new (gchar * file)
{
#define __GOB_FUNCTION__ "Lum:Parser::new"
	g_return_val_if_fail (file != NULL, (LumParser * )NULL);
{
	
		LumParser *parser = GET_NEW;
		gchar *cmd;
		gchar tmp[64];
		FILE *tmpfile = NULL;
		gint tmpfd = -1;

		strcpy(tmp, "/tmp/lumiere-XXXXXX");
		if((tmpfd = mkstemp(tmp)) < 0){
			printf("Error creating temporary file : %s", strerror(errno));
			return NULL;
		}


		cmd = g_strdup_printf(
			LIBEXECDIR"/midentify '%s' > %s\n", file, tmp);
		if(system(cmd) == -1) {
			printf("Error opening midentify : %s", strerror(errno));
			return NULL;
		}
	
		if((tmpfile = fdopen(tmpfd, "r")) == NULL) {
			printf("Error opening %s : %s\n", tmp, strerror(errno));
			return NULL;
		}

		while(1) {
			gchar string[256];
			gchar *before;

			if(fgets(string, sizeof string,tmpfile) == NULL)
				break;
			before = strtok(string, "=");

//			if(!g_ascii_strcasecmp("ID_LENGTH", before))
//				break;
			if(!g_ascii_strcasecmp("ID_FILENAME", before))
				parser->filename = g_strdup(strtok(NULL,"="));
			else if(!g_ascii_strcasecmp("ID_VIDEO_FORMAT", before))
				parser->video_format = g_strdup(strtok(NULL,"="));
			else if(!g_ascii_strcasecmp("ID_VIDEO_BITRATE", before))
				continue;
			else if(!g_ascii_strcasecmp("ID_VIDEO_WIDTH", before))
				sscanf(strtok(NULL,"="), "%d", &parser->video_width);
			else if(!g_ascii_strcasecmp("ID_VIDEO_HEIGHT", before))
				sscanf(strtok(NULL,"="), "%d", &parser->video_height);
			else if(!g_ascii_strcasecmp("ID_VIDEO_FPS", before))
				sscanf(strtok(NULL,"="), "%f", &parser->video_fps);
			else if(!g_ascii_strcasecmp("ID_AUDIO_CODEC", before))
				parser->audio_codec = g_strdup(strtok(NULL,"="));
			else if(!g_ascii_strcasecmp("ID_AUDIO_BITRATE", before))
				sscanf(strtok(NULL,"="), "%d", &parser->audio_bitrate);
			else if(!g_ascii_strcasecmp("ID_AUDIO_RATE", before))
				sscanf(strtok(NULL,"="), "%d", &parser->audio_rate);
			else if(!g_ascii_strcasecmp("ID_AUDIO_NCH", before))
				sscanf(strtok(NULL,"="), "%d", &parser->audio_nch);
			else if(!g_ascii_strcasecmp("ID_LENGTH", before))
				sscanf(strtok(NULL,"="), "%d", &parser->length);
		}
		if(fclose(tmpfile) == -1)
			printf("Error closing /tmp/lum : %s", strerror(errno));
		unlink(tmp);

		/* DEBUG */
#if 0
		printf("parser->filename = %s\n", parser->filename);
		printf("parser->video_format = %s\n", parser->video_format);
		printf("parser->video_width = %d\n", parser->video_width);
		printf("parser->video_height = %d\n", parser->video_height);
		printf("parser->video_fps = %d\n", parser->video_fps);
		printf("parser->audio_codec = %s\n", parser->audio_codec);
		printf("parser->audio_bitrate = %d\n", parser->audio_bitrate);
		printf("parser->audio_rate = %d\n", parser->audio_rate);
		printf("parser->audio_nch = %d\n", parser->audio_nch);
		printf("parser->length = %d\n", parser->length);
#endif
		g_free(cmd);
		return parser;   
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_parser_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	___lum_parser_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

