/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                    lum-player.gob  -  Lumiere Player Widget (abstract)
                             -------------------
    begin                : dim jan  26 02:08:47 BST 2002
    copyright            : (C) 2003, 2004 by Stphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-player.h"

#include "lum-player-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
static const GEnumValue _lum_player_status_values[] = {
	{ PLAYER_NONE, "PLAYER_NONE", "none" },
	{ PLAYER_PLAYING, "PLAYER_PLAYING", "playing" },
	{ PLAYER_PAUSED, "PLAYER_PAUSED", "paused" },
	{ PLAYER_STOPPED, "PLAYER_STOPPED", "stopped" },
	{ 0, NULL, NULL }
};

GType
lum_player_status_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumPlayerStatus", _lum_player_status_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_PLAYER(x)
#define SELF_CONST(x) LUM_PLAYER_CONST(x)
#define IS_SELF(x) LUM_IS_PLAYER(x)
#define TYPE_SELF LUM_TYPE_PLAYER
#define SELF_CLASS(x) LUM_PLAYER_CLASS(x)

#define SELF_GET_CLASS(x) LUM_PLAYER_GET_CLASS(x)

/* self typedefs */
typedef LumPlayer Self;
typedef LumPlayerClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lum_player_class_init (LumPlayerClass * c) G_GNUC_UNUSED;
static void lum_player_init (LumPlayer * self) G_GNUC_UNUSED;
static gboolean ___real_lum_player_open_file (LumPlayer * self, const char * uri, LumPlayerInfo * info);
static void ___real_lum_player_stop (LumPlayer * self);
static void ___real_lum_player_set_volume (LumPlayer * self, gdouble vol);
static void lum_player_set_mute (LumPlayer * self) G_GNUC_UNUSED;
static void ___real_lum_player_status_changed (LumPlayer * self);
static gboolean ___real_lum_player_update_timer (LumPlayer * self);
static gboolean ___real_lum_player_update_position (LumPlayer * self);
static void ___18_lum_player_finalize (GObject * object) G_GNUC_UNUSED;
static gboolean ___19_lum_player_motion_notify_event (GtkWidget * widget, GdkEventMotion * event) G_GNUC_UNUSED;
static gboolean ___1a_lum_player_button_press_event (GtkWidget * widget, GdkEventButton * event) G_GNUC_UNUSED;
static gboolean ___1b_lum_player_key_release_event (GtkWidget * widget, GdkEventKey * event) G_GNUC_UNUSED;
static gboolean lum_player_hide_bars (LumPlayer * self) G_GNUC_UNUSED;
static void lum_player_do_popup (LumPlayer const * self, GdkEventButton * event) G_GNUC_UNUSED;
static void lum_player_set_fullscreen (LumPlayer * self) G_GNUC_UNUSED;
static void lum_player_play_pause_cb (GtkToggleButton * button, Self * self) G_GNUC_UNUSED;
static void lum_player_fullscreen_cb (GtkButton * button, Self * self) G_GNUC_UNUSED;
static void lum_player_fullscreen_item_cb (GtkCheckMenuItem * item, Self * self) G_GNUC_UNUSED;
static void lum_player_properties_cb (GtkButton * button, Self * self) G_GNUC_UNUSED;
static void lum_player_video_activate_cb (GtkToggleButton * button, gpointer data) G_GNUC_UNUSED;
static void lum_player_eq_activate_cb (GtkToggleButton * button, gpointer data) G_GNUC_UNUSED;
static void lum_player_position_value_changed_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_volume_value_changed_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static gboolean lum_player_position_button_press_cb (GtkWidget * widget, GdkEventButton * event, gpointer data) G_GNUC_UNUSED;
static gboolean lum_player_position_button_release_cb (GtkWidget * widget, GdkEventButton * event, gpointer data) G_GNUC_UNUSED;
static void lum_player_cont_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_bright_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_hue_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_sat_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_mute_cb (GtkToggleButton * button, Self * self) G_GNUC_UNUSED;
static void lum_player_eq30_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq60_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq125_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq250_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq500_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq1000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq2000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq4000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq8000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq16000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__playbackfinished(object,func,data)	lum_player_connect__playbackfinished((object),(func),(data))
#define self_connect_after__playbackfinished(object,func,data)	lum_player_connect_after__playbackfinished((object),(func),(data))
#define self_connect_data__playbackfinished(object,func,data,destroy_data,flags)	lum_player_connect_data__playbackfinished((object),(func),(data),(destroy_data),(flags))
#define self_connect__volume_changed(object,func,data)	lum_player_connect__volume_changed((object),(func),(data))
#define self_connect_after__volume_changed(object,func,data)	lum_player_connect_after__volume_changed((object),(func),(data))
#define self_connect_data__volume_changed(object,func,data,destroy_data,flags)	lum_player_connect_data__volume_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__status_changed(object,func,data)	lum_player_connect__status_changed((object),(func),(data))
#define self_connect_after__status_changed(object,func,data)	lum_player_connect_after__status_changed((object),(func),(data))
#define self_connect_data__status_changed(object,func,data,destroy_data,flags)	lum_player_connect_data__status_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__update_timer(object,func,data)	lum_player_connect__update_timer((object),(func),(data))
#define self_connect_after__update_timer(object,func,data)	lum_player_connect_after__update_timer((object),(func),(data))
#define self_connect_data__update_timer(object,func,data,destroy_data,flags)	lum_player_connect_data__update_timer((object),(func),(data),(destroy_data),(flags))
#define self_connect__update_position(object,func,data)	lum_player_connect__update_position((object),(func),(data))
#define self_connect_after__update_position(object,func,data)	lum_player_connect_after__update_position((object),(func),(data))
#define self_connect_data__update_position(object,func,data,destroy_data,flags)	lum_player_connect_data__update_position((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (LumPlayer *, gdouble , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((LumPlayer *)data1,
		(gdouble ) g_value_get_double (param_values + 1),
		data2);
}


typedef gboolean  (*___Sig2) (LumPlayer *, gpointer);

static void
___marshal_Sig2 (GClosure *closure,
	GValue *return_value,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint,
	gpointer marshal_data)
{
	gboolean  v_return;
	register ___Sig2 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 1);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig2) (marshal_data != NULL ? marshal_data : cc->callback);

	v_return = callback ((LumPlayer *)data1,
		data2);

	g_value_set_boolean (return_value, v_return);
}


enum {
	PLAYBACKFINISHED_SIGNAL,
	VOLUME_CHANGED_SIGNAL,
	STATUS_CHANGED_SIGNAL,
	UPDATE_TIMER_SIGNAL,
	UPDATE_POSITION_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_CAN_FULLSCREEN,
	PROP_FULLSCREEN,
	PROP_CAN_HIDE_BARS,
	PROP_MUTE,
	PROP_REPEAT
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkVBoxClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_open_file(args...) lum_player_open_file(args)
#define self_play_pause(args...) lum_player_play_pause(args)
#define self_stop(args...) lum_player_stop(args)
#define self_get_stream_length(args...) lum_player_get_stream_length(args)
#define self_set_position(args...) lum_player_set_position(args)
#define self_set_contrast(args...) lum_player_set_contrast(args)
#define self_set_brightness(args...) lum_player_set_brightness(args)
#define self_set_hue(args...) lum_player_set_hue(args)
#define self_set_saturation(args...) lum_player_set_saturation(args)
#define self_set_eq(args...) lum_player_set_eq(args)
#define self_set_volume(args...) lum_player_set_volume(args)
#define self_get_volume(args...) lum_player_get_volume(args)
#define self_set_mute(args...) lum_player_set_mute(args)
#define self_get_position_time(args...) lum_player_get_position_time(args)
#define self_is_seekable(args...) lum_player_is_seekable(args)
#define self_is_running(args...) lum_player_is_running(args)
#define self_can_play(args...) lum_player_can_play(args)
#define self_playbackfinished(args...) lum_player_playbackfinished(args)
#define self_volume_changed(args...) lum_player_volume_changed(args)
#define self_status_changed(args...) lum_player_status_changed(args)
#define self_update_timer(args...) lum_player_update_timer(args)
#define self_update_position(args...) lum_player_update_position(args)
#define self_get_uri(args...) lum_player_get_uri(args)
#define self_get_info(args...) lum_player_get_info(args)
#define self_show_runtime(args...) lum_player_show_runtime(args)
#define self_set_popup_menu(args...) lum_player_set_popup_menu(args)
#define self_set_config(args...) lum_player_set_config(args)
#define self_hide_bars(args...) lum_player_hide_bars(args)
#define self_do_popup(args...) lum_player_do_popup(args)
#define self_set_fullscreen(args...) lum_player_set_fullscreen(args)
#define self_play_pause_cb(args...) lum_player_play_pause_cb(args)
#define self_fullscreen_cb(args...) lum_player_fullscreen_cb(args)
#define self_fullscreen_item_cb(args...) lum_player_fullscreen_item_cb(args)
#define self_properties_cb(args...) lum_player_properties_cb(args)
#define self_video_activate_cb(args...) lum_player_video_activate_cb(args)
#define self_eq_activate_cb(args...) lum_player_eq_activate_cb(args)
#define self_position_value_changed_cb(args...) lum_player_position_value_changed_cb(args)
#define self_volume_value_changed_cb(args...) lum_player_volume_value_changed_cb(args)
#define self_position_button_press_cb(args...) lum_player_position_button_press_cb(args)
#define self_position_button_release_cb(args...) lum_player_position_button_release_cb(args)
#define self_cont_cb(args...) lum_player_cont_cb(args)
#define self_bright_cb(args...) lum_player_bright_cb(args)
#define self_hue_cb(args...) lum_player_hue_cb(args)
#define self_sat_cb(args...) lum_player_sat_cb(args)
#define self_mute_cb(args...) lum_player_mute_cb(args)
#define self_eq30_cb(args...) lum_player_eq30_cb(args)
#define self_eq60_cb(args...) lum_player_eq60_cb(args)
#define self_eq125_cb(args...) lum_player_eq125_cb(args)
#define self_eq250_cb(args...) lum_player_eq250_cb(args)
#define self_eq500_cb(args...) lum_player_eq500_cb(args)
#define self_eq1000_cb(args...) lum_player_eq1000_cb(args)
#define self_eq2000_cb(args...) lum_player_eq2000_cb(args)
#define self_eq4000_cb(args...) lum_player_eq4000_cb(args)
#define self_eq8000_cb(args...) lum_player_eq8000_cb(args)
#define self_eq16000_cb(args...) lum_player_eq16000_cb(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static gboolean (* const self_open_file) (LumPlayer * self, const char * uri, LumPlayerInfo * info) = lum_player_open_file;
static void (* const self_play_pause) (LumPlayer * self) = lum_player_play_pause;
static void (* const self_stop) (LumPlayer * self) = lum_player_stop;
static gint (* const self_get_stream_length) (LumPlayer * self) = lum_player_get_stream_length;
static void (* const self_set_position) (LumPlayer * self, gdouble pos) = lum_player_set_position;
static void (* const self_set_contrast) (LumPlayer * self, gdouble pos) = lum_player_set_contrast;
static void (* const self_set_brightness) (LumPlayer * self, gdouble pos) = lum_player_set_brightness;
static void (* const self_set_hue) (LumPlayer * self, gdouble pos) = lum_player_set_hue;
static void (* const self_set_saturation) (LumPlayer * self, gdouble pos) = lum_player_set_saturation;
static void (* const self_set_eq) (LumPlayer * self, gint hz, gdouble pos) = lum_player_set_eq;
static void (* const self_set_volume) (LumPlayer * self, gdouble vol) = lum_player_set_volume;
static gdouble (* const self_get_volume) (LumPlayer * self) = lum_player_get_volume;
static void (* const self_set_mute) (LumPlayer * self) = lum_player_set_mute;
static gboolean (* const self_get_position_time) (LumPlayer * self, gdouble * position, gint * time) = lum_player_get_position_time;
static gboolean (* const self_is_seekable) (LumPlayer * self) = lum_player_is_seekable;
static gboolean (* const self_is_running) (LumPlayer * self) = lum_player_is_running;
static gboolean (* const self_can_play) (LumPlayer * self) = lum_player_can_play;
static void (* const self_playbackfinished) (LumPlayer * self) = lum_player_playbackfinished;
static void (* const self_volume_changed) (LumPlayer * self, double volume) = lum_player_volume_changed;
static void (* const self_status_changed) (LumPlayer * self) = lum_player_status_changed;
static gboolean (* const self_update_timer) (LumPlayer * self) = lum_player_update_timer;
static gboolean (* const self_update_position) (LumPlayer * self) = lum_player_update_position;
static const gchar * (* const self_get_uri) (LumPlayer * self) = lum_player_get_uri;
static LumPlayerInfo * (* const self_get_info) (LumPlayer * self) = lum_player_get_info;
static void (* const self_show_runtime) (LumPlayer * self) = lum_player_show_runtime;
static void (* const self_set_popup_menu) (LumPlayer * self, GtkMenu * menu) = lum_player_set_popup_menu;
static void (* const self_set_config) (LumPlayer * self, LumConfig * config) = lum_player_set_config;
static gboolean (* const self_hide_bars) (LumPlayer * self) = lum_player_hide_bars;
static void (* const self_do_popup) (LumPlayer const * self, GdkEventButton * event) = lum_player_do_popup;
static void (* const self_set_fullscreen) (LumPlayer * self) = lum_player_set_fullscreen;
static void (* const self_play_pause_cb) (GtkToggleButton * button, Self * self) = lum_player_play_pause_cb;
static void (* const self_fullscreen_cb) (GtkButton * button, Self * self) = lum_player_fullscreen_cb;
static void (* const self_fullscreen_item_cb) (GtkCheckMenuItem * item, Self * self) = lum_player_fullscreen_item_cb;
static void (* const self_properties_cb) (GtkButton * button, Self * self) = lum_player_properties_cb;
static void (* const self_video_activate_cb) (GtkToggleButton * button, gpointer data) = lum_player_video_activate_cb;
static void (* const self_eq_activate_cb) (GtkToggleButton * button, gpointer data) = lum_player_eq_activate_cb;
static void (* const self_position_value_changed_cb) (GtkRange * range, Self * self) = lum_player_position_value_changed_cb;
static void (* const self_volume_value_changed_cb) (GtkRange * range, Self * self) = lum_player_volume_value_changed_cb;
static gboolean (* const self_position_button_press_cb) (GtkWidget * widget, GdkEventButton * event, gpointer data) = lum_player_position_button_press_cb;
static gboolean (* const self_position_button_release_cb) (GtkWidget * widget, GdkEventButton * event, gpointer data) = lum_player_position_button_release_cb;
static void (* const self_cont_cb) (GtkRange * range, Self * self) = lum_player_cont_cb;
static void (* const self_bright_cb) (GtkRange * range, Self * self) = lum_player_bright_cb;
static void (* const self_hue_cb) (GtkRange * range, Self * self) = lum_player_hue_cb;
static void (* const self_sat_cb) (GtkRange * range, Self * self) = lum_player_sat_cb;
static void (* const self_mute_cb) (GtkToggleButton * button, Self * self) = lum_player_mute_cb;
static void (* const self_eq30_cb) (GtkRange * range, Self * self) = lum_player_eq30_cb;
static void (* const self_eq60_cb) (GtkRange * range, Self * self) = lum_player_eq60_cb;
static void (* const self_eq125_cb) (GtkRange * range, Self * self) = lum_player_eq125_cb;
static void (* const self_eq250_cb) (GtkRange * range, Self * self) = lum_player_eq250_cb;
static void (* const self_eq500_cb) (GtkRange * range, Self * self) = lum_player_eq500_cb;
static void (* const self_eq1000_cb) (GtkRange * range, Self * self) = lum_player_eq1000_cb;
static void (* const self_eq2000_cb) (GtkRange * range, Self * self) = lum_player_eq2000_cb;
static void (* const self_eq4000_cb) (GtkRange * range, Self * self) = lum_player_eq4000_cb;
static void (* const self_eq8000_cb) (GtkRange * range, Self * self) = lum_player_eq8000_cb;
static void (* const self_eq16000_cb) (GtkRange * range, Self * self) = lum_player_eq16000_cb;

GType
lum_player_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumPlayerClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_player_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumPlayer),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_player_init,
		};

		type = g_type_register_static (GTK_TYPE_VBOX, "LumPlayer", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumPlayer *)g_object_new(lum_player_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumPlayer * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumPlayer *
GET_NEW_VARG (const char *first, ...)
{
	LumPlayer *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumPlayer *)g_object_new_valist (lum_player_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Player::dispose"
	LumPlayer *self = LUM_PLAYER (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
	if(self->config) { ((*(void (*)(void *))g_object_unref)) (self->config); self->config = NULL; }
	if(self->_priv->info) { ((*(void (*)(void *))g_object_unref)) (self->_priv->info); self->_priv->info = NULL; }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Player::finalize"
	LumPlayer *self = LUM_PLAYER (obj_self);
	gpointer priv = self->_priv;
	___18_lum_player_finalize(obj_self);
	if(self->_priv->uri) { ((*(void (*)(void *))g_free)) (self->_priv->uri); self->_priv->uri = NULL; }
	if(self->_priv->runtime) { ((*(void (*)(void *))gtk_widget_destroy)) (self->_priv->runtime); self->_priv->runtime = NULL; }
	if(self->_priv->scrsaver) { ((*(void (*)(void *))scrsaver_free)) (self->_priv->scrsaver); self->_priv->scrsaver = NULL; }
	if(self->_priv->gtimer) { ((*(void (*)(void *))g_timer_destroy)) (self->_priv->gtimer); self->_priv->gtimer = NULL; }
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_player_class_init (LumPlayerClass * c)
{
#define __GOB_FUNCTION__ "Lum:Player::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	parent_class = g_type_class_ref (GTK_TYPE_VBOX);

	object_signals[PLAYBACKFINISHED_SIGNAL] =
		g_signal_new ("playbackfinished",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LumPlayerClass, playbackfinished),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[VOLUME_CHANGED_SIGNAL] =
		g_signal_new ("volume_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LumPlayerClass, volume_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_DOUBLE);
	if ___GOB_UNLIKELY(sizeof(double ) != sizeof(gdouble )) {
		g_error("lum-player.gob line 281: Type mismatch of \"volume_changed\" signal signature");
	}
	object_signals[STATUS_CHANGED_SIGNAL] =
		g_signal_new ("status_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LumPlayerClass, status_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[UPDATE_TIMER_SIGNAL] =
		g_signal_new ("update_timer",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LumPlayerClass, update_timer),
			NULL, NULL,
			___marshal_Sig2,
			G_TYPE_BOOLEAN, 0);
	if ___GOB_UNLIKELY( sizeof(gboolean ) != sizeof(gboolean )) {
		g_error("lum-player.gob line 338: Type mismatch of \"update_timer\" signal signature");
	}
	object_signals[UPDATE_POSITION_SIGNAL] =
		g_signal_new ("update_position",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LumPlayerClass, update_position),
			NULL, NULL,
			___marshal_Sig2,
			G_TYPE_BOOLEAN, 0);
	if ___GOB_UNLIKELY( sizeof(gboolean ) != sizeof(gboolean )) {
		g_error("lum-player.gob line 355: Type mismatch of \"update_position\" signal signature");
	}

	c->open_file = ___real_lum_player_open_file;
	c->play_pause = NULL;
	c->stop = ___real_lum_player_stop;
	c->get_stream_length = NULL;
	c->set_position = NULL;
	c->set_contrast = NULL;
	c->set_brightness = NULL;
	c->set_hue = NULL;
	c->set_saturation = NULL;
	c->set_eq = NULL;
	c->set_volume = ___real_lum_player_set_volume;
	c->get_volume = NULL;
	c->set_mute = NULL;
	c->get_position_time = NULL;
	c->is_seekable = NULL;
	c->is_running = NULL;
	c->can_play = NULL;
	c->playbackfinished = NULL;
	c->volume_changed = NULL;
	c->status_changed = ___real_lum_player_status_changed;
	c->update_timer = ___real_lum_player_update_timer;
	c->update_position = ___real_lum_player_update_position;
	g_object_class->finalize = ___finalize;
	gtk_widget_class->motion_notify_event = ___19_lum_player_motion_notify_event;
	gtk_widget_class->button_press_event = ___1a_lum_player_button_press_event;
	gtk_widget_class->key_release_event = ___1b_lum_player_key_release_event;
	g_object_class->dispose = ___dispose;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("can_fullscreen" /* name */,
		 _("Can fullscreen") /* nick */,
		 _("Fullscreen allowed?") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CAN_FULLSCREEN,
		param_spec);
	param_spec = g_param_spec_boolean
		("fullscreen" /* name */,
		 _("fullscreen") /* nick */,
		 _("Fullscreen Mode") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_FULLSCREEN,
		param_spec);
	param_spec = g_param_spec_boolean
		("can_hide_bars" /* name */,
		 _("Can hide the bars") /* nick */,
		 _("Allow to hide the bars in window mode") /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CAN_HIDE_BARS,
		param_spec);
	param_spec = g_param_spec_boolean
		("mute" /* name */,
		 _("mute") /* nick */,
		 _("Mute Sound") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MUTE,
		param_spec);
	param_spec = g_param_spec_boolean
		("repeat" /* name */,
		 _("Repeat") /* nick */,
		 _("Restart when file finished") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_REPEAT,
		param_spec);
    }
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_player_init (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::init"
	self->_priv = g_new0 (LumPlayerPrivate, 1);
	self->config = NULL;
	self->status = PLAYER_STOPPED;
	self->position = 0.0;
	self->time = 0.0;
	self->_priv->uri = NULL;
	self->_priv->info = NULL;
	self->_priv->timer = NULL;
	self->_priv->timerid = FALSE;
	self->_priv->position_range = NULL;
	self->_priv->positionid = FALSE;
	self->_priv->position_pressed = FALSE;
	self->_priv->in_pos_timer = FALSE;
	self->_priv->volume_range = NULL;
	self->_priv->volume_moving = FALSE;
	self->_priv->popup_menu = NULL;
	self->_priv->play_pause_btn = NULL;
	self->_priv->runtime = NULL;
	self->_priv->scrsaver = scrsaver_new();
	self->_priv->fullscreen_btn = NULL;
	self->_priv->fullscreen_item = NULL;
	self->_priv->fullscreen = FALSE;
	self->_priv->top = NULL;
	self->_priv->bottom = NULL;
	self->_priv->hideid = FALSE;
	self->_priv->gtimer = g_timer_new();
	self->_priv->mute = FALSE;
 {

		GladeXML *xml;

		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"lum_player_tb_top", GETTEXT_PACKAGE);
		g_assert(xml != NULL);

		selfp->top = glade_xml_get_widget(xml, "lum_player_tb_top");
		selfp->timer = GTK_LABEL(glade_xml_get_widget(xml, "timer"));
		selfp->fullscreen_btn = glade_xml_get_widget(xml, "fullscreen");
		
		gtk_box_pack_start(GTK_BOX(self), selfp->top, FALSE, FALSE, 0);
		
		if(!selfp->can_fullscreen)
			gtk_widget_set_sensitive(selfp->fullscreen_btn, FALSE);
		
		glade_xml_signal_connect_data(xml, "fullscreen_cb",
				G_CALLBACK(self_fullscreen_cb), self);
		glade_xml_signal_connect_data(xml, "properties_cb",
				G_CALLBACK(self_properties_cb), self);


		g_object_unref(G_OBJECT(xml));
		
		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"lum_player_tb_bottom", GETTEXT_PACKAGE);
		g_assert(xml != NULL);

		selfp->bottom = glade_xml_get_widget(xml, "lum_player_tb_bottom");
		selfp->play_pause_btn = glade_xml_get_widget(xml, "play_pause");
		selfp->position_range = GTK_RANGE(glade_xml_get_widget(xml, "position"));
		selfp->volume_range = GTK_RANGE(glade_xml_get_widget(xml, "volume"));
		gtk_box_pack_end(GTK_BOX(self), selfp->bottom, FALSE, FALSE, 0);
		gtk_widget_set_sensitive(selfp->play_pause_btn, FALSE);
		
		selfp->play_pause_id = g_signal_connect(
				G_OBJECT(selfp->play_pause_btn), "toggled",
				G_CALLBACK(self_play_pause_cb), self);
		glade_xml_signal_connect_data(xml, "position_value_changed_cb",
					G_CALLBACK(self_position_value_changed_cb), self);
		glade_xml_signal_connect_data(xml, "position_button_press_cb",
					G_CALLBACK(self_position_button_press_cb), self);
		glade_xml_signal_connect_data(xml, "position_button_release_cb",
					G_CALLBACK(self_position_button_release_cb), self);
		glade_xml_signal_connect_data(xml, "volume_value_changed_cb",
					G_CALLBACK(self_volume_value_changed_cb), self);
		
		g_object_unref(G_OBJECT(xml));

		g_timer_start(selfp->gtimer);
		
		if(selfp->can_hide_bars)
			selfp->hideid = gtk_timeout_add(
					5000, (GtkFunction) self_hide_bars, self);
	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL,
	GParamSpec *pspec)
#define __GOB_FUNCTION__ "Lum:Player::set_property"
{
	LumPlayer *self;

	self = LUM_PLAYER (object);

	switch (property_id) {
	case PROP_CAN_FULLSCREEN:
		{
 selfp->can_fullscreen = g_value_get_boolean(VAL);
			if(selfp->fullscreen_btn)
				gtk_widget_set_sensitive(
					selfp->fullscreen_btn, selfp->can_fullscreen);
			if(selfp->fullscreen_item)
				gtk_widget_set_sensitive(
					selfp->fullscreen_item, selfp->can_fullscreen);
		}
		break;
	case PROP_FULLSCREEN:
		{
 selfp->fullscreen = g_value_get_boolean(VAL);
		gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON(selfp->fullscreen_btn), selfp->fullscreen);
		gtk_check_menu_item_set_active(
			GTK_CHECK_MENU_ITEM(selfp->fullscreen_item),selfp->fullscreen);
		self_set_fullscreen(self);
		}
		break;
	case PROP_CAN_HIDE_BARS:
		{
 selfp->can_hide_bars = g_value_get_boolean(VAL); 
		}
		break;
	case PROP_MUTE:
		{
 selfp->mute = g_value_get_boolean(VAL);
			self_set_mute(self);
		
		}
		break;
	case PROP_REPEAT:
		{
 self->repeat = g_value_get_boolean(VAL);
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
	return;
	self = NULL;
	VAL = NULL;
	pspec = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL,
	GParamSpec *pspec)
#define __GOB_FUNCTION__ "Lum:Player::get_property"
{
	LumPlayer *self;

	self = LUM_PLAYER (object);

	switch (property_id) {
	case PROP_CAN_FULLSCREEN:
		{
 g_value_set_boolean(VAL, selfp->can_fullscreen); 
		}
		break;
	case PROP_FULLSCREEN:
		{
 g_value_set_boolean(VAL, selfp->can_fullscreen); 
		}
		break;
	case PROP_CAN_HIDE_BARS:
		{
 g_value_set_boolean(VAL, selfp->can_hide_bars); 
		}
		break;
	case PROP_MUTE:
		{
 g_value_set_boolean(VAL, selfp->mute); 
		}
		break;
	case PROP_REPEAT:
		{
 g_value_set_boolean(VAL, self->repeat); 
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
	return;
	self = NULL;
	VAL = NULL;
	pspec = NULL;
}
#undef __GOB_FUNCTION__



gboolean 
lum_player_open_file (LumPlayer * self, const char * uri, LumPlayerInfo * info)
{
	LumPlayerClass *klass;
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )FALSE);
	g_return_val_if_fail (uri != NULL, (gboolean )FALSE);
	g_return_val_if_fail (info != NULL, (gboolean )FALSE);
	g_return_val_if_fail (LUM_IS_PLAYER_INFO (info), (gboolean )FALSE);
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->open_file)
		return (*klass->open_file)(self,uri,info);
	else
		return (gboolean )(FALSE);
}
static gboolean 
___real_lum_player_open_file (LumPlayer * self, const char * uri, LumPlayerInfo * info)
{
#define __GOB_FUNCTION__ "Lum:Player::open_file"
{
	
		if(selfp->uri)
			g_free(selfp->uri);
		selfp->uri = g_strdup(uri);
		
		if(selfp->info)
			g_object_unref(selfp->info);
		selfp->info = g_object_ref(info);

		gtk_widget_set_sensitive(selfp->play_pause_btn, TRUE);
		self->status = PLAYER_STOPPED;
		return TRUE;
	}}
#undef __GOB_FUNCTION__

void 
lum_player_play_pause (LumPlayer * self)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->play_pause)
		(*klass->play_pause)(self);
}

void 
lum_player_stop (LumPlayer * self)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->stop)
		(*klass->stop)(self);
}
static void 
___real_lum_player_stop (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::stop"
{
	
		if(selfp->uri){
			g_free(selfp->uri);
			selfp->uri = NULL;
		}
		if(selfp->info){
			g_object_unref(selfp->info);
			selfp->info = NULL;
		}
		gtk_widget_set_sensitive(selfp->play_pause_btn, FALSE);
		self->status = PLAYER_STOPPED;
		self_status_changed(self);
	}}
#undef __GOB_FUNCTION__

gint 
lum_player_get_stream_length (LumPlayer * self)
{
	LumPlayerClass *klass;
	g_return_val_if_fail (self != NULL, (gint )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gint )0);
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->get_stream_length)
		return (*klass->get_stream_length)(self);
	else
		return (gint )(0);
}

void 
lum_player_set_position (LumPlayer * self, gdouble pos)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_position)
		(*klass->set_position)(self,pos);
}

void 
lum_player_set_contrast (LumPlayer * self, gdouble pos)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_contrast)
		(*klass->set_contrast)(self,pos);
}

void 
lum_player_set_brightness (LumPlayer * self, gdouble pos)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_brightness)
		(*klass->set_brightness)(self,pos);
}

void 
lum_player_set_hue (LumPlayer * self, gdouble pos)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_hue)
		(*klass->set_hue)(self,pos);
}

void 
lum_player_set_saturation (LumPlayer * self, gdouble pos)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_saturation)
		(*klass->set_saturation)(self,pos);
}

void 
lum_player_set_eq (LumPlayer * self, gint hz, gdouble pos)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_eq)
		(*klass->set_eq)(self,hz,pos);
}

void 
lum_player_set_volume (LumPlayer * self, gdouble vol)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_volume)
		(*klass->set_volume)(self,vol);
}
static void 
___real_lum_player_set_volume (LumPlayer * self, gdouble vol)
{
#define __GOB_FUNCTION__ "Lum:Player::set_volume"
{
	
		selfp->volume_moving = TRUE;
		gtk_range_set_value(selfp->volume_range, vol);
		self_volume_changed(self, vol);
		selfp->volume_moving = FALSE;
	}}
#undef __GOB_FUNCTION__

gdouble 
lum_player_get_volume (LumPlayer * self)
{
	LumPlayerClass *klass;
	g_return_val_if_fail (self != NULL, (gdouble )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gdouble )0);
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->get_volume)
		return (*klass->get_volume)(self);
	else
		return (gdouble )(0);
}

static void 
lum_player_set_mute (LumPlayer * self)
{
	LumPlayerClass *klass;
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_mute)
		(*klass->set_mute)(self);
}

gboolean 
lum_player_get_position_time (LumPlayer * self, gdouble * position, gint * time)
{
	LumPlayerClass *klass;
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )0);
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->get_position_time)
		return (*klass->get_position_time)(self,position,time);
	else
		return (gboolean )(0);
}

gboolean 
lum_player_is_seekable (LumPlayer * self)
{
	LumPlayerClass *klass;
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )0);
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->is_seekable)
		return (*klass->is_seekable)(self);
	else
		return (gboolean )(FALSE);
}

gboolean 
lum_player_is_running (LumPlayer * self)
{
	LumPlayerClass *klass;
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )0);
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->is_running)
		return (*klass->is_running)(self);
	else
		return (gboolean )(FALSE);
}

gboolean 
lum_player_can_play (LumPlayer * self)
{
	LumPlayerClass *klass;
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )FALSE);
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->can_play)
		return (*klass->can_play)(self);
	else
		return (gboolean )(TRUE);
}

void 
lum_player_playbackfinished (LumPlayer * self)
{
	GValue ___param_values[1];
	GValue ___return_val = {0};

	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[PLAYBACKFINISHED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

void 
lum_player_volume_changed (LumPlayer * self, double volume)
{
	GValue ___param_values[2];
	GValue ___return_val = {0};

	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_DOUBLE);
	g_value_set_double (&___param_values[1], (gdouble ) volume);

	g_signal_emitv (___param_values,
		object_signals[VOLUME_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

void 
lum_player_status_changed (LumPlayer * self)
{
	GValue ___param_values[1];
	GValue ___return_val = {0};

	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[STATUS_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
static void 
___real_lum_player_status_changed (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::status_changed"
{
	
			g_signal_handler_disconnect(selfp->play_pause_btn,
						selfp->play_pause_id);
			switch(self->status){
			case PLAYER_STOPPED:
				gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(selfp->play_pause_btn), FALSE);
				if(selfp->timerid){
					gtk_timeout_remove(selfp->timerid);
					selfp->timerid = FALSE;
				}
				if(selfp->positionid){
					gtk_timeout_remove(selfp->positionid);
					selfp->positionid = FALSE;
				}		
				break;
			case PLAYER_PLAYING:
				gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(selfp->play_pause_btn), TRUE);
				selfp->positionid = gtk_timeout_add(1000,
					(GtkFunction) self_update_position, self);
				selfp->timerid = gtk_timeout_add(1000,
					(GtkFunction) self_update_timer, self);
				break;
			case PLAYER_PAUSED:
				gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(selfp->play_pause_btn), FALSE);
				if(selfp->timerid){
					gtk_timeout_remove(selfp->timerid);
					selfp->timerid = FALSE;
				}
				if(selfp->positionid){
					gtk_timeout_remove(selfp->positionid);
					selfp->positionid = FALSE;
				}
				break;
			default:
				break;
			}
			selfp->play_pause_id = g_signal_connect(G_OBJECT(
						selfp->play_pause_btn),
						"toggled",
						G_CALLBACK(self_play_pause_cb), self);
		}}
#undef __GOB_FUNCTION__

gboolean 
lum_player_update_timer (LumPlayer * self)
{
	GValue ___param_values[1];
	GValue ___return_val = {0};

	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )0);

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_value_init (&___return_val, G_TYPE_BOOLEAN);

	g_signal_emitv (___param_values,
		object_signals[UPDATE_TIMER_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);

	{
		gboolean  ___ret = (gboolean ) g_value_get_boolean (&___return_val);
		g_value_unset (&___return_val);
		return ___ret;
	}
}
static gboolean 
___real_lum_player_update_timer (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::update_timer"
{
	
			if(self->status == PLAYER_STOPPED)
				return FALSE;
			
			if(self_is_seekable(self)){
				gchar *text;
				self_get_position_time(self, &self->position, &self->time);
				gint min = self->time / 60000;
				gint secs = (self->time / 1000) - (min * 60);
				text = g_strdup_printf("%.2d:%.2d", min, secs);
				gtk_label_set_text(selfp->timer, text);
				g_free(text);
			}
			return TRUE;
		}}
#undef __GOB_FUNCTION__

gboolean 
lum_player_update_position (LumPlayer * self)
{
	GValue ___param_values[1];
	GValue ___return_val = {0};

	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )0);

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_value_init (&___return_val, G_TYPE_BOOLEAN);

	g_signal_emitv (___param_values,
		object_signals[UPDATE_POSITION_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);

	{
		gboolean  ___ret = (gboolean ) g_value_get_boolean (&___return_val);
		g_value_unset (&___return_val);
		return ___ret;
	}
}
static gboolean 
___real_lum_player_update_position (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::update_position"
{
	
			gboolean is_seekable;
			if(self->status == PLAYER_STOPPED)
				return FALSE;
			
			is_seekable = self_is_seekable(self);
			gtk_widget_set_sensitive(
					GTK_WIDGET(selfp->position_range), is_seekable);

			if(is_seekable){
				if(!selfp->position_pressed){
					selfp->in_pos_timer = TRUE;
					gtk_range_set_value(
							selfp->position_range, self->position);
					selfp->in_pos_timer = FALSE;
				}
			}
			return TRUE;
		}}
#undef __GOB_FUNCTION__

static void 
___18_lum_player_finalize (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Player::finalize"
	g_return_if_fail (object != NULL);
	g_return_if_fail (G_IS_OBJECT (object));
{
	
#ifdef DEBUG
		printf(__FILE__ ": finalize\n");
#endif
		Self *self = SELF(object);
		if(selfp->timerid){
			gtk_timeout_remove(selfp->timerid);
			selfp->timerid = FALSE;
		}
		if(selfp->positionid){
			gtk_timeout_remove(selfp->positionid);
			selfp->positionid = FALSE;
		}
		if(selfp->hideid){
			gtk_timeout_remove(selfp->hideid);
			selfp->hideid = FALSE;
		}

		if(selfp->popup_menu){
			gtk_widget_hide(selfp->popup_menu);
			gtk_widget_destroy(selfp->popup_menu);
			selfp->popup_menu = NULL;
		}
#ifdef DEBUG
		printf(__FILE__ ": finalized\n");
#endif
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___19_lum_player_motion_notify_event (GtkWidget * widget, GdkEventMotion * event)
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->motion_notify_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->motion_notify_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Player::motion_notify_event"
{
	
		static gdouble old_ticks = 0;
		gdouble new_ticks;
		gulong unused;
		Self *self = SELF(widget);
		if(!GTK_WIDGET_VISIBLE(selfp->top)){
			gtk_widget_show(selfp->top);
		}
		if(!GTK_WIDGET_VISIBLE(selfp->bottom)){
			gtk_widget_show(selfp->bottom);
		}
		new_ticks = g_timer_elapsed(selfp->gtimer, &unused);
		if((new_ticks - old_ticks) <= 5 &&
				(selfp->fullscreen || selfp->can_hide_bars))
			gtk_timeout_remove(selfp->hideid);
		selfp->hideid = gtk_timeout_add(5000, (GtkFunction) self_hide_bars, self);
		old_ticks = new_ticks;		
		return FALSE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___1a_lum_player_button_press_event (GtkWidget * widget, GdkEventButton * event)
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->button_press_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->button_press_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Player::button_press_event"
{
	
		Self *self = SELF(widget);
		if ((event->button == 4 || event->button == 5) &&
					event->type == GDK_BUTTON_PRESS) {
			int volume = self_get_volume(self);
			if (event->button == 5){
				volume = volume <= 9 ? 0 : volume - 10;
				self_set_volume(self, volume);
			} else if (event->button == 4) {
				volume = volume >= 91 ? 100 : volume + 10;
				self_set_volume(self, volume);
			}
			return TRUE;
		}

		if (event->button == 3) {
			self_do_popup(self, event);
			return TRUE;
		}
		return FALSE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___1b_lum_player_key_release_event (GtkWidget * widget, GdkEventKey * event)
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->key_release_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->key_release_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Player::key_release_event"
{
	
		Self *self = SELF(widget);
		switch (event->keyval) {
			case GDK_F11:
				if (event->state & GDK_CONTROL_MASK)
					g_object_set(self, "fullscreen", !selfp->fullscreen,
							NULL, NULL);
				break;
			default:
				return PARENT_HANDLER(widget, event);
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

const gchar * 
lum_player_get_uri (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::get_uri"
	g_return_val_if_fail (self != NULL, (const gchar * )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (const gchar * )0);
{
		return selfp->uri; }}
#undef __GOB_FUNCTION__

LumPlayerInfo * 
lum_player_get_info (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::get_info"
	g_return_val_if_fail (self != NULL, (LumPlayerInfo * )0);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (LumPlayerInfo * )0);
{
		return selfp->info; }}
#undef __GOB_FUNCTION__

void 
lum_player_show_runtime (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::show_runtime"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
{
	
		GladeXML *xml;
		GtkWidget *widget;
		if(selfp->runtime){
			g_object_unref(selfp->runtime);
		}

		xml = glade_xml_new(
				DATADIR"/lumiere/lumiere.glade",
				"runtime", GETTEXT_PACKAGE);
		g_assert(xml != NULL);

		if(selfp->info){
			/*TODO remove this hack */
			gboolean vfx = FALSE;
			g_object_get(self, "GtkXine::show_vfx", &vfx, NULL, NULL);
			selfp->runtime = glade_xml_get_widget(xml, "runtime");
			g_object_ref(selfp->runtime);
			gtk_object_sink(GTK_OBJECT(selfp->runtime));
			widget = glade_xml_get_widget(xml, "close");
			g_signal_connect_swapped(widget, "clicked", G_CALLBACK(gtk_widget_destroy), selfp->runtime);
			g_signal_connect(selfp->runtime, "destroy", G_CALLBACK(gtk_widget_destroyed), &selfp->runtime);
			if(selfp->info->has_video || vfx){
				widget = glade_xml_get_widget(xml, "video");
				gtk_widget_set_sensitive(widget, TRUE);
				widget = glade_xml_get_widget(xml, "video_table");
				glade_xml_signal_connect_data(xml, "video_activate",
					G_CALLBACK(self_video_activate_cb), widget);
				glade_xml_signal_connect_data(xml, "cont_cb",
					G_CALLBACK(self_cont_cb), self);
				glade_xml_signal_connect_data(xml, "bright_cb",
					G_CALLBACK(self_bright_cb), self);
				glade_xml_signal_connect_data(xml, "hue_cb",
					G_CALLBACK(self_hue_cb), self);
				glade_xml_signal_connect_data(xml, "sat_cb",
					G_CALLBACK(self_sat_cb), self);
			}
			if(selfp->info->has_audio){
				widget = glade_xml_get_widget(xml, "equalizer");
				gtk_widget_set_sensitive(widget, TRUE);
				widget = glade_xml_get_widget(xml, "mute");
				gtk_widget_set_sensitive(widget, TRUE);
				gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(widget), selfp->mute);
				widget = glade_xml_get_widget(xml, "eq_table");
				glade_xml_signal_connect_data(xml, "equalizer_activate",
					G_CALLBACK(self_eq_activate_cb), widget);
				glade_xml_signal_connect_data(xml, "mute_cb",
					G_CALLBACK(self_mute_cb), self);
				glade_xml_signal_connect_data(xml, "eq30_cb",
					G_CALLBACK(self_eq30_cb), self);
				glade_xml_signal_connect_data(xml, "eq60_cb",
					G_CALLBACK(self_eq60_cb), self);
				glade_xml_signal_connect_data(xml, "eq125_cb",
					G_CALLBACK(self_eq125_cb), self);
				glade_xml_signal_connect_data(xml, "eq250_cb",
					G_CALLBACK(self_eq250_cb), self);
				glade_xml_signal_connect_data(xml, "eq500_cb",
					G_CALLBACK(self_eq500_cb), self);
				glade_xml_signal_connect_data(xml, "eq1000_cb",
					G_CALLBACK(self_eq1000_cb), self);
				glade_xml_signal_connect_data(xml, "eq2000_cb",
					G_CALLBACK(self_eq2000_cb), self);
				glade_xml_signal_connect_data(xml, "eq4000_cb",
					G_CALLBACK(self_eq4000_cb), self);
				glade_xml_signal_connect_data(xml, "eq8000_cb",
					G_CALLBACK(self_eq8000_cb), self);
				glade_xml_signal_connect_data(xml, "eq16000_cb",
					G_CALLBACK(self_eq16000_cb), self);
			}
		}
		g_object_unref(xml);
	}}
#undef __GOB_FUNCTION__

void 
lum_player_set_popup_menu (LumPlayer * self, GtkMenu * menu)
{
#define __GOB_FUNCTION__ "Lum:Player::set_popup_menu"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	g_return_if_fail (menu != NULL);
	g_return_if_fail (GTK_IS_MENU (menu));
{
	
		if(selfp->popup_menu)
			gtk_widget_destroy(selfp->popup_menu);
		selfp->popup_menu = GTK_WIDGET(menu);
		if(selfp->can_fullscreen){
			selfp->fullscreen_item = gtk_check_menu_item_new_with_label(
				_("Fullscreen"));
			g_signal_connect(G_OBJECT(selfp->fullscreen_item), "activate",
				G_CALLBACK(self_fullscreen_item_cb), self);
			gtk_widget_show(selfp->fullscreen_item);
			gtk_menu_shell_append(GTK_MENU_SHELL(selfp->popup_menu),
					selfp->fullscreen_item);
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_player_set_config (LumPlayer * self, LumConfig * config)
{
#define __GOB_FUNCTION__ "Lum:Player::set_config"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
	g_return_if_fail (config != NULL);
	g_return_if_fail (LUM_IS_CONFIG (config));
{
	
		if(self->config)
			g_object_unref(self->config);
		self->config = g_object_ref(config);
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_player_hide_bars (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::hide_bars"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )FALSE);
{
	
		if(selfp->fullscreen || !selfp->can_fullscreen || selfp->can_hide_bars){
			if(GTK_WIDGET_VISIBLE(selfp->top))
				gtk_widget_hide(selfp->top);
			if(GTK_WIDGET_VISIBLE(selfp->bottom))
				gtk_widget_hide(selfp->bottom);
		}
		return FALSE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_do_popup (LumPlayer const * self, GdkEventButton * event)
{
#define __GOB_FUNCTION__ "Lum:Player::do_popup"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
{
	
		gtk_menu_popup (GTK_MENU(selfp->popup_menu),
					NULL, NULL, NULL,
					NULL, event->button,gtk_get_current_event_time());	
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_set_fullscreen (LumPlayer * self)
{
#define __GOB_FUNCTION__ "Lum:Player::set_fullscreen"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER (self));
{
	
		GtkWidget *toplevel = gtk_widget_get_toplevel(GTK_WIDGET(self));
		if (GTK_WIDGET_TOPLEVEL(toplevel)) {
			if(selfp->fullscreen) {
				gtk_window_set_decorated(GTK_WINDOW(toplevel), FALSE);
				gdk_window_fullscreen(toplevel->window);
				if(self->config->stop_ssaver)
					scrsaver_disable(selfp->scrsaver);
				g_timeout_add(5000, (GSourceFunc) self_hide_bars, self);
			} else {
				gtk_window_set_decorated(GTK_WINDOW(toplevel), TRUE);
				gdk_window_unfullscreen(toplevel->window);
				if(self->config->stop_ssaver)
					scrsaver_enable(selfp->scrsaver);
			}
		}
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_play_pause_cb (GtkToggleButton * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::play_pause_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_play_pause(self);
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_fullscreen_cb (GtkButton * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::fullscreen_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		if(selfp->fullscreen != gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
			g_object_set(G_OBJECT(self), "LumPlayer::fullscreen", !selfp->fullscreen, NULL, NULL);
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_fullscreen_item_cb (GtkCheckMenuItem * item, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::fullscreen_item_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		if(selfp->fullscreen != item->active)
			g_object_set(G_OBJECT(self), "LumPlayer::fullscreen", !selfp->fullscreen, NULL, NULL);
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_properties_cb (GtkButton * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::properties_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		if(selfp->info)
			lum_util_show_props_window(selfp->info);
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_video_activate_cb (GtkToggleButton * button, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Player::video_activate_cb"
{
	
		if(gtk_toggle_button_get_active(button))
			gtk_widget_show_all(GTK_WIDGET(data));
		else
			gtk_widget_hide(GTK_WIDGET(data));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq_activate_cb (GtkToggleButton * button, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Player::eq_activate_cb"
{
	
		if(gtk_toggle_button_get_active(button))
			gtk_widget_show_all(GTK_WIDGET(data));
		else
			gtk_widget_hide(GTK_WIDGET(data));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_position_value_changed_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::position_value_changed_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		if(!selfp->in_pos_timer)
			if(self_is_seekable(self))
				self_set_position(self, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_volume_value_changed_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::volume_value_changed_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		if(!selfp->volume_moving){
			self_set_volume(self, gtk_range_get_value(range));
		}
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_player_position_button_press_cb (GtkWidget * widget, GdkEventButton * event, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Player::position_button_press_cb"
	g_return_val_if_fail (widget != NULL, (gboolean )0);
{
	
		Self *self = SELF(data);

		if(event->button == 1 && event->type == GDK_BUTTON_PRESS)
			selfp->position_pressed = TRUE;
		return FALSE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_player_position_button_release_cb (GtkWidget * widget, GdkEventButton * event, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Player::position_button_release_cb"
	g_return_val_if_fail (widget != NULL, (gboolean )0);
{
	
		Self *self = SELF(data);
		if(event->button == 1)
			selfp->position_pressed = FALSE;
		return FALSE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_cont_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::cont_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_contrast(self, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_bright_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::bright_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_brightness(self, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_hue_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::hue_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_hue(self, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_sat_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::sat_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_saturation(self, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_mute_cb (GtkToggleButton * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::mute_cb"
	g_return_if_fail (button != NULL);
	g_return_if_fail (GTK_IS_TOGGLE_BUTTON (button));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		g_object_set(G_OBJECT(self), "LumPlayer::mute",
				gtk_toggle_button_get_active(button), NULL, NULL);
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq30_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq30_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 30, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq60_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq60_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 60, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq125_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq125_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 125, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq250_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq250_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 250, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq500_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq500_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 500, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq1000_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq1000_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 1000, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq2000_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq2000_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 2000, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq4000_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq4000_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 4000, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq8000_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq8000_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 8000, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_eq16000_cb (GtkRange * range, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Player::eq16000_cb"
	g_return_if_fail (range != NULL);
	g_return_if_fail (GTK_IS_RANGE (range));
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_set_eq(self, 16000, gtk_range_get_value(range));
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_player_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_open_file)();
	((void (*)(void))self_play_pause)();
	((void (*)(void))self_stop)();
	((void (*)(void))self_get_stream_length)();
	((void (*)(void))self_set_position)();
	((void (*)(void))self_set_contrast)();
	((void (*)(void))self_set_brightness)();
	((void (*)(void))self_set_hue)();
	((void (*)(void))self_set_saturation)();
	((void (*)(void))self_set_eq)();
	((void (*)(void))self_set_volume)();
	((void (*)(void))self_get_volume)();
	((void (*)(void))self_set_mute)();
	((void (*)(void))self_get_position_time)();
	((void (*)(void))self_is_seekable)();
	((void (*)(void))self_is_running)();
	((void (*)(void))self_can_play)();
	((void (*)(void))self_playbackfinished)();
	((void (*)(void))self_volume_changed)();
	((void (*)(void))self_status_changed)();
	((void (*)(void))self_update_timer)();
	((void (*)(void))self_update_position)();
	((void (*)(void))self_get_uri)();
	((void (*)(void))self_get_info)();
	((void (*)(void))self_show_runtime)();
	((void (*)(void))self_set_popup_menu)();
	((void (*)(void))self_set_config)();
	((void (*)(void))self_hide_bars)();
	((void (*)(void))self_do_popup)();
	((void (*)(void))self_set_fullscreen)();
	((void (*)(void))self_play_pause_cb)();
	((void (*)(void))self_fullscreen_cb)();
	((void (*)(void))self_fullscreen_item_cb)();
	((void (*)(void))self_properties_cb)();
	((void (*)(void))self_video_activate_cb)();
	((void (*)(void))self_eq_activate_cb)();
	((void (*)(void))self_position_value_changed_cb)();
	((void (*)(void))self_volume_value_changed_cb)();
	((void (*)(void))self_position_button_press_cb)();
	((void (*)(void))self_position_button_release_cb)();
	((void (*)(void))self_cont_cb)();
	((void (*)(void))self_bright_cb)();
	((void (*)(void))self_hue_cb)();
	((void (*)(void))self_sat_cb)();
	((void (*)(void))self_mute_cb)();
	((void (*)(void))self_eq30_cb)();
	((void (*)(void))self_eq60_cb)();
	((void (*)(void))self_eq125_cb)();
	((void (*)(void))self_eq250_cb)();
	((void (*)(void))self_eq500_cb)();
	((void (*)(void))self_eq1000_cb)();
	((void (*)(void))self_eq2000_cb)();
	((void (*)(void))self_eq4000_cb)();
	((void (*)(void))self_eq8000_cb)();
	((void (*)(void))self_eq16000_cb)();
	___lum_player_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

