/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                   lum-session.gob  -  Lumiere Session Handling 
                             -------------------
    begin                : Tue nov 4 22:08:47 CET 2003
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.6 $
 * $Date: 2004/03/27 00:14:31 $
 *
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include "lum-session.h"

#include "lum-session-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
static const GEnumValue _lum_sessionresumetype_values[] = {
	{ SESSION_OK, "SESSION_OK", "ok" },
	{ SESSION_RESUMED, "SESSION_RESUMED", "resumed" },
	{ SESSION_ABORT, "SESSION_ABORT", "abort" },
	{ 0, NULL, NULL }
};

GType
lum_sessionresumetype_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumSessionResumeType", _lum_sessionresumetype_values);
	return type;
}

static const GEnumValue _lum_sessionrestoretype_values[] = {
	{ SESSION_RESTORE, "SESSION_RESTORE", "restore" },
	{ SESSION_DISCARD, "SESSION_DISCARD", "discard" },
	{ 0, NULL, NULL }
};

GType
lum_sessionrestoretype_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumSessionRestoreType", _lum_sessionrestoretype_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_SESSION(x)
#define SELF_CONST(x) LUM_SESSION_CONST(x)
#define IS_SELF(x) LUM_IS_SESSION(x)
#define TYPE_SELF LUM_TYPE_SESSION
#define SELF_CLASS(x) LUM_SESSION_CLASS(x)

#define SELF_GET_CLASS(x) LUM_SESSION_GET_CLASS(x)

/* self typedefs */
typedef LumSession Self;
typedef LumSessionClass SelfClass;

/* here are local prototypes */
static void lum_session_class_init (LumSessionClass * c) G_GNUC_UNUSED;
static void lum_session_init (LumSession * self) G_GNUC_UNUSED;
static void ___3_lum_session_dispose (GObject * object) G_GNUC_UNUSED;
static void ___4_lum_session_finalize (GObject * object) G_GNUC_UNUSED;
static gchar * lum_session_get_filename (const char * type) G_GNUC_UNUSED;
static void lum_session_delete (LumSession * self, const char * filename) G_GNUC_UNUSED;
static void lum_session_parse_xml (LumSession * self, const char * filename) G_GNUC_UNUSED;
static gboolean lum_session_save_yourself_cb (GnomeClient * client, gint phase, GnomeSaveStyle save_style, gboolean shutdown, GnomeInteractStyle interact_style, gboolean fast, Self * self) G_GNUC_UNUSED;
static void lum_session_die_cb (GnomeClient * client, Self * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new() lum_session_new()
#define self_load(args...) lum_session_load(args)
#define self_get_engines(args...) lum_session_get_engines(args)
#define self_add_engine(args...) lum_session_add_engine(args)
#define self_remove_engine(args...) lum_session_remove_engine(args)
#define self_autoresume(args...) lum_session_autoresume(args)
#define self_close(args...) lum_session_close(args)
#define self_save(args...) lum_session_save(args)
#define self_get_filename(args...) lum_session_get_filename(args)
#define self_delete(args...) lum_session_delete(args)
#define self_parse_xml(args...) lum_session_parse_xml(args)
#define self_save_yourself_cb(args...) lum_session_save_yourself_cb(args)
#define self_die_cb(args...) lum_session_die_cb(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static LumSession * (* const self_new) (void) = lum_session_new;
static void (* const self_load) (LumSession * self, const char * filename) = lum_session_load;
static GList * (* const self_get_engines) (LumSession * self) = lum_session_get_engines;
static void (* const self_add_engine) (LumSession * self, LumEngine * engine) = lum_session_add_engine;
static void (* const self_remove_engine) (LumSession * self, LumEngine * engine) = lum_session_remove_engine;
static LumSessionResumeType (* const self_autoresume) (LumSession * self) = lum_session_autoresume;
static void (* const self_close) (LumSession * self) = lum_session_close;
static void (* const self_save) (LumSession * self, const char * filename) = lum_session_save;
static gchar * (* const self_get_filename) (const char * type) = lum_session_get_filename;
static void (* const self_delete) (LumSession * self, const char * filename) = lum_session_delete;
static void (* const self_parse_xml) (LumSession * self, const char * filename) = lum_session_parse_xml;
static gboolean (* const self_save_yourself_cb) (GnomeClient * client, gint phase, GnomeSaveStyle save_style, gboolean shutdown, GnomeInteractStyle interact_style, gboolean fast, Self * self) = lum_session_save_yourself_cb;
static void (* const self_die_cb) (GnomeClient * client, Self * self) = lum_session_die_cb;

GType
lum_session_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumSessionClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_session_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumSession),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_session_init,
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumSession", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumSession *)g_object_new(lum_session_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumSession * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumSession *
GET_NEW_VARG (const char *first, ...)
{
	LumSession *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumSession *)g_object_new_valist (lum_session_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Session::finalize"
	LumSession *self = LUM_SESSION (obj_self);
	gpointer priv = self->_priv;
	___4_lum_session_finalize(obj_self);
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_session_class_init (LumSessionClass * c)
{
#define __GOB_FUNCTION__ "Lum:Session::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->dispose = ___3_lum_session_dispose;
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_session_init (LumSession * self)
{
#define __GOB_FUNCTION__ "Lum:Session::init"
	self->_priv = g_new0 (LumSessionPrivate, 1);
	self->_priv->engines = NULL;
	self->_priv->session_saved = FALSE;
	self->_priv->dont_remove_crashed = TRUE;
 {

		GnomeClient *client;
		char *dir;
	 	struct stat statbuf;

		client = gnome_master_client ();
	
		g_signal_connect (G_OBJECT (client), "save_yourself",
				G_CALLBACK (self_save_yourself_cb), self);
	
		g_signal_connect (G_OBJECT (client), "die",
				G_CALLBACK (self_die_cb), self);
		
		dir = g_build_filename (g_get_home_dir(), LUM_DIR, NULL);
		if (stat(dir, &statbuf) < 0)
			if (mkdir(dir, 488) != 0)
				g_error ("Couldn't mkdir ./lumiere");
		g_free(dir);
	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__



LumSession * 
lum_session_new (void)
{
#define __GOB_FUNCTION__ "Lum:Session::new"
{
		return GET_NEW; }}
#undef __GOB_FUNCTION__

static void 
___3_lum_session_dispose (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Session::dispose"
	g_return_if_fail (object != NULL);
	g_return_if_fail (G_IS_OBJECT (object));
{
	
		Self *self = SELF(object);
#ifdef DEBUG
		printf(__FILE__ ": in dispose\n");
#endif
		if (!selfp->dont_remove_crashed)
			self_delete(self, SESSION_CRASHED);

		if (!selfp->session_saved)
			self_delete(self, SESSION_SAVED);

		PARENT_HANDLER(object);
#ifdef DEBUG
		printf(__FILE__ ": disposed\n");
#endif
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___4_lum_session_finalize (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Session::finalize"
	g_return_if_fail (object != NULL);
{
	
#ifdef DEBUG
		printf(__FILE__ ": finalize\n");
#endif
		Self *self = SELF(object);
		GList *list = selfp->engines;

		for( ; list != NULL; list = list->next)
			g_object_unref(G_OBJECT(list->data));
		g_list_free(selfp->engines);
		PARENT_HANDLER(object);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

void 
lum_session_load (LumSession * self, const char * filename)
{
#define __GOB_FUNCTION__ "Lum:Session::load"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SESSION (self));
	g_return_if_fail (filename != NULL);
{
		self_parse_xml(self, filename); }}
#undef __GOB_FUNCTION__

GList * 
lum_session_get_engines (LumSession * self)
{
#define __GOB_FUNCTION__ "Lum:Session::get_engines"
	g_return_val_if_fail (self != NULL, (GList * )0);
	g_return_val_if_fail (LUM_IS_SESSION (self), (GList * )0);
{
		return selfp->engines; }}
#undef __GOB_FUNCTION__

void 
lum_session_add_engine (LumSession * self, LumEngine * engine)
{
#define __GOB_FUNCTION__ "Lum:Session::add_engine"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SESSION (self));
	g_return_if_fail (engine != NULL);
	g_return_if_fail (LUM_IS_ENGINE (engine));
{
	
		selfp->engines = g_list_append(selfp->engines, engine);
		lum_shell_set_active_engine(lum_shell, engine);
	}}
#undef __GOB_FUNCTION__

void 
lum_session_remove_engine (LumSession * self, LumEngine * engine)
{
#define __GOB_FUNCTION__ "Lum:Session::remove_engine"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SESSION (self));
	g_return_if_fail (engine != NULL);
	g_return_if_fail (LUM_IS_ENGINE (engine));
{
	
		if(g_list_length(selfp->engines) == 1 && !selfp->session_saved){
			self_save(self, SESSION_SAVED);
			selfp->session_saved = TRUE;
		}
		selfp->engines = g_list_remove (selfp->engines, engine);
	}}
#undef __GOB_FUNCTION__

LumSessionResumeType 
lum_session_autoresume (LumSession * self)
{
#define __GOB_FUNCTION__ "Lum:Session::autoresume"
	g_return_val_if_fail (self != NULL, (LumSessionResumeType )0);
	g_return_val_if_fail (LUM_IS_SESSION (self), (LumSessionResumeType )0);
{
	
		char *saved_session;
		gboolean loaded = FALSE;

		saved_session = self_get_filename(SESSION_CRASHED);

		if (g_file_test (saved_session, G_FILE_TEST_EXISTS))
			loaded = TRUE;

		g_free (saved_session);

		saved_session = self_get_filename (SESSION_SAVED);

		if (g_file_test (saved_session, G_FILE_TEST_EXISTS) && !loaded)
		/*TODO add this to the config
		 * && eel_gconf_get_boolean (CONF_GENERAL_ALWAYS_SAVE_SESSION))
		 */
			self_load (self, saved_session);

		g_free (saved_session);

		return (selfp->engines != NULL) ? SESSION_RESUMED : SESSION_OK;
	}}
#undef __GOB_FUNCTION__

void 
lum_session_close (LumSession * self)
{
#define __GOB_FUNCTION__ "Lum:Session::close"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SESSION (self));
{
	
#ifdef DEBUG
		printf(__FILE__ ": close\n");
#endif
		GList *l, *engines;
		self_save (self, SESSION_SAVED);
		selfp->session_saved = TRUE;

		engines = g_list_copy (selfp->engines);
		for (l = engines; l != NULL; l = l->next) {
#ifdef DEBUG
			printf(__FILE__ ": calling g_object_unref(LumEngine*)\n");
#endif
			g_object_unref(G_OBJECT(l->data));
		}
		g_list_free(engines);
	}}
#undef __GOB_FUNCTION__

void 
lum_session_save (LumSession * self, const char * filename)
{
#define __GOB_FUNCTION__ "Lum:Session::save"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SESSION (self));
	g_return_if_fail (filename != NULL);
{
	
#ifdef DEBUG
		printf(__FILE__ ": save\n");
#endif
		GList *e;
		xmlNodePtr root_node, engine_node;
		xmlDocPtr doc;
		gchar buffer[32];
		char *save_to;

		save_to = self_get_filename (filename);
		doc = xmlNewDoc ("1.0");

		root_node = xmlNewDocNode (doc, NULL, "session", NULL);
		xmlDocSetRootElement (doc, root_node);

		for (e = selfp->engines; e != NULL; e = e->next) {
#ifdef DEBUG
			printf(__FILE__ ": doing engine save\n");
#endif
			GList *uris, *l;
			int x = 0, y = 0;
			gboolean shaded;
			LumEngine *engine = LUM_ENGINE(e->data);

			uris = lum_engine_get_list (engine);
			engine_node = xmlNewDocNode (doc, NULL, "engine", NULL);

			gtk_window_get_position (lum_engine_get_skin(engine), &x, &y);

			snprintf(buffer, 32, "%d", x);
			xmlSetProp (engine_node, "x", buffer);
			snprintf(buffer, 32, "%d", y);
			xmlSetProp (engine_node, "y", buffer);
			shaded  = lum_skin_get_shaded(
					LUM_SKIN(lum_engine_get_skin(engine)));
			snprintf(buffer, 32, "%d", shaded);
			xmlSetProp (engine_node, "shaded", buffer);
			shaded  = lum_skin_get_always_on_top(
						LUM_SKIN(lum_engine_get_skin(engine)));
			snprintf(buffer, 32, "%d", shaded);
			xmlSetProp (engine_node, "always_on_top", buffer);

			for (l = uris; l != NULL; l = l->next) {
	   			gchar *uri = (gchar *) l->data;
				xmlNodePtr playlist_node;
				playlist_node = xmlNewDocNode (doc, NULL, "playlist", NULL);
				xmlSetProp (playlist_node, "uri", g_strdup(uri));
				xmlAddChild (engine_node, playlist_node);
			}
			/*TODO shall we free this? */
			//if(uris)
			//	for (l = uris; l != NULL; l = l->next)
			//		if(l->data) g_free(l->data);
			//	g_list_free (uris);
			xmlAddChild (root_node, engine_node);
		}

  		xmlSaveFile(save_to, doc);
  		xmlFreeDoc(doc);
		g_free(save_to);
	}}
#undef __GOB_FUNCTION__

static gchar * 
lum_session_get_filename (const char * type)
{
#define __GOB_FUNCTION__ "Lum:Session::get_filename"
	g_return_val_if_fail (type != NULL, (gchar * )NULL);
{
	
		char *save_to;

		if (strcmp (type, SESSION_SAVED) == 0){
			save_to = g_build_filename (g_get_home_dir (), LUM_DIR,
					    "session_saved.xml", NULL);
		} else if (strcmp (type, SESSION_CRASHED) == 0) {
			save_to = g_build_filename (g_get_home_dir (), LUM_DIR,
					    "session_crashed.xml", NULL);
		} else if (strcmp (type, SESSION_GNOME) == 0) {
			char *tmp;
		
			save_to = g_build_filename (g_get_home_dir (), LUM_DIR,
					    "session_gnome-XXXXXX", NULL);
			tmp = lum_util_general_tmp_filename (save_to, "xml");
			g_free (save_to);
			save_to = tmp;
		} else {
			save_to = g_strdup (type);
		}
		return save_to;
	}}
#undef __GOB_FUNCTION__

static void 
lum_session_delete (LumSession * self, const char * filename)
{
#define __GOB_FUNCTION__ "Lum:Session::delete"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SESSION (self));
{
	
		char *save_to;
		save_to = self_get_filename (filename);
		gnome_vfs_unlink (save_to);
		g_free (save_to);
	}}
#undef __GOB_FUNCTION__

static void 
lum_session_parse_xml (LumSession * self, const char * filename)
{
#define __GOB_FUNCTION__ "Lum:Session::parse_xml"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SESSION (self));
	g_return_if_fail (filename != NULL);
{
	
		xmlDocPtr doc;
		xmlNodePtr child;
		char *save_to;
	
		save_to = self_get_filename (filename);
		doc = xmlParseFile (save_to);

		child = xmlDocGetRootElement (doc);
		child = child->children;
	
		for( ; child != NULL; child = child->next) {
			if (strcmp (child->name, "engine") == 0) {
				xmlNodePtr child2;
				LumEngine *engine;
				gint x = 0, y = 0;
				gboolean boolean;

				x = lum_util_xmlGetIntProp (child, "x");
				y = lum_util_xmlGetIntProp (child, "y");
				boolean = lum_util_xmlGetIntProp (child, "shaded");
				child2 = child->children;
				engine = lum_engine_new ();

				gtk_window_move (lum_engine_get_skin(engine), x, y);
				lum_skin_set_shaded(LUM_SKIN(lum_engine_get_skin(engine)),
						boolean);
				boolean = lum_util_xmlGetIntProp (child, "always_on_top");
				lum_skin_set_always_on_top(
						LUM_SKIN(lum_engine_get_skin(engine)),
						boolean);

				for( ; child2 != NULL; child2 = child2->next) {
					if (strcmp (child2->name, "playlist") == 0) {
						char *uri;
						uri = xmlGetProp (child2, "uri");
						lum_engine_enqueue(engine, g_strdup(uri));
						xmlFree (uri);
					}
				}
			}
		}
		xmlFreeDoc (doc);
		g_free (save_to);
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_session_save_yourself_cb (GnomeClient * client, gint phase, GnomeSaveStyle save_style, gboolean shutdown, GnomeInteractStyle interact_style, gboolean fast, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Session::save_yourself_cb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (IS_SELF (self), (gboolean )0);
{
	
		char *argv[] = { "lumiere", "--load-session", NULL, NULL };
		char *discard_argv[] = { "rm", "-r", NULL };
	
		argv[2] = self_get_filename (SESSION_GNOME);
		if(lum_shell_get_server_mode(lum_shell)){
			argv[3] = "-s";
			gnome_client_set_restart_command (client, 4, argv);
		} else
			gnome_client_set_restart_command (client, 3, argv);
     
		discard_argv[2] = argv[2];
		gnome_client_set_discard_command(client, 3, discard_argv);
			
		self_save (self, argv[2]);
		g_free (argv[2]);
		return TRUE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_session_die_cb (GnomeClient * client, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Session::die_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
#ifdef DEBUG
		printf(__FILE__ ": die_cb\n");
#endif
		g_object_ref (lum_shell);
		self_close (self);
		lum_shell_set_server_mode (lum_shell, FALSE);
		g_object_unref (lum_shell);
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_session_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	((void (*)(void))self_load)();
	((void (*)(void))self_get_engines)();
	((void (*)(void))self_add_engine)();
	((void (*)(void))self_remove_engine)();
	((void (*)(void))self_autoresume)();
	((void (*)(void))self_close)();
	((void (*)(void))self_save)();
	((void (*)(void))self_get_filename)();
	((void (*)(void))self_delete)();
	((void (*)(void))self_parse_xml)();
	((void (*)(void))self_save_yourself_cb)();
	((void (*)(void))self_die_cb)();
	___lum_session_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

