/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                        lum-shell.gob  -  Lumiere Main Class 
                             -------------------
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.6 $
 * $Date: 2004/03/27 00:14:31 $
 *
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-shell.h"

#include "lum-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */


/* drag'n drop target table, basically anything can be dragged */
static const GtkTargetEntry target_table [] =
{
	{ "STRING",        0, TARGET_STRING },
	{ "text/plain",    0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
};


static const GEnumValue _lum_shell_xf86audio_values[] = {
	{ XF86AUDIO_PLAY, "XF86AUDIO_PLAY", "play" },
	{ XF86AUDIO_PAUSE, "XF86AUDIO_PAUSE", "pause" },
	{ XF86AUDIO_STOP, "XF86AUDIO_STOP", "stop" },
	{ XF86AUDIO_NEXT, "XF86AUDIO_NEXT", "next" },
	{ XF86AUDIO_PREV, "XF86AUDIO_PREV", "prev" },
	{ XF86AUDIO_RAISEVOLUME, "XF86AUDIO_RAISEVOLUME", "raisevolume" },
	{ XF86AUDIO_LOWERVOLUME, "XF86AUDIO_LOWERVOLUME", "lowervolume" },
	{ XF86AUDIO_MUTE, "XF86AUDIO_MUTE", "mute" },
	{ XF86AUDIO_MEDIA, "XF86AUDIO_MEDIA", "media" },
	{ XF86AUDIO_MAX, "XF86AUDIO_MAX", "max" },
	{ 0, NULL, NULL }
};

GType
lum_shell_xf86audio_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumShellXF86Audio", _lum_shell_xf86audio_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_SHELL(x)
#define SELF_CONST(x) LUM_SHELL_CONST(x)
#define IS_SELF(x) LUM_IS_SHELL(x)
#define TYPE_SELF LUM_TYPE_SHELL
#define SELF_CLASS(x) LUM_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) LUM_SHELL_GET_CLASS(x)

/* self typedefs */
typedef LumShell Self;
typedef LumShellClass SelfClass;

/* here are local prototypes */
static void lum_shell_class_init (LumShellClass * class) G_GNUC_UNUSED;
static void lum_shell_init (LumShell * self) G_GNUC_UNUSED;
static void ___4_lum_shell_dispose (GObject * object) G_GNUC_UNUSED;
static GdkFilterReturn lum_shell_xf86audio_filter (GdkXEvent * xevent, GdkEvent * event, gpointer data) G_GNUC_UNUSED;
static KeyCode lum_shell_grab_key (char * keystring) G_GNUC_UNUSED;
static void lum_shell_grab_keys (LumShell * self) G_GNUC_UNUSED;
static void lum_shell_ungrab_key (KeyCode code) G_GNUC_UNUSED;
static void lum_shell_ungrab_keys (LumShell * self) G_GNUC_UNUSED;
static void lum_shell_init_tray (LumShell * self) G_GNUC_UNUSED;
static gboolean lum_shell_tray_destroyed (GtkWidget * widget, GdkEvent * event, Self * self) G_GNUC_UNUSED;
static void lum_shell_new_engine_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_close_engine_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_open_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_audio_cd_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_dvd_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_play_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_stop_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_next_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_prev_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static gboolean lum_shell_tray_icon_release_cb (GtkWidget * widget, GdkEventButton * event, Self * self) G_GNUC_UNUSED;
static gboolean lum_shell_tray_icon_press_cb (GtkWidget * widget, GdkEventButton * event, Self * self) G_GNUC_UNUSED;
static void lum_shell_drag_data_received_cb (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, gpointer user_data) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new() lum_shell_new()
#define self_new_engine(args...) lum_shell_new_engine(args)
#define self_get_active_engine(args...) lum_shell_get_active_engine(args)
#define self_set_active_engine(args...) lum_shell_set_active_engine(args)
#define self_get_session(args...) lum_shell_get_session(args)
#define self_get_config(args...) lum_shell_get_config(args)
#define self_get_server_mode(args...) lum_shell_get_server_mode(args)
#define self_set_server_mode(args...) lum_shell_set_server_mode(args)
#define self_get_tray_icon(args...) lum_shell_get_tray_icon(args)
#define self_set_tray_icon(args...) lum_shell_set_tray_icon(args)
#define self_show_prefs(args...) lum_shell_show_prefs(args)
#define self_show_about(args...) lum_shell_show_about(args)
#define self_set_tip(args...) lum_shell_set_tip(args)
#define self_xf86audio_filter(args...) lum_shell_xf86audio_filter(args)
#define self_grab_key(args...) lum_shell_grab_key(args)
#define self_grab_keys(args...) lum_shell_grab_keys(args)
#define self_ungrab_key(args...) lum_shell_ungrab_key(args)
#define self_ungrab_keys(args...) lum_shell_ungrab_keys(args)
#define self_init_tray(args...) lum_shell_init_tray(args)
#define self_tray_destroyed(args...) lum_shell_tray_destroyed(args)
#define self_prefs_activate_cb(args...) lum_shell_prefs_activate_cb(args)
#define self_about_activate_cb(args...) lum_shell_about_activate_cb(args)
#define self_help_activate_cb(args...) lum_shell_help_activate_cb(args)
#define self_quit_activate_cb(args...) lum_shell_quit_activate_cb(args)
#define self_new_engine_activate_cb(args...) lum_shell_new_engine_activate_cb(args)
#define self_close_engine_activate_cb(args...) lum_shell_close_engine_activate_cb(args)
#define self_open_activate_cb(args...) lum_shell_open_activate_cb(args)
#define self_audio_cd_activate_cb(args...) lum_shell_audio_cd_activate_cb(args)
#define self_dvd_activate_cb(args...) lum_shell_dvd_activate_cb(args)
#define self_play_activate_cb(args...) lum_shell_play_activate_cb(args)
#define self_stop_activate_cb(args...) lum_shell_stop_activate_cb(args)
#define self_next_activate_cb(args...) lum_shell_next_activate_cb(args)
#define self_prev_activate_cb(args...) lum_shell_prev_activate_cb(args)
#define self_tray_icon_release_cb(args...) lum_shell_tray_icon_release_cb(args)
#define self_tray_icon_press_cb(args...) lum_shell_tray_icon_press_cb(args)
#define self_drag_data_received_cb(args...) lum_shell_drag_data_received_cb(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static LumShell * (* const self_new) (void) = lum_shell_new;
static void (* const self_new_engine) (LumShell * self, const char * uri) = lum_shell_new_engine;
static LumEngine * (* const self_get_active_engine) (LumShell * self) = lum_shell_get_active_engine;
static void (* const self_set_active_engine) (LumShell * self, LumEngine * engine) = lum_shell_set_active_engine;
static LumSession * (* const self_get_session) (LumShell * self) = lum_shell_get_session;
static LumConfig * (* const self_get_config) (LumShell * self) = lum_shell_get_config;
static gboolean (* const self_get_server_mode) (LumShell * self) = lum_shell_get_server_mode;
static void (* const self_set_server_mode) (LumShell * self, gboolean mode) = lum_shell_set_server_mode;
static gboolean (* const self_get_tray_icon) (LumShell * self) = lum_shell_get_tray_icon;
static void (* const self_set_tray_icon) (LumShell * self, gboolean mode) = lum_shell_set_tray_icon;
static void (* const self_show_prefs) (LumShell * self) = lum_shell_show_prefs;
static void (* const self_show_about) (LumShell * self) = lum_shell_show_about;
static void (* const self_set_tip) (LumShell * self, const char * tip) = lum_shell_set_tip;
static GdkFilterReturn (* const self_xf86audio_filter) (GdkXEvent * xevent, GdkEvent * event, gpointer data) = lum_shell_xf86audio_filter;
static KeyCode (* const self_grab_key) (char * keystring) = lum_shell_grab_key;
static void (* const self_grab_keys) (LumShell * self) = lum_shell_grab_keys;
static void (* const self_ungrab_key) (KeyCode code) = lum_shell_ungrab_key;
static void (* const self_ungrab_keys) (LumShell * self) = lum_shell_ungrab_keys;
static void (* const self_init_tray) (LumShell * self) = lum_shell_init_tray;
static gboolean (* const self_tray_destroyed) (GtkWidget * widget, GdkEvent * event, Self * self) = lum_shell_tray_destroyed;
static void (* const self_prefs_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_prefs_activate_cb;
static void (* const self_about_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_about_activate_cb;
static void (* const self_help_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_help_activate_cb;
static void (* const self_quit_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_quit_activate_cb;
static void (* const self_new_engine_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_new_engine_activate_cb;
static void (* const self_close_engine_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_close_engine_activate_cb;
static void (* const self_open_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_open_activate_cb;
static void (* const self_audio_cd_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_audio_cd_activate_cb;
static void (* const self_dvd_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_dvd_activate_cb;
static void (* const self_play_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_play_activate_cb;
static void (* const self_stop_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_stop_activate_cb;
static void (* const self_next_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_next_activate_cb;
static void (* const self_prev_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_shell_prev_activate_cb;
static gboolean (* const self_tray_icon_release_cb) (GtkWidget * widget, GdkEventButton * event, Self * self) = lum_shell_tray_icon_release_cb;
static gboolean (* const self_tray_icon_press_cb) (GtkWidget * widget, GdkEventButton * event, Self * self) = lum_shell_tray_icon_press_cb;
static void (* const self_drag_data_received_cb) (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, gpointer user_data) = lum_shell_drag_data_received_cb;

GType
lum_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_shell_init,
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumShell *)g_object_new(lum_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumShell *
GET_NEW_VARG (const char *first, ...)
{
	LumShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumShell *)g_object_new_valist (lum_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Shell::dispose"
	LumShell *self = LUM_SHELL (obj_self);
	___4_lum_shell_dispose(obj_self);
	if(self->_priv->session) { ((*(void (*)(void *))g_object_unref)) (self->_priv->session); self->_priv->session = NULL; }
	if(self->_priv->config) { ((*(void (*)(void *))g_object_unref)) (self->_priv->config); self->_priv->config = NULL; }
	if(self->_priv->automation_factory) { ((*(void (*)(void *))bonobo_object_unref)) (self->_priv->automation_factory); self->_priv->automation_factory = NULL; }
	if(self->_priv->control_factory) { ((*(void (*)(void *))bonobo_object_unref)) (self->_priv->control_factory); self->_priv->control_factory = NULL; }
	if(self->_priv->context_factory) { ((*(void (*)(void *))bonobo_object_unref)) (self->_priv->context_factory); self->_priv->context_factory = NULL; }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Shell::finalize"
	LumShell *self = LUM_SHELL (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	if(self->_priv->tray_icon) { ((*(void (*)(void *))gtk_widget_destroy)) (self->_priv->tray_icon); self->_priv->tray_icon = NULL; }
	if(self->_priv->popup_menu) { ((*(void (*)(void *))gtk_widget_destroy)) (self->_priv->popup_menu); self->_priv->popup_menu = NULL; }
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_shell_class_init (LumShellClass * class)
{
#define __GOB_FUNCTION__ "Lum:Shell::class_init"
	GObjectClass *g_object_class = (GObjectClass*) class;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
 {

		 if(!gnome_vfs_application_registry_exists("lumiere")){
		 	gnome_vfs_application_registry_set_value("lumiere", "command",
					PREFIX"/bin/lumiere");
			gnome_vfs_application_registry_set_value("lumiere", "name",
					"Lumiere");
			gnome_vfs_application_registry_set_value("lumiere",
					"can_open_multiple_files", "true");
			gnome_vfs_application_registry_set_value("lumiere",
					"requires_terminal", "false");
			gnome_vfs_application_registry_set_value("lumiere",
					"expects_uris", "yes");
			gnome_vfs_application_registry_set_value("lumiere",
					"all_gnome_vfs_schemes_supported", "yes");
			gnome_vfs_application_registry_set_value("lumiere",
					"startup_notify", "true");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"audio/*");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"video/*");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"x-directory/normal");
			gnome_vfs_application_registry_sync();
		 }
	
 }
	return;
	class = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_shell_init (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::init"
	self->_priv = g_new0 (LumShellPrivate, 1);
	self->_priv->session = NULL;
	self->_priv->config = NULL;
	self->_priv->active_engine = NULL;
	self->_priv->tray_icon = NULL;
	self->_priv->tray_icon_tooltip = gtk_tooltips_new ();
	self->_priv->popup_menu = NULL;
	self->_priv->automation_factory = NULL;
	self->_priv->control_factory = NULL;
	self->_priv->context_factory = NULL;
	self->_priv->server_mode = FALSE;
 {

		lum_shell = self;
		g_object_add_weak_pointer (G_OBJECT(lum_shell),
				(gpointer *)&lum_shell);

		self_grab_keys(self);
		selfp->config = lum_config_new ();
		g_object_add_weak_pointer(G_OBJECT(selfp->config),
				(gpointer *)&selfp->config);
		self_set_server_mode(self, selfp->config->server_mode);
		self_set_tray_icon(self, selfp->config->tray_icon);
		
		selfp->automation_factory = lum_automation_factory_new();
		selfp->control_factory = lum_control_factory_new();
		selfp->context_factory = lum_context_factory_new();
		if(!selfp->automation_factory || !selfp->control_factory ||
			    	!selfp->context_factory) {
			GtkWidget *dialog = hig_alert_new (NULL,
					GTK_DIALOG_MODAL,
					HIG_ALERT_ERROR,
					_("Lumiere failed to start."),				
					NULL,
					GTK_STOCK_OK,
					GTK_RESPONSE_OK,
					NULL);
			char * text = g_strdup_printf (
					_("Bonobo couldn't locate the file %s or %s or %s."),
					"<tt>\"GNOME_Lum_Automation.server\"</tt>",
					"<tt>\"GNOME_Lum_Control.server\"</tt>",
					"<tt>\"GNOME_Lum_Contextmenu.server\"</tt>");
			hig_alert_set_secondary_printf (
					HIG_ALERT (dialog), "%s\n\n%s", text,
    					_("Usually this is an indication of an incomplete installation. "
					"See the INSTALL document for more details."));
			g_free (text);
			gtk_dialog_run (GTK_DIALOG (dialog));
			exit (EXIT_FAILURE);
		}
		selfp->session = lum_session_new ();
		g_object_add_weak_pointer (G_OBJECT(selfp->session),
				(gpointer *)&selfp->session);
	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__



LumShell * 
lum_shell_new (void)
{
#define __GOB_FUNCTION__ "Lum:Shell::new"
{
		return GET_NEW; }}
#undef __GOB_FUNCTION__

static void 
___4_lum_shell_dispose (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Shell::dispose"
	g_return_if_fail (object != NULL);
{
	
#ifdef DEBUG
		printf(__FILE__ ": dispose\n");
#endif
		Self *self = SELF(object);

		if(selfp->session) {
			if(LUM_IS_SESSION(selfp->session))
				g_object_remove_weak_pointer(
					G_OBJECT(selfp->session),
					(gpointer *) &selfp->session);
		}
		if(selfp->config) {
			if(LUM_IS_CONFIG(selfp->config))
				g_object_remove_weak_pointer(
					G_OBJECT(selfp->config),
					(gpointer *) &selfp->config);
		}
		self_ungrab_keys(self);
		PARENT_HANDLER(object);
		GtkXineClass *gxclass;
		if((gxclass = GTK_XINE_CLASS(
					g_type_class_peek(gtk_xine_get_type()))) != NULL)
			xine_exit(gxclass->xine);
#ifdef DEBUG
		printf(__FILE__ ": disposed\n");
#endif
		bonobo_main_quit ();
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

void 
lum_shell_new_engine (LumShell * self, const char * uri)
{
#define __GOB_FUNCTION__ "Lum:Shell::new_engine"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
	g_return_if_fail (uri != NULL);
{
	
		LumEngine *engine = lum_engine_new();

		if(!*uri == '\0')
			lum_engine_load_uri(engine, uri);
	}}
#undef __GOB_FUNCTION__

LumEngine * 
lum_shell_get_active_engine (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::get_active_engine"
	g_return_val_if_fail (self != NULL, (LumEngine * )0);
	g_return_val_if_fail (LUM_IS_SHELL (self), (LumEngine * )0);
{
	
		GList *engines;

		engines = lum_session_get_engines(selfp->session);

		if (engines && !g_list_find(engines, selfp->active_engine))
			selfp->active_engine = LUM_ENGINE(engines->data);
		else if(engines == NULL)
			selfp->active_engine = NULL;
		return selfp->active_engine;
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_set_active_engine (LumShell * self, LumEngine * engine)
{
#define __GOB_FUNCTION__ "Lum:Shell::set_active_engine"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
	g_return_if_fail (engine != NULL);
	g_return_if_fail (LUM_IS_ENGINE (engine));
{
		selfp->active_engine = engine; }}
#undef __GOB_FUNCTION__

LumSession * 
lum_shell_get_session (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::get_session"
	g_return_val_if_fail (self != NULL, (LumSession * )0);
	g_return_val_if_fail (LUM_IS_SHELL (self), (LumSession * )0);
{
	
		if(!selfp->session) {
			selfp->session = lum_session_new ();
			g_object_add_weak_pointer 
				(G_OBJECT(selfp->session),
				(gpointer *)&selfp->session);
		}
		return selfp->session;
	}}
#undef __GOB_FUNCTION__

LumConfig * 
lum_shell_get_config (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::get_config"
	g_return_val_if_fail (self != NULL, (LumConfig * )0);
	g_return_val_if_fail (LUM_IS_SHELL (self), (LumConfig * )0);
{
	
		if(!selfp->config) {
			selfp->config = lum_config_new ();
			g_object_add_weak_pointer 
				(G_OBJECT(selfp->config),
				(gpointer *)&selfp->config);
		}
		return selfp->config;
	}}
#undef __GOB_FUNCTION__

gboolean 
lum_shell_get_server_mode (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::get_server_mode"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_SHELL (self), (gboolean )0);
{
	
#ifdef DEBUG
		printf(__FILE__ ": get server mode = %s\n",
				selfp->server_mode ? "TRUE" : "FALSE");
#endif
		return selfp->server_mode;
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_set_server_mode (LumShell * self, gboolean mode)
{
#define __GOB_FUNCTION__ "Lum:Shell::set_server_mode"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
{
	
		if(mode == selfp->server_mode)
			return;
		
		if (mode && !selfp->server_mode)
			g_object_ref (G_OBJECT(self));

		else if (!mode && selfp->server_mode)
			g_object_unref (G_OBJECT(self));

		selfp->server_mode = mode;
#ifdef DEBUG
		printf(__FILE__": set server mode = %s\n",
				selfp->server_mode ? "TRUE" : "FALSE");
#endif
	}}
#undef __GOB_FUNCTION__

gboolean 
lum_shell_get_tray_icon (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::get_tray_icon"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_SHELL (self), (gboolean )0);
{
	
		return TRUE;
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_set_tray_icon (LumShell * self, gboolean mode)
{
#define __GOB_FUNCTION__ "Lum:Shell::set_tray_icon"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
{
	
		if(mode && selfp->tray_icon)
			return;
		else if(!mode && !selfp->tray_icon)
			return;
		
		if (mode && !selfp->tray_icon)
			self_init_tray(self);

		else if (!mode && selfp->tray_icon){
			gtk_widget_destroy(GTK_WIDGET(selfp->tray_icon));
			selfp->tray_icon = NULL;
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_show_prefs (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::show_prefs"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
{
		lum_prefs_show(); }}
#undef __GOB_FUNCTION__

void 
lum_shell_show_about (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::show_about"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
{
	
		static GtkWidget *about;
		static const char *authors[] = {
			NULL,
			NULL
		};
		
		const char *translator_credits;

		if (!about) {
			GdkPixbuf *pixbuf;
			pixbuf = gdk_pixbuf_new_from_file(
					DATADIR"/lumiere/lumiere-logo.png",
					NULL); 
			authors[0] = _("Stephane Konstantaropoulos"),

			translator_credits = _("Translator Credits");
			
			about = gnome_about_new (
					"Lumiere",
					VERSION,
					_("Copyright (C) 2004 Stephane Konstantaropoulos"),
					_("A media player for GNOME 2"),
					authors,
					NULL, /* char **documenters */
					translator_credits,
					pixbuf);
			g_signal_connect (about, "destroy",
					G_CALLBACK (gtk_widget_destroyed),
					&about);
		}
		gtk_widget_show_now(about);
		g_assert (GTK_WIDGET_REALIZED(about));
		gdk_window_show (about->window);
		gtk_widget_grab_focus(about);
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_set_tip (LumShell * self, const char * tip)
{
#define __GOB_FUNCTION__ "Lum:Shell::set_tip"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
{
	
		if(selfp->tray_icon){
			gtk_tooltips_set_tip (selfp->tray_icon_tooltip,
				GTK_WIDGET (selfp->tray_icon),
				tip ? tip : _("Lumiere Server Active"), NULL);
		}
	}}
#undef __GOB_FUNCTION__

static GdkFilterReturn 
lum_shell_xf86audio_filter (GdkXEvent * xevent, GdkEvent * event, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::xf86audio_filter"
{
	
		Self *self = lum_shell;
		LumEngine *engine = NULL;
		XEvent *xev = (XEvent *)xevent;
		XKeyEvent *keyevent = (XKeyEvent *)xevent;
		KeyCode *k = (KeyCode *)data;
		gint i;
	
		if (xev->type != KeyRelease)
			return GDK_FILTER_CONTINUE;

		for (i=0; i<XF86AUDIO_MAX; i++) {
			if (k[i] == keyevent->keycode)
				break;
		}
		if (i == XF86AUDIO_MAX) {
			g_warning("Received KeyRelease event for unrequested keycode %d", keyevent->keycode);
			return GDK_FILTER_CONTINUE;
		}
		engine = self_get_active_engine(self);

		if(!engine){
			if(i == XF86AUDIO_MEDIA)
				lum_engine_show_fileselector(lum_engine_new());
			return GDK_FILTER_CONTINUE;
		}
	
		switch (i) {
		case XF86AUDIO_PLAY:
			lum_engine_play(engine);
			break;
		case XF86AUDIO_STOP:
			lum_engine_stop(engine);
			break;
		case XF86AUDIO_PREV:
			lum_engine_prev(engine);
			break;
		case XF86AUDIO_NEXT:
			lum_engine_next(engine);
			break;
		case XF86AUDIO_PAUSE:
			lum_engine_pause(engine);
			break;
		case XF86AUDIO_RAISEVOLUME:
			lum_engine_inc_vol(engine);
			break;
		case XF86AUDIO_LOWERVOLUME:
			lum_engine_dec_vol(engine);
			break;
		case XF86AUDIO_MUTE:
			lum_engine_mute(engine);
			break;
		case XF86AUDIO_MEDIA:
			lum_engine_show_fileselector(engine);
			break;
		default: return GDK_FILTER_CONTINUE;
		}
		return GDK_FILTER_REMOVE;
	}}
#undef __GOB_FUNCTION__

static KeyCode 
lum_shell_grab_key (char * keystring)
{
#define __GOB_FUNCTION__ "Lum:Shell::grab_key"
{
	
		KeySym sym;
		KeyCode code;

		sym = XStringToKeysym(keystring);
		if (sym == NoSymbol)
			return 0;
		if ((code = XKeysymToKeycode(GDK_DISPLAY(), sym)) == 0)
			return 0;

		gdk_error_trap_push();
		XGrabKey(GDK_DISPLAY(), code,
				AnyModifier, GDK_ROOT_WINDOW(),
				1, GrabModeAsync, GrabModeAsync);
		gdk_flush();
		if (gdk_error_trap_pop()) {
			g_warning("Couldn't grab %s: another client may already have done so",
				keystring);
			return 0;
		}
		return code;
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_grab_keys (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::grab_keys"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
{
	
		KeyCode code;
	
		if ((code = self_grab_key("XF86AudioNext")) != 0)
			selfp->map[XF86AUDIO_NEXT] = code;
		if ((code = self_grab_key("XF86AudioPrev")) != 0)
			selfp->map[XF86AUDIO_PREV] = code;
		if ((code = self_grab_key("XF86AudioPlay")) != 0)
			selfp->map[XF86AUDIO_PLAY] = code;
		if ((code = self_grab_key("XF86AudioStop")) != 0)
			selfp->map[XF86AUDIO_STOP] = code;
		if ((code = self_grab_key("XF86AudioPause")) != 0)
			selfp->map[XF86AUDIO_PAUSE] = code;
		if ((code = self_grab_key("XF86AudioRaiseVolume")) != 0)
			selfp->map[XF86AUDIO_RAISEVOLUME] = code;
		if ((code = self_grab_key("XF86AudioLowerVolume")) != 0)
			selfp->map[XF86AUDIO_LOWERVOLUME] = code;
		if ((code = self_grab_key("XF86AudioMute")) != 0)
			selfp->map[XF86AUDIO_MUTE] = code;
		if ((code = self_grab_key("XF86AudioMedia")) != 0)
			selfp->map[XF86AUDIO_MEDIA] = code;

		gdk_window_add_filter(gdk_get_default_root_window (),
				self_xf86audio_filter, selfp->map);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_ungrab_key (KeyCode code)
{
#define __GOB_FUNCTION__ "Lum:Shell::ungrab_key"
{
	
		XUngrabKey(GDK_DISPLAY(), code,
			AnyModifier, GDK_ROOT_WINDOW());
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_ungrab_keys (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::ungrab_keys"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
{
	
		int i;

		for (i = 0; i < XF86AUDIO_MAX; i++) {
			if (selfp->map[i] != 0)
				self_ungrab_key(selfp->map[i]);
		}
		gdk_window_remove_filter(gdk_get_default_root_window (),
				self_xf86audio_filter, selfp->map);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_init_tray (LumShell * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::init_tray"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_SHELL (self));
{
	
		GtkWidget *image, *evbox;
		GladeXML *xml;
		
		selfp->tray_icon = egg_tray_icon_new("Lumiere");
		image = gtk_image_new_from_file (
				DATADIR"/lumiere/lumiere-tray-16.png");
		gtk_tooltips_set_tip (selfp->tray_icon_tooltip,
			GTK_WIDGET (selfp->tray_icon),
			_("Lumiere Server Active"), NULL);
		
		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"tray_menu", GETTEXT_PACKAGE);
		g_assert(xml != NULL);
		selfp->popup_menu = glade_xml_get_widget(xml, "tray_menu_menu");
		g_signal_connect(glade_xml_get_widget(xml, "prefs"),
			    "activate", G_CALLBACK(self_prefs_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "about"),
			    "activate", G_CALLBACK(self_about_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "quit"),
			    "activate", G_CALLBACK(self_quit_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "new_engine"),
			    "activate", G_CALLBACK(self_new_engine_activate_cb), self);
		g_signal_connect(selfp->close_engine_item = glade_xml_get_widget(
					xml, "close_engine"),
			    "activate", G_CALLBACK(self_close_engine_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "open"),
			    "activate", G_CALLBACK(self_open_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "audio_cd"),
			    "activate", G_CALLBACK(self_audio_cd_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "dvd"),
			    "activate", G_CALLBACK(self_dvd_activate_cb), self);
		g_signal_connect(selfp->play_item = glade_xml_get_widget(xml, "play"),
			    "activate", G_CALLBACK(self_play_activate_cb), self);
		g_signal_connect(selfp->stop_item = glade_xml_get_widget(xml, "stop"),
			    "activate", G_CALLBACK(self_stop_activate_cb), self);
		g_signal_connect(selfp->next_item = glade_xml_get_widget(xml, "next"),
			    "activate", G_CALLBACK(self_next_activate_cb), self);
		g_signal_connect(selfp->prev_item = glade_xml_get_widget(xml, "prev"),
			    "activate", G_CALLBACK(self_prev_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "help"),
			    "activate", G_CALLBACK(self_help_activate_cb), self);
		g_object_unref(G_OBJECT(xml));

		evbox = gtk_event_box_new ();
		g_signal_connect (G_OBJECT (evbox), "button_press_event",
			G_CALLBACK (self_tray_icon_press_cb), (gpointer) self);
		g_signal_connect (G_OBJECT (evbox), "button_release_event",
			G_CALLBACK (self_tray_icon_release_cb), (gpointer) self);
		gtk_container_add (GTK_CONTAINER (evbox), image);
		gtk_container_add (GTK_CONTAINER (selfp->tray_icon), evbox);
		gtk_widget_show_all (GTK_WIDGET(selfp->tray_icon));
		g_signal_connect (G_OBJECT (selfp->tray_icon), "destroy-event",
			G_CALLBACK (self_tray_destroyed), self);

		g_signal_connect(G_OBJECT(selfp->tray_icon), "drag-data-received",
				G_CALLBACK(self_drag_data_received_cb), self);
		gtk_drag_dest_set(GTK_WIDGET(selfp->tray_icon),
				GTK_DEST_DEFAULT_ALL,
				target_table, G_N_ELEMENTS (target_table),
				GDK_ACTION_COPY);
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_shell_tray_destroyed (GtkWidget * widget, GdkEvent * event, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::tray_destroyed"
	g_return_val_if_fail (!(self) || IS_SELF (self), (gboolean )0);
{
	
		if(selfp->config->tray_icon){
			g_object_unref(widget);
			gtk_widget_destroy(selfp->popup_menu);
			g_idle_add((GSourceFunc) self_init_tray, self);
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_prefs_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::prefs_activate_cb"
{
	
		Self *self = SELF(data);
		self_show_prefs(self);
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_about_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::about_activate_cb"
{
	
		Self *self = SELF(data);
		self_show_about(self);
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_help_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::help_activate_cb"
{
	
		GError *error = NULL;
		GtkWidget *dialog;

		gnome_help_display ("lumiere.xml", NULL, &error);
		if (error) {
			dialog = hig_alert_new (NULL,	GTK_DIALOG_MODAL, 
					HIG_ALERT_ERROR, _("Cannot display help."), NULL,
					GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
			hig_alert_set_secondary_printf (HIG_ALERT (dialog),
					error->message);
			g_signal_connect (G_OBJECT (dialog), "response",
				  G_CALLBACK (gtk_widget_destroy), NULL);
			gtk_widget_show (dialog);
			g_error_free (error);
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_shell_quit_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::quit_activate_cb"
{
	
		LumSession *session = self_get_session(lum_shell);
		lum_session_close(session);
		self_set_server_mode(lum_shell, FALSE);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_new_engine_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::new_engine_activate_cb"
{
	
		lum_engine_new();
		/* this looks good but I have to implement treeview in a menu in order to use it */
#if 0
		Self *self = SELF(data);
		GtkWidget *menu, *menu2;
		GtkMenuItem *item, *item2;
		menu = gtk_menu_new();

		GList *list = lum_session_get_engines(selfp->session);
		if(list){
			int i = 1;
			for(; list != NULL; list = list->next, i++){
				GList *playlist = NULL;
				item = GTK_MENU_ITEM(gtk_menu_item_new_with_label(
						g_strdup_printf("Player %d", i)));
				gtk_widget_show(GTK_WIDGET(item));
				gtk_menu_shell_append (GTK_MENU_SHELL(menu),
						GTK_WIDGET(item));
				playlist = lum_engine_get_list(LUM_ENGINE(list->data));
				if(playlist){
					menu2 = gtk_menu_new();
					for(; playlist != NULL; playlist = playlist->next){
						item2 = GTK_MENU_ITEM(gtk_menu_item_new_with_label(
										g_strdup(playlist->data)));
						gtk_widget_show(GTK_WIDGET(item2));
						gtk_menu_shell_append (GTK_MENU_SHELL(menu2),
								GTK_WIDGET(item2));
					}
					gtk_menu_item_set_submenu(item, GTK_WIDGET(menu2));
				}
			}
			gtk_menu_item_set_submenu(menuitem, menu);
		}
#endif
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_close_engine_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::close_engine_activate_cb"
{
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_close(engine);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_open_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::open_activate_cb"
{
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = lum_engine_new();
		lum_engine_show_fileselector(engine);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_audio_cd_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::audio_cd_activate_cb"
{
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = lum_engine_new();
		lum_engine_open_cdda(engine);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_dvd_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::dvd_activate_cb"
{
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = lum_engine_new();
		lum_engine_open_dvd(engine);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_play_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::play_activate_cb"
{
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_pause(engine);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_stop_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::stop_activate_cb"
{
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_stop(engine);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_next_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::next_activate_cb"
{
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_next(engine);
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_prev_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Shell::prev_activate_cb"
{
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_prev(engine);
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_shell_tray_icon_release_cb (GtkWidget * widget, GdkEventButton * event, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::tray_icon_release_cb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (IS_SELF (self), (gboolean )0);
{
	
		if (event->button == 3){
			gtk_menu_popdown (GTK_MENU(selfp->popup_menu));
			return FALSE;
		} else if (event->button == 1){
			GList *list = lum_session_get_engines(selfp->session);
			for(; list; list = list->next)
				lum_engine_iconify(LUM_ENGINE(list->data));
			return FALSE;
		}

		return TRUE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_shell_tray_icon_press_cb (GtkWidget * widget, GdkEventButton * event, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Shell::tray_icon_press_cb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (IS_SELF (self), (gboolean )0);
{
	
		if (event->button == 3){
			LumEngine *engine = self_get_active_engine(self);
			GList *list = NULL;
			if(!engine || !(list = lum_engine_get_list(engine))){
				gtk_widget_hide(selfp->play_item);
				gtk_widget_hide(selfp->stop_item);
				gtk_widget_hide(selfp->next_item);
				gtk_widget_hide(selfp->prev_item);
				if(!engine)
					gtk_widget_hide(selfp->close_engine_item);
				else
					gtk_widget_show(selfp->close_engine_item);
			} else {
				gtk_widget_show(selfp->close_engine_item);
				gtk_widget_show(selfp->play_item);
				gtk_widget_show(selfp->stop_item);
				if(!list || g_list_length(list) < 2){
					gtk_widget_hide(selfp->next_item);
					gtk_widget_hide(selfp->prev_item);
				} else {
					gtk_widget_show(selfp->next_item);
					gtk_widget_show(selfp->prev_item);
				}
			}
			gtk_menu_popup (GTK_MENU(selfp->popup_menu),
					NULL, NULL, NULL,
					NULL, event->button, event->time);
			return TRUE;
		}
		if (event->button == 2){
			lum_engine_pause(self_get_active_engine(self));
			return TRUE;
		}
		return FALSE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_shell_drag_data_received_cb (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, gpointer user_data)
{
#define __GOB_FUNCTION__ "Lum:Shell::drag_data_received_cb"
{
	
		Self *self = SELF(user_data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = lum_engine_new();
		lum_util_drag_received(engine, context, data, time);
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_shell_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	((void (*)(void))self_new_engine)();
	((void (*)(void))self_get_active_engine)();
	((void (*)(void))self_set_active_engine)();
	((void (*)(void))self_get_session)();
	((void (*)(void))self_get_config)();
	((void (*)(void))self_get_server_mode)();
	((void (*)(void))self_set_server_mode)();
	((void (*)(void))self_get_tray_icon)();
	((void (*)(void))self_set_tray_icon)();
	((void (*)(void))self_show_prefs)();
	((void (*)(void))self_show_about)();
	((void (*)(void))self_set_tip)();
	((void (*)(void))self_xf86audio_filter)();
	((void (*)(void))self_grab_key)();
	((void (*)(void))self_grab_keys)();
	((void (*)(void))self_ungrab_key)();
	((void (*)(void))self_ungrab_keys)();
	((void (*)(void))self_init_tray)();
	((void (*)(void))self_tray_destroyed)();
	((void (*)(void))self_prefs_activate_cb)();
	((void (*)(void))self_about_activate_cb)();
	((void (*)(void))self_help_activate_cb)();
	((void (*)(void))self_quit_activate_cb)();
	((void (*)(void))self_new_engine_activate_cb)();
	((void (*)(void))self_close_engine_activate_cb)();
	((void (*)(void))self_open_activate_cb)();
	((void (*)(void))self_audio_cd_activate_cb)();
	((void (*)(void))self_dvd_activate_cb)();
	((void (*)(void))self_play_activate_cb)();
	((void (*)(void))self_stop_activate_cb)();
	((void (*)(void))self_next_activate_cb)();
	((void (*)(void))self_prev_activate_cb)();
	((void (*)(void))self_tray_icon_release_cb)();
	((void (*)(void))self_tray_icon_press_cb)();
	((void (*)(void))self_drag_data_received_cb)();
	___lum_shell_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

