/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include "lum-util.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */


#include <config.h>
#include "lum-player-info.h"
#include <unistd.h>
#include <string.h>
#include <libgnomevfs/gnome-vfs.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

/* self casting macros */
#define SELF(x) LUM_UTIL(x)
#define SELF_CONST(x) LUM_UTIL_CONST(x)
#define IS_SELF(x) LUM_IS_UTIL(x)
#define TYPE_SELF LUM_TYPE_UTIL
#define SELF_CLASS(x) LUM_UTIL_CLASS(x)

#define SELF_GET_CLASS(x) LUM_UTIL_GET_CLASS(x)

/* self typedefs */
typedef LumUtil Self;
typedef LumUtilClass SelfClass;

/* here are local prototypes */
static void lum_util_init (LumUtil * o) G_GNUC_UNUSED;
static void lum_util_class_init (LumUtilClass * c) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_general_tmp_filename(args...) lum_util_general_tmp_filename(args)
#define self_xmlGetIntProp(args...) lum_util_xmlGetIntProp(args)
#define self_drag_received(args...) lum_util_drag_received(args)
#define self_show_props_window(args...) lum_util_show_props_window(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static char * (* const self_general_tmp_filename) (const char * base, const char * extension) = lum_util_general_tmp_filename;
static gint (* const self_xmlGetIntProp) (xmlNodePtr node, const gchar * attribute) = lum_util_xmlGetIntProp;
static void (* const self_drag_received) (LumEngine * engine, GdkDragContext * context, GtkSelectionData * data, guint time) = lum_util_drag_received;
static void (* const self_show_props_window) (LumPlayerInfo * info) = lum_util_show_props_window;

GType
lum_util_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumUtilClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_util_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumUtil),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_util_init,
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumUtil", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumUtil *)g_object_new(lum_util_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumUtil * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumUtil *
GET_NEW_VARG (const char *first, ...)
{
	LumUtil *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumUtil *)g_object_new_valist (lum_util_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
lum_util_init (LumUtil * o)
{
#define __GOB_FUNCTION__ "Lum:Util::init"
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_util_class_init (LumUtilClass * c)
{
#define __GOB_FUNCTION__ "Lum:Util::class_init"

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	return;
	c = NULL;
}
#undef __GOB_FUNCTION__



char * 
lum_util_general_tmp_filename (const char * base, const char * extension)
{
#define __GOB_FUNCTION__ "Lum:Util::general_tmp_filename"
{
	
		int fd;
		char *name = g_strdup (base);
		fd = mkstemp (name);

		if (fd != -1) {
			unlink (name);
			close (fd);
		} else {
			return NULL;
		}
		if (extension) {
			char *tmp;
			tmp = g_strconcat (name, ".", 
  					extension, NULL);
			g_free (name);
			name = tmp;
		}
		return name;
	}}
#undef __GOB_FUNCTION__

gint 
lum_util_xmlGetIntProp (xmlNodePtr node, const gchar * attribute)
{
#define __GOB_FUNCTION__ "Lum:Util::xmlGetIntProp"
{
	
		char *string_value;
		int value = -1;

		/* get the attribute as a string */
		string_value = xmlGetProp (node, attribute);
	
		if (string_value){
		/* convert to integer */
			value = strtol (string_value, NULL, 10);

			/* free allocated string */
			xmlFree (string_value);
		}
		/* return discovered value */
		return value;
	}}
#undef __GOB_FUNCTION__

void 
lum_util_drag_received (LumEngine * engine, GdkDragContext * context, GtkSelectionData * data, guint time)
{
#define __GOB_FUNCTION__ "Lum:Util::drag_received"
	g_return_if_fail (engine != NULL);
	g_return_if_fail (LUM_IS_ENGINE (engine));
{
	
		GList *list, *p, *file_list;

		list = gnome_vfs_uri_list_parse (data->data);

		if (list == NULL) {
			gtk_drag_finish (context, FALSE, FALSE, time);
			return;
		}

		p = list;
		file_list = NULL;

		for(; p != NULL; p = p->next){
			file_list = g_list_prepend (file_list,
					gnome_vfs_uri_to_string
					((const GnomeVFSURI*)(p->data), 0));
		}

		gnome_vfs_uri_list_free (list);
		file_list = g_list_reverse (file_list);

		if (file_list == NULL){
			gtk_drag_finish (context, FALSE, FALSE, time);
			return;
		}

		for (p = file_list; p != NULL; p = p->next){
			char *filename;

			if (p->data == NULL)
				continue;

			filename = gnome_vfs_get_local_path_from_uri(p->data);
			if (filename == NULL)
				filename = g_strdup (p->data);

			if (filename != NULL &&
				(g_file_test (filename, G_FILE_TEST_IS_REGULAR
					| G_FILE_TEST_EXISTS)
					 || strstr (filename, "://") != NULL))
				lum_engine_enqueue(engine, filename);
			g_free (p->data);
		}
		g_list_free (file_list);
		gtk_drag_finish (context, TRUE, FALSE, time);
	}}
#undef __GOB_FUNCTION__

void 
lum_util_show_props_window (LumPlayerInfo * info)
{
#define __GOB_FUNCTION__ "Lum:Util::show_props_window"
	g_return_if_fail (info != NULL);
	g_return_if_fail (LUM_IS_PLAYER_INFO (info));
{
	
		GtkWidget *window, *widget, *box;
		GladeXML *xml;
			
		widget = lum_player_info_get_widget(info);
		if(GTK_WIDGET_REALIZED(widget))
			return;

		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
					"property_window", GETTEXT_PACKAGE);
		g_assert(xml != NULL);
		window = glade_xml_get_widget(xml, "property_window");
		g_assert(GTK_IS_WIDGET(widget));
		box = glade_xml_get_widget(xml, "prop_vbox");
		gtk_container_add(GTK_CONTAINER(box), widget);
		widget = glade_xml_get_widget(xml, "close_button");
		g_signal_connect_swapped(G_OBJECT(widget), "clicked",
				G_CALLBACK(gtk_widget_destroy), window);
		gtk_widget_show_all(window);
		g_object_unref(xml);
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_util_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_general_tmp_filename)();
	((void (*)(void))self_xmlGetIntProp)();
	((void (*)(void))self_drag_received)();
	((void (*)(void))self_show_props_window)();
	___lum_util_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

