/* Generated by GOB (v2.0.11) on Sat Apr 16 19:56:21 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-automation.gob"

/***************************************************************************
                          lum-automation.gob  -  Lumiere Corba Implementation 
                             -------------------
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.8 $
 * $Date: 2005/01/16 01:41:24 $
 *
 */

#line 34 "lum-automation.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-automation.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 37 "lum-automation.gob"

#include "lum-engine-server.h"
#include <config.h>

#define LUM_FACTORY_OAFIID "OAFIID:GNOME_Lum_Automation_Factory"

typedef struct {
	char *uri;
	gboolean open_in_existing_window : TRUE;
	gboolean open_in_new_window : TRUE;
	gboolean enqueue : TRUE;
} LumAutomationData;

extern LumShell *lum_shell;

#line 69 "lum-automation.c"

#line 53 "lum-automation.gob"

/** Most code comes from galeon-automation.c from the galeon project,
 * http://galeon.sf.net
 */

#line 77 "lum-automation.c"
/* self casting macros */
#define SELF(x) LUM_AUTOMATION(x)
#define SELF_CONST(x) LUM_AUTOMATION_CONST(x)
#define IS_SELF(x) LUM_IS_AUTOMATION(x)
#define TYPE_SELF LUM_TYPE_AUTOMATION
#define SELF_CLASS(x) LUM_AUTOMATION_CLASS(x)

#define SELF_GET_CLASS(x) LUM_AUTOMATION_GET_CLASS(x)

/* self typedefs */
typedef LumAutomation Self;
typedef LumAutomationClass SelfClass;

/* here are local prototypes */
static void lum_automation_class_init (LumAutomationClass * c) G_GNUC_UNUSED;
static void lum_automation_init (LumAutomation * self) G_GNUC_UNUSED;
static BonoboObject * lum_automation_factory (BonoboGenericFactory * this_factory, const char * iid, gpointer user_data) G_GNUC_UNUSED;
static void lum_automation_load_uri (const char * uri, gboolean open_in_existing_window, gboolean open_in_new_window, gboolean enqueue) G_GNUC_UNUSED;
static CORBA_boolean lum_automation_loaduri (PortableServer_Servant servant, const CORBA_char * uri, const CORBA_boolean open_in_existing_window, const CORBA_boolean open_in_new_window, const CORBA_boolean enqueue, CORBA_Environment * ev) G_GNUC_UNUSED;
static CORBA_boolean lum_automation_loadsession (PortableServer_Servant servant, const CORBA_char * session_filename, CORBA_Environment * ev) G_GNUC_UNUSED;
static CORBA_boolean lum_automation_quit (PortableServer_Servant _servant, const CORBA_boolean disableServer, CORBA_Environment * ev) G_GNUC_UNUSED;
static CORBA_boolean lum_automation_setServerMode (PortableServer_Servant servant, const CORBA_boolean mode, CORBA_Environment * ev) G_GNUC_UNUSED;
static GNOME_Lum_Engine lum_automation_getDefaultEngine (PortableServer_Servant servant, CORBA_Environment * ev) G_GNUC_UNUSED;
static GNOME_Lum_Engine lum_automation_newEngine (PortableServer_Servant servant, CORBA_Environment * ev) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboObjectClass *parent_class = NULL;

/* Short form macros */
#define self_complete_initialization lum_automation_complete_initialization
#define self_factory_new lum_automation_factory_new
#define self_factory lum_automation_factory
#define self_load_uri lum_automation_load_uri
#define self_loaduri lum_automation_loaduri
#define self_loadsession lum_automation_loadsession
#define self_quit lum_automation_quit
#define self_setServerMode lum_automation_setServerMode
#define self_getDefaultEngine lum_automation_getDefaultEngine
#define self_newEngine lum_automation_newEngine
GType
lum_automation_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumAutomationClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_automation_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (LumAutomation),
			0, /* n_preallocs */
			(GInstanceInitFunc)  lum_automation_init,
			NULL
		};

		type = bonobo_type_unique (
			BONOBO_OBJECT_TYPE,
			POA_GNOME_Lum_Automation__init, NULL,
			G_STRUCT_OFFSET (LumAutomationClass, _epv),
			&info, "LumAutomation");
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumAutomation *)g_object_new(lum_automation_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumAutomation * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumAutomation *
GET_NEW_VARG (const char *first, ...)
{
	LumAutomation *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumAutomation *)g_object_new_valist (lum_automation_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
lum_automation_class_init (LumAutomationClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Automation::class_init"
#line 53 "lum-automation.gob"
	c->initialized = FALSE;
#line 169 "lum-automation.c"
#line 53 "lum-automation.gob"
	c->postponed_loaduris = NULL;
#line 172 "lum-automation.c"

	parent_class = g_type_class_ref (BONOBO_TYPE_OBJECT);

#line 172 "lum-automation.gob"
	c->_epv.loaduri = self_loaduri;
#line 198 "lum-automation.gob"
	c->_epv.loadsession = self_loadsession;
#line 209 "lum-automation.gob"
	c->_epv.quit = self_quit;
#line 226 "lum-automation.gob"
	c->_epv.setServerMode = self_setServerMode;
#line 238 "lum-automation.gob"
	c->_epv.getDefaultEngine = self_getDefaultEngine;
#line 245 "lum-automation.gob"
	c->_epv.newEngine = self_newEngine;
#line 188 "lum-automation.c"
}
#undef __GOB_FUNCTION__
#line 62 "lum-automation.gob"
static void 
lum_automation_init (LumAutomation * self G_GNUC_UNUSED)
#line 194 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::init"
 {
#line 62 "lum-automation.gob"

#ifndef NDEBUG
		printf(__FILE__ ": init\n");
#endif
	
#line 204 "lum-automation.c"
 }
}
#undef __GOB_FUNCTION__



/**
 * lum_automation_complete_initialization:
 *
 * @self: the automation instance.
 * @load_session: whether we load a previously saved session.
 *
 * Called once the #LumShell is ready to go,
 * will load the uris that were given in the command
 * line
 **/
#line 78 "lum-automation.gob"
void 
lum_automation_complete_initialization (LumAutomation * self, gboolean load_session)
#line 224 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::complete_initialization"
#line 78 "lum-automation.gob"
	g_return_if_fail (self != NULL);
#line 78 "lum-automation.gob"
	g_return_if_fail (LUM_IS_AUTOMATION (self));
#line 231 "lum-automation.c"
{
#line 78 "lum-automation.gob"
	
		LumSession *session = NULL;

		if(load_session){
			session = g_object_ref(lum_shell_get_session (lum_shell));

			if (lum_shell_get_engines(lum_shell) == NULL) {
				LumSessionResumeType res;
				res = lum_session_autoresume (session);
				/* TODO not used */
				if ( res == SESSION_ABORT ) {
					GSList * iterator;
					for( iterator =
							SELF_GET_CLASS(self)->postponed_loaduris ;
							iterator ; iterator = iterator->next) {
						LumAutomationData *data = iterator->data;
						g_free (data->uri);
						g_free (data);
					}
					g_slist_free (SELF_GET_CLASS(self)->postponed_loaduris);
					lum_shell_set_server_mode (lum_shell, FALSE);
					return;
				}
				
				if (res == SESSION_RESUMED &&
						SELF_GET_CLASS(self)->postponed_loaduris) {
					GSList *last = g_slist_last (
							SELF_GET_CLASS(self)->postponed_loaduris);
					LumAutomationData *data = last->data;
					if (data->uri == NULL || *data->uri == 0) {
						SELF_GET_CLASS(self)->postponed_loaduris =
							g_slist_delete_link (
									SELF_GET_CLASS(self)->postponed_loaduris,
									last);
						g_free (data->uri);
						g_free (data);
					}
				}
			}
			g_object_unref(session);
		}
		while (SELF_GET_CLASS(self)->postponed_loaduris) {
			GSList *internal_postponed, *iterator;

			internal_postponed = g_slist_reverse (
					SELF_GET_CLASS(self)->postponed_loaduris);
			SELF_GET_CLASS(self)->postponed_loaduris = NULL;

			for (iterator = internal_postponed; iterator; iterator = iterator->next) {
				LumAutomationData *data = iterator->data;
				self_load_uri (data->uri,
						   data->open_in_existing_window,
						   data->open_in_new_window,
						   data->enqueue);
				g_free (data->uri);
				g_free (data);
			}
			g_slist_free (internal_postponed);
		}
		SELF_GET_CLASS(self)->initialized = TRUE;
	}}
#line 295 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 140 "lum-automation.gob"
BonoboGenericFactory * 
lum_automation_factory_new (void)
#line 301 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::factory_new"
{
#line 140 "lum-automation.gob"
	
		return bonobo_generic_factory_new (LUM_FACTORY_OAFIID,
					self_factory, NULL);
	}}
#line 310 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 145 "lum-automation.gob"
static BonoboObject * 
lum_automation_factory (BonoboGenericFactory * this_factory, const char * iid, gpointer user_data)
#line 316 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::factory"
{
#line 147 "lum-automation.gob"
	
		return BONOBO_OBJECT(GET_NEW);
	}}
#line 324 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 151 "lum-automation.gob"
static void 
lum_automation_load_uri (const char * uri, gboolean open_in_existing_window, gboolean open_in_new_window, gboolean enqueue)
#line 330 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::load_uri"
{
#line 154 "lum-automation.gob"
	
		g_object_ref(lum_shell);
		LumEngine *engine = lum_shell_get_active_engine(lum_shell);

		if (open_in_existing_window && engine != NULL) {
			lum_engine_load_uri(engine, uri);
		} else if (enqueue && engine != NULL) {
			lum_engine_enqueue(engine, uri);
		} else if (open_in_new_window){
			engine = lum_shell_new_engine(lum_shell);
			lum_engine_load_uri(engine, uri);
		} else {
			engine = lum_shell_new_engine(lum_shell);
			lum_engine_load_uri(engine, uri);
		}
		g_object_unref(lum_shell);
	}}
#line 352 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 172 "lum-automation.gob"
static CORBA_boolean 
lum_automation_loaduri (PortableServer_Servant servant, const CORBA_char * uri, const CORBA_boolean open_in_existing_window, const CORBA_boolean open_in_new_window, const CORBA_boolean enqueue, CORBA_Environment * ev)
#line 358 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::loaduri"
{
#line 178 "lum-automation.gob"
	
		Self *self = SELF(bonobo_object_from_servant(servant));
		if (SELF_GET_CLASS(self)->initialized) {
			self_load_uri (uri, open_in_existing_window,
					open_in_new_window,
					enqueue );
		} else {
			LumAutomationData *data = g_new (LumAutomationData, 1);

			data->uri = g_strdup (uri);
			data->open_in_existing_window = open_in_existing_window;
			data->open_in_new_window = open_in_new_window;
			data->enqueue = enqueue;

			SELF_GET_CLASS(self)->postponed_loaduris = g_slist_prepend (
					SELF_GET_CLASS(self)->postponed_loaduris, data);
		}
		return TRUE;
	}}
#line 382 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 198 "lum-automation.gob"
static CORBA_boolean 
lum_automation_loadsession (PortableServer_Servant servant, const CORBA_char * session_filename, CORBA_Environment * ev)
#line 388 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::loadsession"
{
#line 201 "lum-automation.gob"
	
		CORBA_boolean retval = TRUE;
		LumSession *session  = g_object_ref(lum_shell_get_session (lum_shell));
		lum_session_load(session, session_filename);
		g_object_unref(session);
		return retval;
	}}
#line 400 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 209 "lum-automation.gob"
static CORBA_boolean 
lum_automation_quit (PortableServer_Servant _servant, const CORBA_boolean disableServer, CORBA_Environment * ev)
#line 406 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::quit"
{
#line 212 "lum-automation.gob"
	
		CORBA_boolean retval = TRUE;
		LumShell *shell;

		if(lum_shell){
			shell = g_object_ref (lum_shell);
			lum_session_close (lum_shell_get_session (lum_shell));
			if (disableServer)
				lum_shell_set_server_mode (lum_shell, FALSE);
			g_object_unref (lum_shell);
		}
		return retval;
	}}
#line 424 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 226 "lum-automation.gob"
static CORBA_boolean 
lum_automation_setServerMode (PortableServer_Servant servant, const CORBA_boolean mode, CORBA_Environment * ev)
#line 430 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::setServerMode"
{
#line 229 "lum-automation.gob"
	
		CORBA_boolean retval = TRUE;

		lum_config_set_server(lum_shell_get_config(lum_shell),
				mode ? TRUE : FALSE);

		return retval;
	}}
#line 443 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 238 "lum-automation.gob"
static GNOME_Lum_Engine 
lum_automation_getDefaultEngine (PortableServer_Servant servant, CORBA_Environment * ev)
#line 449 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::getDefaultEngine"
{
#line 240 "lum-automation.gob"
	
		return BONOBO_OBJREF(lum_engine_server_new(
				lum_shell_get_active_engine(lum_shell)));
	}}
#line 458 "lum-automation.c"
#undef __GOB_FUNCTION__

#line 245 "lum-automation.gob"
static GNOME_Lum_Engine 
lum_automation_newEngine (PortableServer_Servant servant, CORBA_Environment * ev)
#line 464 "lum-automation.c"
{
#define __GOB_FUNCTION__ "Lum:Automation::newEngine"
{
#line 247 "lum-automation.gob"
	
		return BONOBO_OBJREF(lum_engine_server_new(
				g_object_new(LUM_TYPE_ENGINE, NULL)));
	}}
#line 473 "lum-automation.c"
#undef __GOB_FUNCTION__
